/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.DATAREADERVIEW_QOS_DEFAULT;
import DDS.DATAREADER_QOS_DEFAULT;
import DDS.DATAREADER_QOS_USE_TOPIC_QOS;
import DDS.DataReader;
import DDS.DataReaderListener;
import DDS.DataReaderQos;
import DDS.DataReaderQosHolder;
import DDS.DataReaderView;
import DDS.DataReaderViewQos;
import DDS.DataReaderViewQosHolder;
import DDS.Duration_t;
import DDS.InstanceHandleSeqHolder;
import DDS.LivelinessChangedStatus;
import DDS.LivelinessChangedStatusHolder;
import DDS.Property;
import DDS.PropertyHolder;
import DDS.PublicationBuiltinTopicDataHolder;
import DDS.QueryCondition;
import DDS.ReadCondition;
import DDS.RequestedDeadlineMissedStatus;
import DDS.RequestedDeadlineMissedStatusHolder;
import DDS.RequestedIncompatibleQosStatus;
import DDS.RequestedIncompatibleQosStatusHolder;
import DDS.ResourceLimitsQosPolicy;
import DDS.SampleLostStatus;
import DDS.SampleLostStatusHolder;
import DDS.SampleRejectedStatus;
import DDS.SampleRejectedStatusHolder;
import DDS.StringSeqHolder;
import DDS.Subscriber;
import DDS.SubscriptionMatchedStatus;
import DDS.SubscriptionMatchedStatusHolder;
import DDS.TOPIC_QOS_DEFAULT;
import DDS.Time_t;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.omg.CORBA.ORB;
import org.opensplice.dds.dcps.ContentFilteredTopicImpl;
import org.opensplice.dds.dcps.DataReaderBase;
import org.opensplice.dds.dcps.DataReaderViewImpl;
import org.opensplice.dds.dcps.Event;
import org.opensplice.dds.dcps.MultiTopicImpl;
import org.opensplice.dds.dcps.QueryConditionImpl;
import org.opensplice.dds.dcps.ReadConditionImpl;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.SubscriberImpl;
import org.opensplice.dds.dcps.TopicDescription;
import org.opensplice.dds.dcps.TopicImpl;
import org.opensplice.dds.dcps.Utilities;

public class DataReaderImpl
extends DataReaderBase
implements DataReader {
    private static final long serialVersionUID = 7369562459575330228L;
    private final ArrayList<Thread> workers = new ArrayList();
    private DataReaderViewQos defaultDataReaderViewQos = Utilities.defaultDataReaderViewQos;
    private long parallelDemarshallingContext = 0L;
    private String name;
    private SubscriberImpl subscriber = null;
    private DDS.TopicDescription description = null;
    private DataReaderListener listener = null;
    private final Set<DataReaderViewImpl> views = new HashSet<DataReaderViewImpl>();
    private final Set<ReadConditionImpl> conditions = new HashSet<ReadConditionImpl>();
    private final long CDRCopy = 0L;
    private ORB orb = null;
    private Constructor<InputStream> CDRInputStreamConstructor;
    private Method CDRHelperRead;

    protected DataReaderImpl() {
    }

    protected int init(SubscriberImpl subscriber, String name, DDS.TopicDescription description, DataReaderQos qos) {
        int result = 0;
        String expression = null;
        StringSeqHolder parameters = new StringSeqHolder();
        if (description instanceof TopicImpl) {
            expression = new String("select * from " + ((TopicImpl)description).get_name());
        } else if (description instanceof ContentFilteredTopicImpl) {
            expression = new String("select * from " + ((ContentFilteredTopicImpl)description).get_related_topic().get_name() + " where " + ((ContentFilteredTopicImpl)description).get_filter_expression());
            ((ContentFilteredTopicImpl)description).get_expression_parameters(parameters);
        } else {
            result = description instanceof MultiTopicImpl ? 2 : 3;
        }
        if (result == 0) {
            long uSubscriber = subscriber.get_user_object();
            if (uSubscriber != 0L) {
                this.subscriber = subscriber;
                this.name = name;
                this.description = description;
                long uReader = this.jniDataReaderNew(uSubscriber, name, expression, parameters.value, qos);
                if (uReader != 0L) {
                    ((TopicDescription)((Object)description)).keep();
                    this.set_user_object(uReader);
                    this.setDomainId(subscriber.getDomainId());
                } else {
                    this.subscriber = null;
                    this.name = null;
                    this.description = null;
                    result = 1;
                }
            } else {
                result = 9;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deinit() {
        int result = 0;
        long uReader = 0L;
        DataReaderImpl dataReaderImpl = this;
        synchronized (dataReaderImpl) {
            uReader = this.get_user_object();
            if (uReader != 0L) {
                if (this.conditions.size() != 0) {
                    result = 4;
                    ReportStack.report(result, "DataReader still contains '" + this.conditions.size() + "' Condition entities.");
                } else if (this.views.size() != 0) {
                    result = 4;
                    ReportStack.report(result, "DataReader still contains '" + this.views.size() + "' DataReaderView entities.");
                } else {
                    if (this.listener != null) {
                        result = this.set_listener(this.listener, 0);
                    }
                    if (result == 0 && (result = this.disable_callbacks()) == 0 && (result = this.detach_statuscondition()) == 0) {
                        ((TopicDescription)((Object)this.description)).free();
                        this.name = null;
                        this.subscriber = null;
                        this.description = null;
                        result = this.jniDataReaderFree(uReader);
                        if (result == 0) {
                            result = super.deinit();
                        }
                    }
                }
            } else {
                result = 9;
            }
        }
        return result;
    }

    private int startWorkers(int nrOfWorkers) {
        int started = 0;
        assert (this.workers.size() == 0);
        if (this.parallelDemarshallingContext != 0L) {
            class Worker
            implements Runnable {
                Worker() {
                }

                @Override
                public void run() {
                    assert (DataReaderImpl.this.parallelDemarshallingContext != 0L);
                    DataReaderImpl.this.jniParallelDemarshallingMain(DataReaderImpl.this.parallelDemarshallingContext);
                }
            }
            Worker worker = new Worker();
            for (started = 0; started < nrOfWorkers; ++started) {
                Thread t = new Thread(worker);
                t.setDaemon(true);
                this.workers.add(started, t);
                t.start();
            }
        }
        return started;
    }

    private void joinWorkers() {
        try {
            for (Thread t : this.workers) {
                t.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.workers.clear();
    }

    private boolean CDRCopySetupHelper() {
        if (this.orb == null) {
            this.orb = ORB.init();
        }
        try {
            if (this.CDRHelperRead == null) {
                String name = this.getClass().getName();
                if (!name.endsWith("DataReaderImpl")) {
                    ReportStack.report(1, "CDRDeserializeByteBuffer unexpected class name: " + name);
                    return false;
                }
                String helperName = name.substring(0, name.length() - 14).concat("Helper");
                Class<?> helperClass = Class.forName(helperName);
                Class<?> isClass = Class.forName("org.jacorb.orb.CDRInputStream");
                this.CDRInputStreamConstructor = isClass.getConstructor(byte[].class);
                Class<?> absIsClass = Class.forName("org.omg.CORBA.portable.InputStream");
                this.CDRHelperRead = helperClass.getMethod("read", absIsClass);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    private Object CDRDeserializeByteBuffer(ByteBuffer buf) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        byte[] myBuf = new byte[buf.capacity()];
        buf.get(myBuf);
        InputStream in = this.CDRInputStreamConstructor.newInstance(new Object[]{myBuf});
        Object obj = this.CDRHelperRead.invoke(null, in);
        try {
            in.close();
        }
        catch (IOException e) {
            ReportStack.report(1, "CDRDeserializeByteBuffer: IOException when closing stream.");
            obj = null;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadCondition create_readcondition(int sample_states, int view_states, int instance_states) {
        int result = 0;
        ReadConditionImpl readCondition = null;
        ReportStack.start();
        result = Utilities.checkSampleStateMask(sample_states);
        if (result == 0 && (result = Utilities.checkViewStateMask(view_states)) == 0 && (result = Utilities.checkInstanceStateMask(instance_states)) == 0) {
            readCondition = new ReadConditionImpl();
            DataReaderImpl dataReaderImpl = this;
            synchronized (dataReaderImpl) {
                result = readCondition.init(this, sample_states, view_states, instance_states, 0L);
                if (result == 0) {
                    this.conditions.add(readCondition);
                } else {
                    readCondition = null;
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return readCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCondition create_querycondition(int sample_states, int view_states, int instance_states, String query_expression, String[] query_parameters) {
        QueryConditionImpl queryCondition = null;
        int result = 0;
        ReportStack.start();
        result = Utilities.checkSampleStateMask(sample_states);
        if (result == 0 && (result = Utilities.checkViewStateMask(view_states)) == 0 && (result = Utilities.checkInstanceStateMask(instance_states)) == 0) {
            if (query_expression == null) {
                result = 3;
                ReportStack.report(result, "query_expression 'null' is invalid.");
            } else {
                queryCondition = new QueryConditionImpl();
                DataReaderImpl dataReaderImpl = this;
                synchronized (dataReaderImpl) {
                    result = queryCondition.init(this, sample_states, view_states, instance_states, query_expression, query_parameters);
                    if (result == 0) {
                        this.conditions.add(queryCondition);
                    } else {
                        queryCondition = null;
                    }
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return queryCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_readcondition(ReadCondition a_condition) {
        int result = 0;
        ReportStack.start();
        if (this.get_user_object() != 0L) {
            if (a_condition != null) {
                DataReaderImpl dataReaderImpl = this;
                synchronized (dataReaderImpl) {
                    ReadConditionImpl rc = (ReadConditionImpl)a_condition;
                    if (this.conditions.remove(rc)) {
                        result = rc.deinit();
                        if (result != 0) {
                            this.conditions.add(rc);
                        }
                    } else if (rc.get_user_object() == 0L) {
                        result = 9;
                    } else {
                        result = 4;
                        ReportStack.report(result, "Condition not created by DataReader.");
                    }
                }
            } else {
                result = 3;
                ReportStack.report(result, "a_condition 'null' is invalid.");
            }
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_contained_entities() {
        int endResult = 0;
        ReportStack.start();
        DataReaderImpl dataReaderImpl = this;
        synchronized (dataReaderImpl) {
            if (this.get_user_object() != 0L) {
                int result;
                Iterator<ReadConditionImpl> it = this.conditions.iterator();
                while (it.hasNext()) {
                    result = it.next().deinit();
                    if (result == 0 || result == 9) {
                        it.remove();
                    }
                    if (result == 0) continue;
                    ReportStack.report(result, "Deletion of ReadCondition contained in DataReader failed.");
                    if (endResult != 0) continue;
                    endResult = result;
                }
                Iterator<DataReaderViewImpl> iv = this.views.iterator();
                while (iv.hasNext()) {
                    DataReaderViewImpl view = iv.next();
                    result = view.delete_contained_entities();
                    if (result == 0) {
                        result = view.deinit();
                        if (result == 0 || result == 9) {
                            iv.remove();
                        }
                        if (result != 0) {
                            ReportStack.report(result, "Deletion of DataReaderView contained in DataReader failed.");
                        }
                    } else {
                        if (result == 9) {
                            iv.remove();
                        }
                        ReportStack.report(result, "delete_contained_entities failed on DataReaderView contained in DataReader.");
                    }
                    if (endResult != 0) continue;
                    endResult = result;
                }
            } else {
                endResult = 9;
            }
        }
        ReportStack.flush(this, endResult != 0);
        return endResult;
    }

    @Override
    public int set_qos(DataReaderQos qos) {
        DataReaderQosHolder holder;
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == DATAREADER_QOS_DEFAULT.value) {
            holder = new DataReaderQosHolder();
            result = this.subscriber.get_default_datareader_qos(holder);
            qos = holder.value;
        } else if (qos == DATAREADER_QOS_USE_TOPIC_QOS.value) {
            holder = new DataReaderQosHolder();
            result = this.subscriber.copy_from_topic_qos(holder, TOPIC_QOS_DEFAULT.value);
            if (result == 0) {
                qos = holder.value;
                result = Utilities.checkQos(qos);
            }
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniSetQos(uReader, qos) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_qos(DataReaderQosHolder qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniGetQos(uReader, qos) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int set_listener(DataReaderListener a_listener, int mask) {
        long uReader = 0L;
        int result = 0;
        ReportStack.start();
        uReader = this.get_user_object();
        if (uReader != 0L) {
            this.listener = a_listener;
            result = this.set_listener_interest(mask);
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public DataReaderListener get_listener() {
        return this.listener;
    }

    @Override
    public DDS.TopicDescription get_topicdescription() {
        return this.description;
    }

    @Override
    public Subscriber get_subscriber() {
        return this.subscriber;
    }

    @Override
    public int get_sample_rejected_status(SampleRejectedStatusHolder status) {
        int result = 0;
        ReportStack.start();
        if (status == null) {
            result = 3;
            ReportStack.report(result, "status 'null' is invalid.");
        } else {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniGetSampleRejectedStatus(uReader, status) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_liveliness_changed_status(LivelinessChangedStatusHolder status) {
        int result = 0;
        ReportStack.start();
        if (status == null) {
            result = 3;
            ReportStack.report(result, "status 'null' is invalid.");
        } else {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniGetLivelinessChangedStatus(uReader, status) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_requested_deadline_missed_status(RequestedDeadlineMissedStatusHolder status) {
        int result = 0;
        ReportStack.start();
        if (status == null) {
            result = 3;
            ReportStack.report(result, "status 'null' is invalid.");
        } else {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniGetRequestedDeadlineMissedStatus(uReader, status) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_requested_incompatible_qos_status(RequestedIncompatibleQosStatusHolder status) {
        int result = 0;
        ReportStack.start();
        if (status == null) {
            result = 3;
            ReportStack.report(result, "status 'null' is invalid.");
        } else {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniGetRequestedIncompatibleQosStatus(uReader, status) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_subscription_matched_status(SubscriptionMatchedStatusHolder status) {
        int result = 0;
        ReportStack.start();
        if (status == null) {
            result = 3;
            ReportStack.report(result, "status 'null' is invalid.");
        } else {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniGetSubscriptionMatchedStatus(uReader, status) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_sample_lost_status(SampleLostStatusHolder status) {
        int result = 0;
        ReportStack.start();
        if (status == null) {
            result = 3;
            ReportStack.report(result, "status 'null' is invalid.");
        } else {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniGetSampleLostStatus(uReader, status) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int wait_for_historical_data(Duration_t max_wait) {
        int result = 0;
        ReportStack.start();
        result = Utilities.checkDuration(max_wait);
        if (result == 0) {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniWaitForHistoricalData(uReader, max_wait) : 9;
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int wait_for_historical_data_w_condition(String filter_expression, String[] expression_parameters, Time_t min_source_timestamp, Time_t max_source_timestamp, ResourceLimitsQosPolicy resource_limits, Duration_t max_wait) {
        int result = 0;
        ReportStack.start();
        result = Utilities.checkTime(min_source_timestamp);
        if (result == 0 && (result = Utilities.checkTime(max_source_timestamp)) == 0 && (result = Utilities.checkPolicy(resource_limits)) == 0 && (result = Utilities.checkDuration(max_wait)) == 0) {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniWaitForHistoricalDataWCondition(uReader, filter_expression, expression_parameters, min_source_timestamp, max_source_timestamp, resource_limits, max_wait) : 9;
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    @Override
    public int get_matched_publications(InstanceHandleSeqHolder publication_handles) {
        int result = 3;
        ReportStack.start();
        if (publication_handles == null) {
            result = 3;
            ReportStack.report(result, "publication_handles 'null' is invalid.");
        } else {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniGetMatchedPublications(uReader, publication_handles) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_matched_publication_data(PublicationBuiltinTopicDataHolder publication_data, long publication_handle) {
        int result = 0;
        ReportStack.start();
        if (publication_data == null) {
            result = 3;
            ReportStack.report(result, "publication_data 'null' is invalid.");
        } else {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniGetMatchedPublicationData(uReader, publication_data, publication_handle) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataReaderView create_view(DataReaderViewQos qos) {
        DataReaderViewImpl view = null;
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == DATAREADERVIEW_QOS_DEFAULT.value) {
            qos = this.defaultDataReaderViewQos;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            view = (DataReaderViewImpl)((TopicDescription)((Object)this.description)).create_dataview();
            result = view.init(this, this.name + "_view", qos);
            if (result == 0) {
                DataReaderImpl dataReaderImpl = this;
                synchronized (dataReaderImpl) {
                    this.views.add(view);
                }
            } else {
                view = null;
            }
        }
        ReportStack.flush(this, result != 0);
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_view(DataReaderView view) {
        int result = 0;
        ReportStack.start();
        if (view == null) {
            result = 3;
            ReportStack.report(result, "view 'null' is invalid.");
        } else {
            DataReaderImpl dataReaderImpl = this;
            synchronized (dataReaderImpl) {
                DataReaderViewImpl drv = (DataReaderViewImpl)view;
                if (this.views.remove(drv)) {
                    result = drv.deinit();
                    if (result != 0) {
                        this.views.add(drv);
                    }
                } else {
                    result = 3;
                    ReportStack.report(result, "DataReaderView not created by DataReader.");
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_default_datareaderview_qos(DataReaderViewQosHolder qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            qos.value = Utilities.deepCopy(this.defaultDataReaderViewQos);
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int set_default_datareaderview_qos(DataReaderViewQos qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == DATAREADERVIEW_QOS_DEFAULT.value) {
            qos = Utilities.defaultDataReaderViewQos;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            qos = Utilities.deepCopy(qos);
            if (this.get_user_object() != 0L) {
                this.defaultDataReaderViewQos = qos;
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int set_property(Property a_property) {
        int result = 0;
        ReportStack.start();
        result = this.checkProperty(a_property);
        if (result == 0) {
            long uReader = this.get_user_object();
            result = uReader != 0L ? this.jniSetProperty(uReader, a_property) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_property(PropertyHolder a_property) {
        int result = 0;
        ReportStack.start();
        long uReader = this.get_user_object();
        result = uReader != 0L ? this.jniGetProperty(uReader, a_property) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    protected int read_instance_handles(InstanceHandleSeqHolder handles) {
        int result = 0;
        ReportStack.start();
        long uReader = this.get_user_object();
        result = uReader != 0L ? this.jniReadInstanceHandles(uReader, handles) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    protected int notify(Event e) {
        int result = 0;
        DataReaderListener drl = this.listener;
        if (drl == null) {
            return result;
        }
        switch (e.kind) {
            case 1024: {
                drl.on_data_available(this);
                break;
            }
            case 4: {
                drl.on_requested_deadline_missed(this, (RequestedDeadlineMissedStatus)e.status);
                break;
            }
            case 64: {
                drl.on_requested_incompatible_qos(this, (RequestedIncompatibleQosStatus)e.status);
                break;
            }
            case 256: {
                drl.on_sample_rejected(this, (SampleRejectedStatus)e.status);
                break;
            }
            case 4096: {
                drl.on_liveliness_changed(this, (LivelinessChangedStatus)e.status);
                break;
            }
            case 128: {
                drl.on_sample_lost(this, (SampleLostStatus)e.status);
                break;
            }
            case 16384: {
                drl.on_subscription_matched(this, (SubscriptionMatchedStatus)e.status);
                break;
            }
            default: {
                ReportStack.report(2, "Received unsupported event kind '" + e.kind + "'.");
            }
        }
        return result;
    }

    private native long jniDataReaderNew(long var1, String var3, String var4, String[] var5, DataReaderQos var6);

    private native int jniDataReaderFree(long var1);

    private native int jniSetQos(long var1, DataReaderQos var3);

    private native int jniGetQos(long var1, DataReaderQosHolder var3);

    private native int jniGetSampleRejectedStatus(long var1, SampleRejectedStatusHolder var3);

    private native int jniGetLivelinessChangedStatus(long var1, LivelinessChangedStatusHolder var3);

    private native int jniGetRequestedDeadlineMissedStatus(long var1, RequestedDeadlineMissedStatusHolder var3);

    private native int jniGetRequestedIncompatibleQosStatus(long var1, RequestedIncompatibleQosStatusHolder var3);

    private native int jniGetSubscriptionMatchedStatus(long var1, SubscriptionMatchedStatusHolder var3);

    private native int jniGetSampleLostStatus(long var1, SampleLostStatusHolder var3);

    private native int jniWaitForHistoricalData(long var1, Duration_t var3);

    private native int jniWaitForHistoricalDataWCondition(long var1, String var3, String[] var4, Time_t var5, Time_t var6, ResourceLimitsQosPolicy var7, Duration_t var8);

    private native int jniGetMatchedPublications(long var1, InstanceHandleSeqHolder var3);

    private native int jniGetMatchedPublicationData(long var1, PublicationBuiltinTopicDataHolder var3, long var4);

    private native int jniParallelDemarshallingMain(long var1);

    private native int jniSetProperty(long var1, Property var3);

    private native int jniGetProperty(long var1, PropertyHolder var3);

    private native int jniReadInstanceHandles(long var1, InstanceHandleSeqHolder var3);
}

