/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.imagenaming;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.Source;

public class ImageNameAssigner
implements AutoCloseable {
    private static final int MAX_RETRIES = 1;
    private Connection conn;
    private PreparedStatement stmt1;
    private PreparedStatement stmt2;
    private final String dbURL;

    public ImageNameAssigner(String dbURL) {
        this.dbURL = dbURL;
    }

    private void openConnection() throws SQLException {
        block49: {
            this.conn = DriverManager.getConnection(this.dbURL);
            this.conn.setAutoCommit(false);
            this.conn.setTransactionIsolation(8);
            try (PreparedStatement stmt = this.conn.prepareStatement("CREATE TABLE IF NOT EXISTS    ccs_counters    (        date VARCHAR(8) NOT NULL,        value INT NOT NULL,        source VARCHAR(6) NOT NULL,        controller VARCHAR(2) NOT NULL,        PRIMARY KEY (source, controller, date)    )");){
                stmt.execute();
            }
            var2_2 = null;
            try (PreparedStatement stmt0 = this.conn.prepareStatement("select source from ccs_counters limit 1");
                 ResultSet rs = stmt0.executeQuery();){
                int sourceSize = rs.getMetaData().getPrecision(1);
                if (sourceSize >= 6) break block49;
                try (PreparedStatement stmt00 = this.conn.prepareStatement("alter table ccs_counters modify column source VARCHAR(6) NOT NULL");){
                    stmt00.execute();
                }
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
        }
        this.stmt1 = this.conn.prepareStatement("insert into ccs_counters (source, controller, date, value) values (?, ?, ?, @cur_value := ?) on duplicate key update value = @cur_value := (value + @cur_value)");
        this.stmt2 = this.conn.prepareStatement("select @cur_value");
    }

    /*
     * Exception decompiling
     */
    private synchronized int[] assignImageNumbers(Source source, int sourceIndex, Controller controller, LocalDate date, int n) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LocalDate assignDate(TimeZone zone, Duration offset, Instant time) {
        Clock clock = Clock.offset(Clock.fixed(time, zone.toZoneId()), offset.negated());
        return LocalDate.now(clock);
    }

    public ImageName assignImageName(Source source, Controller controller, TimeZone zone, Duration offset) throws SQLException {
        return this.assignImageNames(source, controller, zone, offset, 1, null).get(0);
    }

    public ImageName assignImageName(Source source, Controller controller, TimeZone zone, Duration offset, Instant time) throws SQLException {
        return this.assignImageNames(source, controller, zone, offset, 1, time).get(0);
    }

    public List<ImageName> assignImageNames(Source source, Controller controller, TimeZone zone, Duration offset, int n) throws SQLException {
        return this.assignImageNames(source, controller, zone, offset, n, null);
    }

    public List<ImageName> assignImageNames(Source source, Controller controller, TimeZone zone, Duration offset, int n, Instant time) throws SQLException {
        return this.assignImageNames(source, 0, controller, zone, offset, n, time);
    }

    public synchronized List<ImageName> assignImageNames(Source source, int sourceIndex, Controller controller, TimeZone zone, Duration offset, int n, Instant time) throws SQLException {
        LocalDate date = this.assignDate(zone, offset, time == null ? Instant.now() : time);
        int i = 0;
        while (true) {
            if (this.conn == null || this.conn.isClosed()) {
                this.openConnection();
            }
            try {
                int[] imageNumbers = this.assignImageNumbers(source, sourceIndex, controller, date, n);
                ArrayList<ImageName> result = new ArrayList<ImageName>();
                for (int imageNumber : imageNumbers) {
                    result.add(new ImageName(source, sourceIndex, controller, date, imageNumber));
                }
                return result;
            }
            catch (SQLException x) {
                if (i < 1) {
                    try {
                        this.close();
                    }
                    catch (SQLException sQLException) {}
                } else {
                    throw x;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.conn != null) {
            try (Connection temp = this.conn;){
                this.conn = null;
            }
        }
    }

    void forceClose() throws SQLException {
        this.conn.close();
    }
}

