/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.sim;

import java.util.function.DoubleUnaryOperator;
import org.lsst.ccs.subsystem.shutter.sim.MotionProfile;

public class CubicSCurve
implements MotionProfile {
    private final double totalDistance;
    private final double totalTime;
    private final double distanceScale;
    private final double timeScale;
    private final double velocityScale;
    private final double accelerationScale;
    private static final DoubleUnaryOperator[] dis = new DoubleUnaryOperator[]{CubicSCurve::dis0, CubicSCurve::dis1, CubicSCurve::dis2};
    private static final DoubleUnaryOperator[] vel;
    private static final DoubleUnaryOperator[] acc;
    private static final DoubleUnaryOperator[] invdis;
    private static final double PHASE0_TEND = 0.25;
    private static final double PHASE1_TEND = 0.75;
    private static final double PHASE2_TEND = 1.0;
    private static final double RANGE_TOL = 1.0E-8;
    private static final double PHASE0_DEND = 0.010416666666666666;
    private static final double PHASE1_DEND = 0.11458333333333333;
    private static final double PHASE2_DEND = 0.125;

    public CubicSCurve(double totalDistance, double totalTime) {
        if (totalTime <= 0.0) {
            throw new IllegalArgumentException("totalTime can't be <= 0");
        }
        this.totalDistance = totalDistance;
        this.totalTime = totalTime;
        this.distanceScale = 8.0 * totalDistance;
        this.timeScale = 1.0 / totalTime;
        this.velocityScale = this.distanceScale * this.timeScale;
        this.accelerationScale = this.velocityScale * this.timeScale;
    }

    @Override
    public double distance(double t) {
        double ts = this.timeScale * t;
        return this.distanceScale * dis[CubicSCurve.tphase(ts)].applyAsDouble(ts);
    }

    @Override
    public double velocity(double t) {
        double ts = this.timeScale * t;
        return this.velocityScale * vel[CubicSCurve.tphase(ts)].applyAsDouble(ts);
    }

    @Override
    public double acceleration(double t) {
        double ts = this.timeScale * t;
        return this.accelerationScale * acc[CubicSCurve.tphase(ts)].applyAsDouble(ts);
    }

    @Override
    public double inverseDistance(double dtarget) {
        double d = dtarget / this.distanceScale;
        int phase = CubicSCurve.dphase(d);
        return invdis[phase].applyAsDouble(d) / this.timeScale;
    }

    private static double dis0(double t) {
        return 2.0 * Math.pow(t, 3.0) / 3.0;
    }

    private static double dis1(double t) {
        double t0 = 0.25;
        double dt = t - 0.25;
        return CubicSCurve.dis0(0.25) + CubicSCurve.vel0(0.25) * dt + 0.5 * CubicSCurve.acc0(0.25) * Math.pow(dt, 2.0) - CubicSCurve.dis0(dt);
    }

    private static double dis2(double t) {
        double t0 = 0.75;
        double dt = t - 0.75;
        return CubicSCurve.dis1(0.75) + CubicSCurve.vel1(0.75) * dt + 0.5 * CubicSCurve.acc1(0.75) * Math.pow(dt, 2.0) + CubicSCurve.dis0(dt);
    }

    private static double vel0(double t) {
        return 2.0 * Math.pow(t, 2.0);
    }

    private static double vel1(double t) {
        double t0 = 0.25;
        double dt = t - 0.25;
        return CubicSCurve.vel0(0.25) + CubicSCurve.acc0(0.25) * dt - CubicSCurve.vel0(dt);
    }

    private static double vel2(double t) {
        double t0 = 0.75;
        double dt = t - 0.75;
        return CubicSCurve.vel1(0.75) + CubicSCurve.acc1(0.75) * dt + CubicSCurve.vel0(dt);
    }

    private static double acc0(double t) {
        return 4.0 * t;
    }

    private static double acc1(double t) {
        double t0 = 0.25;
        double dt = t - 0.25;
        return CubicSCurve.acc0(0.25) - CubicSCurve.acc0(dt);
    }

    private static double acc2(double t) {
        double t0 = 0.75;
        double dt = t - 0.75;
        return CubicSCurve.acc1(0.75) + CubicSCurve.acc0(dt);
    }

    private static double invdis0(double d) {
        return Math.cbrt(3.0 * d / 2.0);
    }

    private static double invdis2(double d) {
        return 1.0 - CubicSCurve.invdis0(0.125 - d);
    }

    private static double invdis1(double d) {
        double a = -0.75;
        double b = -0.1875;
        double c = 1.5 * d - 0.015625;
        double Q = 0.125;
        double R = (-2.109375 + 27.0 * c) / 54.0;
        double theta = Math.acos(R / Math.sqrt(0.001953125));
        double x3 = -2.0 * Math.sqrt(0.125) * Math.cos((theta - Math.PI * 2) / 3.0) - -0.25;
        return 0.25 + x3;
    }

    private static int tphase(double t) {
        if (t < -1.0E-8 || t > 1.00000001) {
            throw new IllegalArgumentException(String.format("Scaled time %g not in [0, 1]", t));
        }
        return t <= 0.25 ? 0 : (t < 0.75 ? 1 : 2);
    }

    private static int dphase(double d) {
        if (d < -1.0E-8 || d > 0.12500001) {
            throw new IllegalArgumentException("Scaled distance not in [0, 1/8]");
        }
        return d <= 0.010416666666666666 ? 0 : (d < 0.11458333333333333 ? 1 : 2);
    }

    static {
        invdis = new DoubleUnaryOperator[]{CubicSCurve::invdis0, CubicSCurve::invdis1, CubicSCurve::invdis2};
        vel = new DoubleUnaryOperator[]{CubicSCurve::vel0, CubicSCurve::vel1, CubicSCurve::vel2};
        acc = new DoubleUnaryOperator[]{CubicSCurve::acc0, CubicSCurve::acc1, CubicSCurve::acc2};
    }
}

