/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j;

import java.io.IOException;
import org.indilib.i4j.INDIProtocolParser;
import org.indilib.i4j.protocol.INDIProtocol;
import org.indilib.i4j.protocol.api.INDIInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDIProtocolReader
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(INDIProtocolReader.class);
    private INDIProtocolParser parser;
    private boolean stop;

    public INDIProtocolReader(INDIProtocolParser parser, String name) {
        super(name);
        this.parser = parser;
    }

    @Override
    public final void run() {
        INDIInputStream inputStream = this.parser.getInputStream();
        try {
            INDIProtocol readObject = inputStream.readObject();
            while (!this.stop && readObject != null) {
                this.parser.processProtokolMessage(readObject);
                readObject = inputStream.readObject();
            }
        }
        catch (IOException e) {
            LOG.error("could not parse indi stream", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.error("Could not close Doc", (Throwable)e);
            }
            this.parser.finishReader();
        }
    }

    public final void setStop(boolean stop) {
        this.stop = stop;
    }
}

