/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.focalplane.CCSPlayList;
import org.lsst.ccs.subsystem.focalplane.ExpectedSensorsEventSender;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.Guiding;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinator;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.focalplane.states.GuidingState;
import org.lsst.ccs.subsystem.focalplane.states.SequencerState;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class LSE71Commands {
    private static final LocationSet ALL_LOCATIONS = new LocationSet();
    private static final int MAX_CLEARS = 15;
    private final FocalPlaneSubsystem subsys;
    private final SequencerConfig sequencerConfig;
    private final Guiding guiding;
    private final ExpectedSensorsEventSender expectedSenorsEventSender;

    LSE71Commands(FocalPlaneSubsystem subsys, SequencerConfig config) {
        this.subsys = subsys;
        this.sequencerConfig = config;
        this.guiding = new Guiding(config, (AgentStateService)subsys.getAgentService(AgentStateService.class));
        this.expectedSenorsEventSender = new ExpectedSensorsEventSender(subsys);
    }

    @Command(type=Command.CommandType.ACTION, description="Perform a clear operation", level=0, autoAck=false)
    public void clear(@Argument(defaultValue="1") int nClears) {
        this.subsys.helper().precondition(nClears > 0 && nClears <= 15, "Invalid nClears: %d", new Object[]{nClears}).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).enterFaultOnException(true).action(() -> {
            if (this.subsys.isInState(new Enum[]{SequencerState.IDLE_FLUSH})) {
                this.subsys.getSequencers().endIdleFlush(null);
            }
            this.subsys.getSequencers().clear(nClears);
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Allocate an image for a future call to startNamedIntegration", level=0, autoAck=false)
    public ImageName allocateImageName() {
        return (ImageName)this.subsys.helper().precondition(this.subsys.getImageNameService() != null, "Image name service not available", new Supplier[0]).enterFaultOnException(true).action(() -> this.subsys.getImageNameService().getImageName());
    }

    @Command(type=Command.CommandType.ACTION, description="Start integration", level=0, autoAck=false)
    public ImageName startIntegration(@Argument(defaultValue="") String annotation, @Argument(defaultValue="***NULL_VALUE_FOR_COMMAND_ARGUMENT***") Set locations) {
        boolean realDAQ = this.sequencerConfig.isRealDAQ();
        boolean playListDefined = this.sequencerConfig.getCurrentPlaylist() != null;
        return (ImageName)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT}).precondition(this.subsys.getImageNameService() != null, "Image name service not available", new Supplier[0]).precondition(realDAQ || playListDefined, "Using emulated DAQ but no playlist defined", new Supplier[0]).precondition(realDAQ || playListDefined && this.sequencerConfig.getCurrentPlaylist().hasNextImage(), "Using emulated DAQ but playlist is empty", new Supplier[0]).enterFaultOnException(true).action(() -> {
            ImageName in = this.subsys.getImageNameService().getImageName();
            this.endIdleFlushInternal();
            this.startIntegrationInternal(in, locations, annotation);
            return in;
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Clear and start integration", level=0, autoAck=false)
    public ImageName clearAndStartIntegration(@Argument(defaultValue="1") int nClears, @Argument(defaultValue="") String annotation, @Argument(defaultValue="***NULL_VALUE_FOR_COMMAND_ARGUMENT***") Set locations) {
        boolean realDAQ = this.sequencerConfig.isRealDAQ();
        boolean playListDefined = this.sequencerConfig.getCurrentPlaylist() != null;
        return (ImageName)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).precondition(this.subsys.getImageNameService() != null, "Image name service not available", new Supplier[0]).precondition(nClears >= 0 && nClears <= 15, "Invalid nClears: %d", new Object[]{nClears}).precondition(realDAQ || playListDefined, "Using emulated DAQ but no playlist defined", new Supplier[0]).precondition(realDAQ || playListDefined && this.sequencerConfig.getCurrentPlaylist().hasNextImage(), "Using emulated DAQ but playlist is empty", new Supplier[0]).enterFaultOnException(true).action(() -> {
            ImageName in = this.subsys.getImageNameService().getImageName();
            this.endIdleFlushInternal();
            if (nClears > 0) {
                this.subsys.getSequencers().clear(nClears, null);
                this.subsys.getSequencers().waitForStop(Duration.ofSeconds(1L));
            }
            this.startIntegrationInternal(in, locations, annotation);
            return in;
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Start integration", level=0, autoAck=false)
    public void startNamedIntegration(@Argument ImageName imageName, @Argument(defaultValue="") String annotation, @Argument(defaultValue="***NULL_VALUE_FOR_COMMAND_ARGUMENT***") Set locations) {
        boolean realDAQ = this.sequencerConfig.isRealDAQ();
        boolean playListDefined = this.sequencerConfig.getCurrentPlaylist() != null;
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT}).precondition(realDAQ || playListDefined, "Using emulated DAQ but no playlist defined", new Supplier[0]).precondition(realDAQ || playListDefined && this.sequencerConfig.getCurrentPlaylist().hasNextImage(), "Using emulated DAQ but playlist is empty", new Supplier[0]).enterFaultOnException(true).action(() -> {
            this.endIdleFlushInternal();
            this.startIntegrationInternal(imageName, locations, annotation);
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Clear and start integration", level=0, autoAck=false)
    public void clearAndStartNamedIntegration(@Argument ImageName imageName, @Argument(defaultValue="1") int nClears, @Argument(defaultValue="") String annotation, @Argument(defaultValue="***NULL_VALUE_FOR_COMMAND_ARGUMENT***") Set locations) {
        boolean realDAQ = this.sequencerConfig.isRealDAQ();
        boolean playListDefined = this.sequencerConfig.getCurrentPlaylist() != null;
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).precondition(nClears >= 0 && nClears <= 15, "Invalid nClears: %d", new Object[]{nClears}).precondition(realDAQ || playListDefined, "Using emulated DAQ but no playlist defined", new Supplier[0]).precondition(realDAQ || playListDefined && this.sequencerConfig.getCurrentPlaylist().hasNextImage(), "Using emulated DAQ but playlist is empty", new Supplier[0]).enterFaultOnException(true).action(() -> {
            this.endIdleFlushInternal();
            if (nClears > 0) {
                this.subsys.getSequencers().clear(nClears, null);
                this.subsys.getSequencers().waitForStop(Duration.ofSeconds(1L));
            }
            this.startIntegrationInternal(imageName, locations, annotation);
        });
    }

    private void endIdleFlushInternal() throws RaftException, REBException, DAQException {
        if (this.subsys.isInState(new Enum[]{SequencerState.IDLE_FLUSH})) {
            this.subsys.getSequencers().endIdleFlush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startIntegrationInternal(ImageName in, Set locations, String annotation) throws DAQException, REBException, RaftException {
        try {
            ImageCoordinator currentImage = this.subsys.getImageCoordinatorService().createImageCoordinator(in);
            LocationSet localLocations = this.computeLocations(locations);
            if (localLocations.isEmpty()) {
                localLocations = this.subsys.getSequencers().getConfiguredLocations();
            }
            if (this.subsys.isInState(new Enum[]{SequencerState.IDLE_FLUSH})) {
                this.subsys.getSequencers().endIdleFlush(null);
            }
            String emulatedImageName = null;
            if (this.sequencerConfig.hasEmulatedDAQ()) {
                CCSPlayList playList = this.sequencerConfig.getCurrentPlaylist();
                if (playList == null) {
                    throw new RaftException("Using emulated DAQ but no playlist defined");
                }
                if (!playList.hasNextImage()) {
                    throw new RaftException("No images left in playlist " + playList.getName());
                }
                emulatedImageName = playList.peekNextImage();
                this.subsys.setHeaderKeywords(Collections.singletonMap("emulatedImage", emulatedImageName));
            }
            this.expectedSenorsEventSender.startIntegration(in, localLocations);
            this.subsys.getSequencers().startIntegration(in, annotation, localLocations);
            currentImage.startIntegration(annotation, localLocations, emulatedImageName);
        }
        catch (Throwable throwable) {
            this.subsys.setStateIf((Enum)FocalPlaneState.CLEARING, new Enum[]{FocalPlaneState.QUIESCENT, SequencerState.IDLE});
            throw throwable;
        }
        this.subsys.setStateIf((Enum)FocalPlaneState.CLEARING, new Enum[]{FocalPlaneState.QUIESCENT, SequencerState.IDLE});
    }

    @Command(type=Command.CommandType.ACTION, description="Shift n rows", level=0, autoAck=false)
    public void shiftNRows(int nRows) {
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.INTEGRATING}).precondition(!this.sequencerConfig.useStepAfterIntegrate(), "Shift rows no compatible with useStepAfterIntegrate", new Supplier[0]).enterFaultOnException(true).action(() -> this.subsys.getSequencers().rowShift(nRows));
    }

    @Command(type=Command.CommandType.ACTION, description="End exposure, and optionally read out", level=0, autoAck=false)
    public void endIntegration(@Argument(defaultValue="TRUE") ReadoutMode readout) {
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.INTEGRATING}).enterFaultOnException(true).action(() -> {
            this.expectedSenorsEventSender.endIntegration(readout);
            Image image = this.subsys.getSequencers().endIntegration(readout);
            this.subsys.getImageCoordinatorService().endIntegration(readout, image);
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Start idle flush", level=0, autoAck=false)
    public void startIdleFlush() {
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT}).enterFaultOnException(true).action(() -> this.subsys.getSequencers().startIdleFlush());
    }

    @Command(type=Command.CommandType.ACTION, description="End idle flush", level=0, autoAck=false)
    public void endIdleFlush(@Argument(defaultValue="1") int nClears) {
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT}).precondition(new Enum[]{SequencerState.IDLE_FLUSH}).precondition(nClears >= 0 && nClears <= 15, "Invalid nClears: %d", new Object[]{nClears}).enterFaultOnException(true).action(() -> {
            if (nClears == 0) {
                this.subsys.getSequencers().endIdleFlush(FocalPlaneState.QUIESCENT);
            } else {
                this.subsys.getSequencers().endIdleFlush(null);
                this.subsys.getSequencers().clear(nClears);
            }
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Initialize Guiders", level=0, autoAck=false)
    public int initGuiders(@Argument String roiSpec) {
        boolean realDAQ = this.sequencerConfig.isRealDAQ();
        boolean hasGuider = this.sequencerConfig.hasGuiderPartition();
        String roiSpecError = null;
        int elapsedTimeMillis = 0;
        if (hasGuider) {
            try {
                elapsedTimeMillis = this.guiding.validate(roiSpec);
            }
            catch (DAQException x) {
                roiSpecError = x.getMessage();
            }
        }
        this.subsys.helper().precondition(realDAQ, "initGuiders not supported with emulated DAQ", new Supplier[0]).precondition(hasGuider, "initGuiders not supported when no guider partition configured", new Supplier[0]).precondition(roiSpecError == null, "roiSpec validation failed" + roiSpecError, new Supplier[0]).precondition(new Enum[]{GuidingState.OFF, GuidingState.STOPPED}).enterFaultOnException(true).action(() -> this.guiding.initGuiders(roiSpec));
        return elapsedTimeMillis;
    }

    @Command(type=Command.CommandType.ACTION, description="Start Guiders", level=0, autoAck=false)
    public void startGuiding(ImageName imageName) {
        boolean realDAQ = this.sequencerConfig.isRealDAQ();
        boolean hasGuider = this.sequencerConfig.hasGuiderPartition();
        this.subsys.helper().precondition(realDAQ, "guiding not supported with emulated DAQ", new Supplier[0]).precondition(hasGuider, "guiding not supported when no guider partition configured", new Supplier[0]).precondition(this.guiding.isROISet(), "initGuiders command not issued", new Supplier[0]).precondition(new Enum[]{GuidingState.OFF, GuidingState.STOPPED}).enterFaultOnException(true).action(() -> {
            this.expectedSenorsEventSender.startGuiding(imageName, this.guiding.getSensors());
            this.guiding.startGuiding(imageName.toString());
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Stop Guiders", level=0, autoAck=false)
    public int stopGuiding() {
        boolean realDAQ = this.sequencerConfig.isRealDAQ();
        boolean hasGuider = this.sequencerConfig.hasGuiderPartition();
        return (Integer)this.subsys.helper().precondition(realDAQ, "guiding not supported with emulated DAQ", new Supplier[0]).precondition(hasGuider, "guiding not supported when no guider partition configured", new Supplier[0]).precondition(new Enum[]{GuidingState.RUNNING}).enterFaultOnException(true).action(() -> {
            this.expectedSenorsEventSender.stopGuiding();
            return this.guiding.stopGuiding();
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Clear ROI", level=0, autoAck=false)
    public void clearROI() {
        boolean realDAQ = this.sequencerConfig.isRealDAQ();
        boolean hasGuider = this.sequencerConfig.hasGuiderPartition();
        this.subsys.helper().precondition(realDAQ, "guiding not supported with emulated DAQ", new Supplier[0]).precondition(hasGuider, "guiding not supported when no guider partition configured", new Supplier[0]).precondition(new Enum[]{GuidingState.OFF, GuidingState.STOPPED}).enterFaultOnException(true).action(() -> this.guiding.clearROI());
    }

    @Command(type=Command.CommandType.ACTION, description="Clear ROI", level=0, autoAck=false)
    public void sleepGuider() {
        boolean realDAQ = this.sequencerConfig.isRealDAQ();
        boolean hasGuider = this.sequencerConfig.hasGuiderPartition();
        this.subsys.helper().precondition(realDAQ, "guiding not supported with emulated DAQ", new Supplier[0]).precondition(hasGuider, "guiding not supported when no guider partition configured", new Supplier[0]).precondition(new Enum[]{GuidingState.STOPPED}).enterFaultOnException(true).action(() -> this.guiding.sleepGuider());
    }

    private LocationSet computeLocations(Set locations) {
        if (locations == null || locations.isEmpty()) {
            return ALL_LOCATIONS;
        }
        if (locations instanceof LocationSet) {
            return (LocationSet)locations;
        }
        LocationSet result = new LocationSet();
        for (Object o : locations) {
            if (o instanceof Location) {
                result.add((Location)o);
                continue;
            }
            if (o == null) continue;
            result.addAll((Collection)LocationSet.of((String[])new String[]{o.toString()}));
        }
        return result;
    }

    public static enum ReadoutMode {
        TRUE,
        FALSE,
        PSEUDO;

    }
}

