import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.metrology.MetrologySubSys;
import org.lsst.ccs.subsystem.metrology.MetrologyConfigurable;
import org.lsst.ccs.subsystem.metrology.PointListConfigurable;

import org.lsst.ccs.subsystem.metrology.AerotechP165Device;
import org.lsst.ccs.subsystem.metrology.KeyenceG5001Device;
import org.lsst.ccs.subsystem.metrology.AerotechP165DeviceSim;
import org.lsst.ccs.subsystem.metrology.KeyenceG5001DeviceSim;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["metrology"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");

def keyenceClass = runMode.equals("simulation") ? KeyenceG5001DeviceSim : KeyenceG5001Device;
def aerotechClass = runMode.equals("simulation") ? AerotechP165DeviceSim : AerotechP165Device;

builder.metrology (MetrologySubSys, broadcastMillis:5000) {

    Measurer (keyenceClass , devcName:"/dev/ttyS0", baudRate:38400)
    
    Positioner (aerotechClass, host:"192.168.10.40", xOffset:0.0, yOffset:0.0, zOffset:0.0)

    //    AlarmHDW  (TSSubSys, argMap("OV", 0))
    AlarmLo  (Alarm, eventParm:MetrologyConfig.EVENT_ID.POSX.ordinal())
    AlarmHi  (Alarm, eventParm:MetrologyConfig.EVENT_ID.POSX.ordinal())


    "RTM" (MetrologyConfigurable)

    "RTM_Explore"(MetrologyConfigurable)

    "RTM_calib"(MetrologyConfigurable)

    "SCAN3"(MetrologyConfigurable)

    "SCAN4"(MetrologyConfigurable)

    "CCD00"(MetrologyConfigurable)

    "CCD01"(MetrologyConfigurable)

    "CCD02"(MetrologyConfigurable)

    "CCD10"(MetrologyConfigurable)

    "CCD11"(MetrologyConfigurable)

    "CCD12"(MetrologyConfigurable)

    "CCD20"(MetrologyConfigurable)

    "CCD21"(MetrologyConfigurable)

    "CCD22"(MetrologyConfigurable)

    "BASEPLATE"(MetrologyConfigurable)


    /*
    CmpCCDBias  (MonChannel,
   "CCD Bias Voltage", "V",
    "alarm", aDbl(limitLo, 0.0, 0.0,
    "alarm", aDbl(limitHi, 0.0, 0.0,
    "Bias", 0, "VOLT", "B", 0, 0.0, 1.0))
     */      
    /*
    Its name, used to identify it in databases, plots, etc.
    Its longer, more descriptive, name.
    The units the value is expressed in, e.g. "Volts".
    The device used for obtaining its value.
    The hardware channel number on the device.
    The channel type, e.g. temperature, pressure, etc, which is needed by some devices.
    The subtype, which supplies hardware configuration information.
    The offset and scale values needed for converting a raw hardware value to a physical one.
    Parameters used for checking the value against a limit.  There is one set for the low limit and one for the high one:
    The checking option:NONE, FLAG or ALARM
    The limit value.
    The alarm to be activated upon status transitions when ALARM is specified.
    The deadband value which delays a potential alarm action during a transition back to good status.
    Its id, which is its index in the list of all channels.

    The limit values are maintained by the configuration system and can be changed while running.  Any such change causes a status message to be broadcast, which can be used to update the trending database or to update any console displays.
     */
    posX  (Channel,
                   description:"posX", units:"mm",
                           devcName:"Positioner", hwChan:0, type:"POSITION", subtype:"P", offset:0.0, scale:1.0,
                           checkLo:"flag", alarmLo:null,
                           checkHi:"flag", alarmHi:null)

    posY  (Channel,
                   description:"posY", units:"mm",
                           devcName:"Positioner", hwChan:1, type:"POSITION", subtype:"P", offset:0.0, scale:1.0,
                           checkLo:"flag", alarmLo:null,
                           checkHi:"flag", alarmHi:null)

    posZ  (Channel,
                   description:"posZ", units:"mm",
                           devcName:"Positioner", hwChan:2, type:"POSITION", subtype:"P", offset:0.0, scale:1.0,
                           checkLo:"flag", alarmLo:null,
                           checkHi:"flag", alarmHi:null)
    displacement  (Channel,
                   description:"displacement", units:"mm",
                           devcName:"Measurer", hwChan:0, type:"POSITION", subtype:"A", offset:0.0, scale:1.0,
                           checkLo:"flag", alarmLo:null,
                           checkHi:"flag", alarmHi:null)

}
