import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.drivers.auxelex.Bfr
import org.lsst.ccs.subsystem.utility.UtilTrunkMain
import org.lsst.ccs.subsystem.utility.FanPIControl
import org.lsst.ccs.subsystem.utility.Maq20DeviceUT
import org.lsst.ccs.subsystem.utility.SimMaq20DeviceUT
import org.lsst.ccs.subsystem.utility.SimMaq20AnalogControl
import org.lsst.ccs.subsystem.utility.SimMaq20PWMControl
import org.lsst.ccs.subsystem.utility.BfrDeviceUT
import org.lsst.ccs.subsystem.utility.Pdu48VDeviceUT
import org.lsst.ccs.subsystem.utility.VpcControlUT
import org.lsst.ccs.subsystem.utility.TelescopeDevice
import org.lsst.ccs.subsystem.utility.MpmPlutoDevice
import org.lsst.ccs.subsystem.utility.MpmSimPlutoDevice
import org.lsst.ccs.subsystem.utility.AccumTimeChannel
import org.lsst.ccs.subsystem.utility.WeightedAverageChannel
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PulseControl
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl
import org.lsst.ccs.monitor.Alarm
import org.lsst.ccs.monitor.Channel

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()

runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")
if (runMode.equals("simulation")) {
    maq20DeviceUT = SimMaq20DeviceUT
    maq20AnalogControl = SimMaq20AnalogControl
    maq20PWMControl = SimMaq20PWMControl
    mpmPlutoDevice = MpmSimPlutoDevice
}
else {
    maq20DeviceUT = Maq20DeviceUT
    maq20AnalogControl = Maq20AnalogControl
    maq20PWMControl = Maq20PWMControl
    mpmPlutoDevice = MpmPlutoDevice
} 

CCSBuilder builder = ["utiltrunk"]

builder.main (UtilTrunkMain, utFan: ref("UTFan"), vpcFan: ref("VPCFan"), mpcFan: ref("MPCFan"),
              utValvePosn: ref("UT/ValvePosn"), vpcValvePosn: ref("VPC/ValvePosn"), mpcValvePosn: ref("MPC/ValvePosn"),
              utFanSpeed: ref("UT/FanSpeed"), vpcFanSpeed: ref("VPC/FanSpeed"), mpcFanSpeed: ref("MPC/FanSpeed"),
              utTemps: [ref("UT/W2Q1Temp"), ref("UT/W4Q3Temp"), ref("UT/MidXPlusTemp"), ref("UT/MidXMinusTemp"),
                        ref("UT/TopXPlusTemp"), ref("UT/TopXMinusTemp"), ref("UT/SuppXPlusTemp"), ref("UT/SuppXMinusTemp"),
                        ref("UT/FanInletTemp")]) {

    UTFlowAlarm (Alarm, description: "UT Coolant flow alarm")

    UTTempLoAlarm (Alarm, description: "UT Low temperature alarm")

    UTTempHiAlarm (Alarm, description: "UT High temperature alarm")

    UTSpeedHiAlarm (Alarm, description: "UT High fan speed alarm")

    Maq20 (maq20DeviceUT, modules: ["DIOL:pwm:pulse", "DIOL:pwm:pulse", "DIOL:pwm:pulse", "IO", "IS", "TTC", "RTD"]) {

       MPCPwm (maq20PWMControl, modIndex: 1, funcIndex: 0, frequency: 200.0)

       MPCPulse (Maq20PulseControl, modIndex: 1, funcIndex: 1, pulsesPerRevn: 2)

       VPCPwm (maq20PWMControl, modIndex: 0, funcIndex: 0, frequency: 200.0)

       VPCPulse (Maq20PulseControl, modIndex: 0, funcIndex: 1, pulsesPerRevn: 2)

       UTPwm (maq20PWMControl, modIndex: 2, funcIndex: 0, frequency: 200.0)

       UTPulse (Maq20PulseControl, modIndex: 2, funcIndex: 1, pulsesPerRevn: 6)

       AnalogOut (maq20AnalogControl, modIndex: 3, ranges: ["MA4_20", "MA4_20", "MA4_20"])
    }

    BFR (BfrDeviceUT)

    PDU_48V (Pdu48VDeviceUT)

    Telescope (TelescopeDevice)

    Pluto (mpmPlutoDevice)

    /*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1, pageId: 0, 
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/

    "UT/W2Q1Temp" (Channel, description: "UT W2 Q1 temperature", units: "\u00b0C",
                   devcName: "Maq20", hwChan: 0, type: "5", subtype: "T220",
                   checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/W4Q3Temp" (Channel, description: "UT W4 Q3 temperature", units: "\u00b0C",
                   devcName: "Maq20", hwChan: 2, type: "5", subtype: "T220",
                   checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/MidXPlusTemp" (Channel, description: "UT Mid-plate X+ temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: 1, type: "5", subtype: "T220",
                       checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/MidXMinusTemp" (Channel, description: "UT Mid-plate X- temperature", units: "\u00b0C",
                        devcName: "Maq20", hwChan: 3, type: "5", subtype: "T220",
                        checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/TopXPlusTemp" (Channel, description: "UT Top end X+ temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: 4, type: "5", subtype: "T220",
                       checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/TopXMinusTemp" (Channel, description: "UT Top end X- temperature", units: "\u00b0C",
                        devcName: "Maq20", hwChan: 5, type: "5", subtype: "T220",
                        checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/SuppXPlusTemp" (Channel, description: "UT Support ring X+ temperature", units: "\u00b0C",
                        devcName: "Maq20", hwChan: 6, type: "5", subtype: "T220",
                        checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/SuppXMinusTemp" (Channel, description: "UT Support ring X- temperature", units: "\u00b0C",
                         devcName: "Maq20", hwChan: 7, type: "5", subtype: "T220",
                         checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/FanInletTemp" (Channel, description: "UT fan inlet temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: 3, type: "6", subtype: "R200",
                       checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/AverageTemp" (WeightedAverageChannel, description: "UT weighted average temperature", units: "\u00b0C",
                      channels: [ref("UT/W2Q1Temp"), ref("UT/W4Q3Temp"), ref("UT/FanInletTemp"),
                                 ref("UT/MidXPlusTemp"), ref("UT/MidXMinusTemp"), ref("UT/TopXPlusTemp"),
                                 ref("UT/TopXMinusTemp"), ref("UT/SuppXPlusTemp"), ref("UT/SuppXMinusTemp")],
                      weights: [2.0, 2.0, 2.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0])

    "UT/FanSpeed" (Channel, description: "UT fan speed", units: "rpm", format: ".0f",
                   devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_PULSE_RPM, type: "2", subtype: "1",
                   checkHi: "alarm", alarmHi: "UTSpeedHiAlarm")

    "UT/FanRunTime" (AccumTimeChannel, description: "UT fan accumulated run time", units: "hrs", format: ".1f",
                     channel: ref("UT/FanSpeed"))

    "UT/CoolFlowRate" (Channel, description: "UT coolant flow rate", units: "gpm",
                       devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_UT_FLOW_RATE, type: "4", subtype: "MA4_20",
                       scale: 3500.0, offset: -14.0,  // Calibrated by hand
                       checkLo: "alarm", alarmLo: "UTFlowAlarm")

    "UT/CoolPipeSplyTemp" (Channel, description: "UT coolant pipe supply temperature", units: "\u00b0C",
                           devcName: "Maq20", hwChan: 4, type: "6", subtype: "R200",
                           checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/CoolPipeRetnTemp" (Channel, description: "UT coolant pipe return temperature", units: "\u00b0C",
                           devcName: "Maq20", hwChan: 5, type: "6", subtype: "R200")

    "UT/ValvePosn" (Channel, description: "UT coolant valve position", units: "%",
                    devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_UT_VALVE_POSN, type: "4", subtype: "MA4_20")

    "UT/DomeXMinusTemp" (Channel, description: "Telescope dome X- temperature", units: "\u00b0C",
                         devcName: "Telescope", hwChan: TelescopeDevice.CHAN_DOME_XMINUS_TEMP)

    "UT/DomeYMinusTemp" (Channel, description: "Telescope dome Y- temperature", units: "\u00b0C",
                         devcName: "Telescope", hwChan: TelescopeDevice.CHAN_DOME_YMINUS_TEMP)

    "VPC/SplyAirVel" (Channel, description: "VPC supply air velocity", units: "m/s",
                      devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_VPC_SPLY_AIR_VEL, type: "4", subtype: "MA4_20",
                      scale: 1250.0, offset: -5.0)

    "VPC/SplyAirTemp" (Channel, description: "VPC supply air temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_VPC_SPLY_AIR_TEMP, type: "4", subtype: "MA4_20",
                       scale: 6250.0, offset: -50.0)

    "VPC/RetnAirTemp" (Channel, description: "VPC return air temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: 2, type: "6", subtype: "R200")

    //"VPC/DeltatempAct" (Channel, description: "VPC actual delta temperature", units: "\u00b0C",
    //                    devcName: "Calc", type: "DIFF", subtype: "VPC/AvgAirtempOut:VPC/AmbAirtemp")

    //"VPC/AvgAirtempOut" (Channel, description: "VPC average air temperature", units: "\u00b0C",
    //                     devcName: "Maq20", hwChan: 0, type: "6", subtype: "R200")

    //"VPC/AmbAirtemp" (Channel, description: "VPC ambient air temperature", units: "\u00b0C",
    //                  devcName: "Maq20", hwChan: 1, type: "6", subtype: "R200")

    "VPC/FanSpeed" (Channel, description: "VPC fan speed", units: "rpm", format: ".0f",
                    devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_PULSE_RPM, type: "0", subtype: "1")

    "VPC/FanRunTime" (AccumTimeChannel, description: "VPC fan accumulated run time", units: "hrs", format: ".1f",
                      channel: ref("VPC/FanSpeed"))

    "VPC/PreFiltPress" (Channel, description: "VPC pre-filter air pressure", units: "in. H\u2082O",
                        devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_VPC_PREFILT_PRESS, type: "4", subtype: "MA4_20",
                        scale: 625.0, offset: -2.5)

    "VPC/SplyPress" (Channel, description: "VPC supply air pressure", units: "in. H\u2082O",
                     devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_VPC_SPLY_PRESS, type: "4", subtype: "MA4_20",
                     scale: 625.0, offset: -2.5)

    "VPC/RetnPress" (Channel, description: "VPC return air pressure", units: "in. H\u2082O",
                     devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_VPC_RETN_PRESS, type: "4", subtype: "MA4_20",
                     scale: 625.0, offset: -2.5)

    "VPC/Humidity" (Channel, description: "VPC relative humidity", units: "%",
                    devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_VPC_HUMIDITY, type: "4", subtype: "MA4_20",
                    scale: 6250.0, offset: -25.0)

    "VPC/ValvePosn" (Channel, description: "VPC coolant valve position", units: "%", format: ".2f",
                     devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_VPC_VALVE_POSN, type: "4", subtype: "MA4_20")

    "VPC/HtrCurrent" (Channel, description: "VPC heater current", units: "mA", format: ".1f",
                      devcName: "BFR", hwChan: Bfr.SENSOR_HTRS, scale: 1000.0)

    "MPC/SplyAirTemp" (Channel, description: "MPC supply air temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: 1, type: "6", subtype: "R200")

    "MPC/RetnAirTemp" (Channel, description: "MPC return air temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: 0, type: "6", subtype: "R200")

    //"MPC/DeltaTempAct" (Channel, description: "MPC actual delta temperature", units: "\u00b0C",
    //                    devcName: "Calc", type: "DIFF", subtype: "MPC/AvgAirtempOut:MPC/AmbAirtemp")

    //"MPC/AvgAirtempOut" (Channel, description: "MPC average air temperature", units: "\u00b0C",
    //                     devcName: "Maq20", hwChan: 0, type: "6", subtype: "R200")

    //"MPC/AmbAirtemp" (Channel, description: "MPC ambient air temperature", units: "\u00b0C",
    //                  devcName: "Maq20", hwChan: 1, type: "6", subtype: "R200")

    "MPC/FanSpeed" (Channel, description: "MPC fan speed", units: "rpm", format: ".0f",
                    devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_PULSE_RPM, type: "1", subtype: "1")

    "MPC/FanRunTime" (AccumTimeChannel, description: "MPC fan accumulated run time", units: "hrs", format: ".1f",
                      channel: ref("MPC/FanSpeed"))

    "MPC/PreFiltPress" (Channel, description: "MPC pre-filter air pressure", units: "in. H\u2082O",
                        devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_MPC_PREFILT_PRESS, type: "4", subtype: "MA4_20",
                        scale: 625.0, offset: -2.5)

    "MPC/SplyPress" (Channel, description: "MPC supply air pressure", units: "in. H\u2082O",
                     devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_MPC_SPLY_PRESS, type: "4", subtype: "MA4_20",
                     scale: 625.0, offset: -2.5)

    "MPC/RetnPress" (Channel, description: "MPC return air pressure", units: "in. H\u2082O",
                     devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_MPC_RETN_PRESS, type: "4", subtype: "MA4_20",
                     scale: 625.0, offset: -2.5)

    "MPC/Humidity" (Channel, description: "MPC relative humidity", units: "%",
                    devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_MPC_HUMIDITY, type: "4", subtype: "MA4_20",
                    scale: 6250.0, offset: -25.0)

    "MPC/ValvePosn" (Channel, description: "MPC coolant valve position", units: "%",
                     devcName: "Maq20", hwChan: Maq20DeviceUT.CHAN_MPC_VALVE_POSN, type: "4", subtype: "MA4_20")

    UTFan   (FanPIControl, fan: ref("Maq20/UTPwm"), refTempChans: [ref("UT/DomeXMinusTemp"), ref("UT/DomeYMinusTemp")],
             ctrlTempChans: [ref("UT/AverageTemp")], ctrlTempWeights: [1.0])

    VPCFan  (FanPIControl, fan: ref("Maq20/VPCPwm"), refTempChans: [], ctrlTempChans: [], ctrlTempWeights: [])

    VPCHtrs (VpcControlUT, refTempChans: [ref("VPC/SplyAirTemp")], ctrlTempChans: [ref("VPC/SplyAirTemp")])

    MPCFan  (FanPIControl, fan: ref("Maq20/MPCPwm"), refTempChans: [ref("MPC/SplyAirTemp")],
             ctrlTempChans: [ref("MPC/SplyAirTemp")], ctrlTempWeights: [1.0])

}
