import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.teststand.data.*;
import org.lsst.ccs.subsystem.teststand.*;
import org.lsst.ccs.subsystem.teststand.alerts.TS7Alerts;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.subsystem.common.devices.power.distribution.*;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");
def raftType = props.getProperty("org.lsst.ccs.raft.type","normal");

CCSBuilder builder = ["ts7-slac"]

Class cryoClass = Class.forName("org.lsst.ccs.subsystem.teststand.CryoCon24c" + (runMode.equals("simulation") ? "Sim" : "") + "Device");
Class upsClass = Class.forName("org.lsst.ccs.subsystem.teststand.AP9630UPS" + (runMode.equals("simulation") ? "Sim" : "") + "Device");
Class turboClass = Class.forName("org.lsst.ccs.subsystem.common.devices.turbopump.TwisTorr84" + "Device");
Class vqmClass = Class.forName("org.lsst.ccs.subsystem.common.devices.vacuum.GPVacMon835" + "Device");

builder.main (TS7) {

    Cryo   (cryoClass)
    
    TS7AlertHandler (TS7AlertHandler)

    Turbo  (turboClass)

    VQMonitor (vqmClass)

    PDU15 (APC7900Device)

    PDU20 (APC7900Device)

    UPS (upsClass)

    AlarmCryoHighTempLimit  (Alarm, description:"Cryo Plate high temperature alarm", eventParm:TS7Alerts.CRYO_PLATE_TEMPERATURE_TOO_HIGH.ordinal())

    AlarmCryoLowTempLimit   (Alarm, description:"Cryo Plate low temperature alarm", eventParm:TS7Alerts.CRYO_PLATE_TEMPERATURE_TOO_LOW.ordinal())
    
    AlarmColdHighTempLimit  (Alarm, description:"Cold Plate high temperature alarm", eventParm:TS7Alerts.COLD_PLATE_TEMPERATURE_TOO_HIGH.ordinal())

    AlarmColdLowTempLimit   (Alarm, description:"Cold Plate low temperature alarm", eventParm:TS7Alerts.COLD_PLATE_TEMPERATURE_TOO_LOW.ordinal())

    AlarmPressureHighLimit  (Alarm, description:"Pressure too high alarm", eventParm:TS7Alerts.PRESSURE_TOO_HIGH.ordinal())

    AlarmPressureLowLimit   (Alarm, description:"Pressure too low alarm", eventParm:TS7Alerts.PRESSURE_TOO_LOW.ordinal())

    AlarmTurboStatusFail    (Alarm, description:"Turbo Pump Status = Fail", eventParm:TS7Alerts.TURBO_PUMP_FAIL.ordinal())

    AlarmTurboStatusSlow    (Alarm, description:"Turbo Pump Status below Normal", eventParm:TS7Alerts.TURBO_PUMP_SLOW.ordinal())

    AlarmTurboTempHighLimit (Alarm, description:"Turbo Pump Temp too high", eventParm:TS7Alerts.TURBO_PUMP_OVERTEMP.ordinal())

    AlarmGeneric  (Alarm, description:"Generic alarm", eventParm:TS7Alerts.GENERIC.ordinal())

     /*
         Its name, used to identify it in databases, plots, etc.
    Its longer, more descriptive, name.
    The units the value is expressed in, e.g. "Volts".
    The device used for obtaining its value.
    The hardware channel number on the device.
    The channel type, e.g. temperature, pressure, etc, which is needed by some devices.
    The subtype, which supplies hardware configuration information.
    The offset and scale values needed for converting a raw hardware value to a physical one.
    Parameters used for checking the value against a limit.  There is one set for the low limit and one for the high one:
        The checking option: NONE, FLAG or ALARM
        The limit value.
        The alarm to be activated upon status transitions when ALARM is specified.
        The deadband value which delays a potential alarm action during a transition back to good status.
    Its id, which is its index in the list of all channels.

The limit values are maintained by the configuration system and can be changed while running.  Any such change causes a status messa\
ge to be broadcast, which can be used to update the trending database or to update any console displays.
*/

    if (!raftType.equals("corner")) {
        "ColdPlate-a"  (Channel, description:"Cryogenics temperature A", units:"\u00b0C",
                 devcName:"Cryo", hwChan:CryoCon24cDevice.CHAN_TEMP_A,
                 checkLo:"alarm", alarmLo:"AlarmColdLowTempLimit",
                 checkHi:"alarm", alarmHi:"AlarmColdHighTempLimit")
    
        "ColdPlate-b"  (Channel, description:"Cryogenics temperature B", units:"\u00b0C",
                 devcName:"Cryo", hwChan:CryoCon24cDevice.CHAN_TEMP_B,
                 checkLo:"alarm", alarmLo:"AlarmColdLowTempLimit",
                 checkHi:"alarm", alarmHi:"AlarmColdHighTempLimit")

        CryoPlate  (Channel, description:"Cryogenics temperature D", units:"\u00b0C",
                 devcName:"Cryo", hwChan:CryoCon24cDevice.CHAN_TEMP_D,
                 checkLo:"alarm", alarmLo:"AlarmCryoLowTempLimit",
                 checkHi:"alarm", alarmHi:"AlarmCryoHighTempLimit")
    } else {
        ColdPlate  (Channel, description:"Cryogenics temperature A", units:"\u00b0C",
                 devcName:"Cryo", hwChan:CryoCon24cDevice.CHAN_TEMP_A,
                 checkLo:"alarm", alarmLo:"AlarmColdLowTempLimit",
                 checkHi:"alarm", alarmHi:"AlarmColdHighTempLimit")

        CryoPlate  (Channel, description:"Cryogenics temperature B", units:"\u00b0C",
                 devcName:"Cryo", hwChan:CryoCon24cDevice.CHAN_TEMP_B,
                 checkLo:"alarm", alarmLo:"AlarmCryoLowTempLimit",
                 checkHi:"alarm", alarmHi:"AlarmCryoHighTempLimit")
    }

    htrread1  (Channel, description:"Cryogenics heater loop 1 % power", units:"%",
               devcName:"Cryo", hwChan:CryoCon24cDevice.CHAN_HTR_1)

    htrread2  (Channel, description:"Cryogenics heater loop 2 % power", units:"%",
               devcName:"Cryo", hwChan:CryoCon24cDevice.CHAN_HTR_2)

    tempChng  (Channel, description:"Temperature change rate", units:"\u00b0C/min",
               devcName:"Cryo", hwChan:CryoCon24cDevice.CHAN_TEMP_CHNG,
               checkLo:"alarm", alarmLo:"AlarmGeneric",
               checkHi:"alarm", alarmHi:"AlarmGeneric")

    SetPnt1  (Channel, description:"setPoint Loop 1", units:"",
              devcName:"Cryo", hwChan:CryoCon24cDevice.CHAN_SETPOINT_1,
              checkHi:"alarm", alarmHi:"AlarmGeneric")

    SetPnt2  (Channel, description:"setPoint Loop 2", units:"",
              devcName:"Cryo", hwChan:CryoCon24cDevice.CHAN_SETPOINT_2,
              checkHi:"alarm", alarmHi:"AlarmGeneric")

    vqmpressure  (Channel, description:"VQM Pressure Reading", units:"Torr", format:".3G",
                  devcName:"VQMonitor", hwChan:0,
                checkLo:"alarm", alarmLo:"AlarmPressureLowLimit",
                checkHi:"alarm", alarmHi:"AlarmPressureHighLimit")

    PDU15Current  (Channel, description:"PDU15 current", units:"Amps",
                   devcName:"PDU15", hwChan:APC7900Device.CHAN_CURRENT, type:"POWER")

    PDU15Power    (Channel, description:"PDU15 power", units:"Watts",
                   devcName:"PDU15", hwChan:APC7900Device.CHAN_POWER, type:"POWER")

    PDU20Current  (Channel, description:"PDU20 current", units:"Amps",
                   devcName:"PDU20", hwChan:APC7900Device.CHAN_CURRENT, type:"POWER")

    PDU20Power    (Channel, description:"PDU20 power", units:"Watts",
                   devcName:"PDU20", hwChan:APC7900Device.CHAN_POWER, type:"POWER")

    TurboCurrent      (Channel, description:"TurboPump current", units:"mA dc",
                       devcName:"Turbo", type:"Numeric", subtype:"CURRENT",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    TurboVoltage      (Channel, description:"TurboPump voltage", units:"V dc",
                       devcName:"Turbo", type:"Numeric", subtype:"VOLTAGE",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    TurboPower        (Channel, description:"TurboPump power", units:"W",
                       devcName:"Turbo", type:"Numeric", subtype:"POWER",
                       checkLo:"none", checkHi:"alarm", format:"%.0f",
                       alarmHi:"AlarmGeneric")

    TurboDriveFreq    (Channel, description:"TurboPump drive freq.", units:"Hz",
                       devcName:"Turbo", type:"Numeric", subtype:"DRIVEFREQ",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    TurboPumpTemp     (Channel, description:"TurboPump pump temperature", 
                       units:"deg C", devcName:"Turbo", 
                       type:"Numeric", subtype:"PUMP_TEMP", format:"%.0f",
                       checkLo:"flag", 
                       checkHi:"alarm", 
                       alarmHi:"AlarmTurboTempHighLimit")

    TurboContTempSink (Channel, description:"TurboPump controller sink temp.", 
                       units:"deg C", devcName:"Turbo", 
                       type:"Numeric", subtype:"CONT_TEMP_SINK", format:"%.0f",
                       checkLo:"flag", 
                       checkHi:"alarm", 
                       alarmHi:"AlarmTurboTempHighLimit")

    TurboContTempAir  (Channel, description:"TurboPump controller air temp.", 
                       units:"deg C", devcName:"Turbo", 
                       type:"Numeric", subtype:"CONT_TEMP_AIR", format:"%.0f",
                       checkLo:"flag", 
                       checkHi:"alarm", 
                       alarmHi:"AlarmTurboTempHighLimit")

    TurboRPM          (Channel, description:"TurboPump speed", units:"RPM",
                       devcName:"Turbo", type:"Numeric", subtype:"RPM",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    TurboStatus       (Channel, description:"TurboPump status: 5=normal, 6=fail", 
                       devcName:"Turbo", type:"Numeric", subtype:"STATUS", 
                       format:"%.0f", 
                       checkLo:"alarm", alarmLo:"AlarmTurboStatusSlow",
                       checkHi:"alarm", alarmHi:"AlarmTurboStatusFail")

    UPS_Status    (Channel, description:"UPS status", format:".0f",
                   devcName:"UPS", hwChan:AP9630UPSDevice.CHAN_STATUS)
               
    UPS_Current   (Channel, description:"UPS output current", units:"Amps", format:".2f",
                   devcName:"UPS", hwChan:AP9630UPSDevice.CHAN_OUT_CURRENT)
               
    UPS_Charge    (Channel, description:"UPS battery charge", units:"%", format:".2f",
                   devcName:"UPS", hwChan:AP9630UPSDevice.CHAN_BATT_CHARGE)
               
    UPS_RemTime   (Channel, description:"UPS remaining time", units:"secs", format:".0f",
                   devcName:"UPS", hwChan:AP9630UPSDevice.CHAN_REM_TIME)
               
}

