/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class WUDevice
extends Device
implements WattsUp.Listener {
    private static final int CHAN_WATTS = 0;
    private static final int CHAN_VOLTS = 1;
    private static final int CHAN_FREQ = 2;
    private static final int N_DEV_CHANS = 3;
    private static final int LOG_PERIOD = 1;
    private String node;
    private String serial;
    private static final Logger LOG = Logger.getLogger(WUDevice.class.getName());
    private final WattsUp wtu = new WattsUp();
    private final double[] value = new double[3];
    private boolean initError = false;

    protected void initDevice() {
        super.configure(this.mon);
        this.wtu.addListener((WattsUp.Listener)this);
        this.fullName = "WattsUp meter (" + (this.node == null ? "local" : this.node) + (this.serial == null ? "" : ":" + this.serial) + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.wtu.openFtdi(this.serial, 0);
                this.wtu.restart();
                this.setOnline(true);
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int chan, int type) {
        return this.isOnline() ? this.value[chan] : super.readChannel(chan, type);
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(65539);
                this.wtu.setExternalLogging(1);
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error configuring {0}: {1}", new Object[]{this.fullName, e});
            }
        } else {
            for (int j = 0; j < 3; ++j) {
                this.value[j] = 0.0;
            }
        }
    }

    public void setClosed() {
        this.setOnline(false);
    }

    public void processData(double[] data) {
        this.value[0] = data[0];
        this.value[1] = data[1];
        this.value[2] = data[16];
    }
}

