/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.StateChangeListener;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.services.AgentExecutionService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinator;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinatorUtilities;
import org.lsst.ccs.subsystem.focalplane.ImageDatabaseService;
import org.lsst.ccs.subsystem.focalplane.ImageMessageHandling;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.WebHooks;
import org.lsst.ccs.subsystem.focalplane.WebHooksConfig;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.focalplane.states.SequencerState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class ImageCoordinatorService
implements HasLifecycle,
ImageCoordinatorUtilities,
ClearAlertHandler {
    private static final Logger LOG = Logger.getLogger(ImageCoordinatorService.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private FocalPlaneSubsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ImageDatabaseService idbs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private WebHooksConfig webHooksConfig;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentExecutionService executionService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ImageMessageHandling imageMessageHandling;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private SequencerConfig sequencerConfig;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private final Map<String, ImageCoordinator> coordinators = new HashMap<String, ImageCoordinator>();
    private final Map<String, ScheduledFuture<?>> timeouts = new HashMap();
    private WebHooks webHooks;
    private ImageCoordinator currentImageCoordinator;
    private ImageCoordinator currentMetaDataTarget;
    private ImageCoordinator mostRecentImageCoordinator;
    private final Map<String, Serializable> savedMetaData = new HashMap<String, Serializable>();
    public static final String BAD_PIXELS_ALERTID = "badPixels";

    ImageCoordinatorService() {
    }

    public void start() {
        if (this.webHooksConfig != null) {
            this.webHooks = new WebHooks((ExecutorService)this.executionService, this.webHooksConfig);
        }
    }

    public void postInit() {
        this.agentStateService.addStateChangeListener(new StateChangeListener(){
            private volatile ScheduledFuture<Void> scheduledIdleFlush;
            private volatile CCSTimeStamp lastClear;

            public void stateChanged(CCSTimeStamp transitionTime, Object changedObj, Enum<?> newState, Enum<?> oldState) {
                LOG.log(Level.INFO, () -> String.format("FocalPlaneState change from %s to %s with timestamp %s", oldState, newState, transitionTime));
                if (newState == FocalPlaneState.QUIESCENT) {
                    long idleFlushTimeout = ImageCoordinatorService.this.sequencerConfig.getIdleFlushTimeout();
                    if (idleFlushTimeout > 0L) {
                        this.scheduledIdleFlush = ImageCoordinatorService.this.subsys.getScheduler().schedule(() -> {
                            Object object = ImageCoordinatorService.this.agentStateService.getStateLock();
                            synchronized (object) {
                                if (ImageCoordinatorService.this.agentStateService.isInState((Enum)FocalPlaneState.QUIESCENT)) {
                                    ImageCoordinatorService.this.subsys.getSequencers().startIdleFlush();
                                }
                            }
                            return null;
                        }, idleFlushTimeout, TimeUnit.MILLISECONDS);
                    }
                } else if (this.scheduledIdleFlush != null) {
                    this.scheduledIdleFlush.cancel(false);
                }
                if (oldState == FocalPlaneState.CLEARING || oldState == FocalPlaneState.READING_OUT) {
                    this.lastClear = transitionTime;
                }
                if (newState == FocalPlaneState.READING_OUT) {
                    double darkTime = transitionTime.getTAIDouble() - this.lastClear.getTAIDouble();
                    LOG.log(Level.INFO, "Setting darktime to {0}", darkTime);
                    ImageCoordinatorService.this.subsys.setHeaderKeywords(Collections.singletonMap("darkTime", darkTime));
                    ImageCoordinatorService.this.currentImageCoordinator.startReadout(darkTime, transitionTime, this.lastClear);
                    ImageCoordinatorService.this.currentMetaDataTarget = null;
                } else if (newState == FocalPlaneState.INTEGRATING) {
                    ImageCoordinatorService.this.currentImageCoordinator.startIntegrating(transitionTime);
                }
            }
        }, new Class[]{FocalPlaneState.class});
        this.agentStateService.addStateChangeListener(new StateChangeListener(){

            public void stateChanged(CCSTimeStamp transitionTime, Object changedObj, Enum<?> newState, Enum<?> oldState) {
                LOG.log(Level.INFO, () -> String.format("SequencerState change from %s to %s with timestamp %s", oldState, newState, transitionTime));
            }
        }, new Class[]{SequencerState.class});
        try {
            this.sequencerConfig.addDAQImageListener(new ImageListener(){

                public void imageCreated(Image image) {
                    if (image.getMetaData().getCreationFolderName().equals(ImageCoordinatorService.this.sequencerConfig.getDAQFolder())) {
                        ImageCoordinator ic = (ImageCoordinator)ImageCoordinatorService.this.coordinators.get(image.getMetaData().getName());
                        if (ic != null) {
                            ic.imageCreated(image);
                        } else {
                            LOG.log(Level.WARNING, "No image coordinator for image {0}", image.getMetaData().getName());
                        }
                    }
                }

                public void imageComplete(Image image) {
                    if (image.getMetaData().getCreationFolderName().equals(ImageCoordinatorService.this.sequencerConfig.getDAQFolder())) {
                        ImageCoordinator ic = (ImageCoordinator)ImageCoordinatorService.this.coordinators.get(image.getMetaData().getName());
                        if (ic != null) {
                            ic.imageComplete(image);
                        } else {
                            LOG.log(Level.WARNING, "No image coordinator for image {0}", image.getMetaData().getName());
                        }
                    }
                }
            });
        }
        catch (DAQException x) {
            throw new RuntimeException("Failed to initialize DAQ listener", x);
        }
    }

    ImageCoordinator createImageCoordinator(ImageName in) {
        ImageCoordinator coord = new ImageCoordinator(in, this, this.webHooks, this.idbs.getImageDatabase(), this.imageMessageHandling.getCount());
        if (!this.savedMetaData.isEmpty()) {
            coord.setMetaData(this.savedMetaData);
            this.savedMetaData.clear();
            this.currentMetaDataTarget = coord;
        }
        this.coordinators.put(in.toString(), coord);
        this.currentImageCoordinator = coord;
        this.mostRecentImageCoordinator = coord;
        return coord;
    }

    ImageCoordinator getImageCoordinator(String imageName) {
        ImageCoordinator coord = this.coordinators.get(imageName);
        if (coord == null) {
            throw new RuntimeException("No iamge coordinator for " + imageName);
        }
        return coord;
    }

    ImageCoordinator getCurrentImageCoordinator() {
        if (this.currentImageCoordinator == null) {
            throw new RuntimeException("No image in progress");
        }
        return this.currentImageCoordinator;
    }

    ImageCoordinator getMostRecentImageCoordinator() {
        if (this.mostRecentImageCoordinator == null) {
            throw new RuntimeException("No image in progress");
        }
        return this.mostRecentImageCoordinator;
    }

    void endIntegration(LSE71Commands.ReadoutMode readout, Image image) {
        ImageCoordinator imageCoordinator = this.currentImageCoordinator;
        String imageName = imageCoordinator.getImageName().toString();
        this.timeouts.put(imageName, this.subsys.getScheduler().schedule(() -> {
            LOG.log(Level.WARNING, "Timed out waiting for image completion for {0}", imageCoordinator.getImageName());
            this.done(imageCoordinator);
        }, 60L, TimeUnit.SECONDS));
        imageCoordinator.endIntegration(readout, image);
    }

    @Override
    public void sendEvent(String key, Serializable event) {
        this.subsys.sendEvent(key, event);
    }

    @Override
    public void setStateIf(FocalPlaneState currentState, FocalPlaneState newState) {
        this.subsys.setStateIf(currentState, newState);
    }

    @Override
    public void done(ImageCoordinator ic) {
        String imageName = ic.getImageName().toString();
        LOG.log(Level.INFO, "Image coordinator for {0} complete", imageName);
        ScheduledFuture<?> futureTimeout = this.timeouts.get(imageName);
        if (futureTimeout != null) {
            futureTimeout.cancel(false);
        }
        if (this.currentImageCoordinator == ic) {
            this.currentImageCoordinator = null;
        }
        if (this.currentMetaDataTarget == ic) {
            this.currentMetaDataTarget = null;
        }
        if (!ic.isImageComplete()) {
            this.setStateIf(FocalPlaneState.IMAGE_WAIT, FocalPlaneState.QUIESCENT);
        }
        if (ic.getBadPixelCount() > this.sequencerConfig.getBadPixelAlarmLimit() && !this.sequencerConfig.isTransparentOrScanMode()) {
            Alert alert = new Alert(BAD_PIXELS_ALERTID, "Alert raised when bad pixels are detected.");
            String message = String.format("Image %s had %d bad pixels", ic.getImageName(), ic.getBadPixelCount());
            LOG.log(Level.WARNING, message);
            this.alertService.raiseAlert(alert, AlertState.ALARM, message);
        }
        this.coordinators.remove(imageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sequencersFinished() {
        Object object = this.agentStateService.getStateLock();
        synchronized (object) {
            this.subsys.setState(this.currentImageCoordinator.sequencersFinished());
        }
        this.currentImageCoordinator = null;
    }

    void addMetaData(Map<String, Serializable> headersMap) {
        ImageCoordinator target = this.currentMetaDataTarget;
        if (target != null) {
            target.setMetaData(headersMap);
        } else {
            this.savedMetaData.putAll(headersMap);
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        if (alert.getAlertId().equals(BAD_PIXELS_ALERTID)) {
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }
}

