/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.data.FormattedHashMap;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.SequencerProc;

public class FocalPlaneCommands {
    private final FocalPlaneSubsystem subsys;

    FocalPlaneCommands(FocalPlaneSubsystem subsys) {
        this.subsys = subsys;
    }

    @Command(type=Command.CommandType.QUERY, description="Get configured CCD types", level=0, autoAck=false)
    public Map<String, String> getCCDType() {
        return (Map)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).enterFaultOnException(true).action(() -> this.forEachReb(reb -> reb.getCcdType().getName()));
    }

    @Command(type=Command.CommandType.QUERY, description="Get sequencer parameter values", autoAck=false)
    public Map<String, Number> getSequencerParameter(@Argument(name="name", description="The parameter name") String name) {
        return (Map)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).enterFaultOnException(true).action(() -> this.forEachReb(this.exceptionCatcher(reb -> reb.getSequencer().getParameter(name))));
    }

    @Command(type=Command.CommandType.QUERY, description="Get sequencer parameter values", autoAck=false)
    public Map<String, Map<String, Integer>> getSequencerParameters() {
        return (Map)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).enterFaultOnException(true).action(() -> this.forEachReb(this.exceptionCatcher(reb -> {
            SequencerProc sequencer = reb.getSequencer();
            LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
            for (String key : sequencer.getPointers().keySet()) {
                result.put(key, sequencer.getParameter(key));
            }
            return result;
        })));
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of REB hardware versions", autoAck=false)
    public Map<String, Number> getREBHwVersions() {
        return (Map)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).enterFaultOnException(true).action(() -> this.forEachReb(reb -> reb.getHwVersion(), "0x%08x"));
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of REB serial numbers", autoAck=false)
    public Map<String, Number> getREBSerialNumbers() {
        return (Map)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).enterFaultOnException(true).action(() -> this.forEachReb(reb -> reb.getSerialNumber(), "%1$d (0x%1$08x)"));
    }

    @Command(type=Command.CommandType.QUERY, description="Get the back bias on states", autoAck=false)
    public Map<String, Boolean> isBackBiasOn() {
        return (Map)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).enterFaultOnException(true).action(() -> this.forEachReb(this.exceptionCatcher(reb -> reb.isBackBiasOn())));
    }

    @Command(type=Command.CommandType.QUERY, description="Get the running states of the sequencers", autoAck=false)
    public Map<String, Boolean> isSequencerRunning() {
        return (Map)this.subsys.helper().enterFaultOnException(true).action(() -> this.forEachReb(this.exceptionCatcher(reb -> reb.getSequencer().isRunning())));
    }

    @Command(type=Command.CommandType.QUERY, description="Get the scan mode enabled states", autoAck=false)
    public Map<String, Boolean> isScanEnabled() {
        return (Map)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).enterFaultOnException(true).action(() -> this.forEachReb(this.exceptionCatcher(reb -> reb.getSequencer().isScanEnabled())));
    }

    private <T> Map<String, T> forEachReb(Function<REBDevice, T> function) {
        return this.forEachReb(function, null);
    }

    private <T> Map<String, T> forEachReb(Function<REBDevice, T> function, String format) {
        return (Map)this.subsys.getRebDevices().entrySet().stream().filter(e -> ((REBDevice)e.getValue()).isOnline()).collect(Collectors.toMap(Map.Entry::getKey, e -> function.apply((REBDevice)e.getValue()), FocalPlaneCommands.throwingMerger(), () -> new FormattedHashMap(format)));
    }

    <T, R> Function<T, R> exceptionCatcher(ExceptionThrowingFunction<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception x) {
                return x;
            }
        };
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private static interface ExceptionThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

