/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.subsystem.airwatch.main.TrendableRecord;

public class TrendableDummyRecord
implements TrendableRecord {
    private static final Logger LOG = Logger.getLogger(TrendableDummyRecord.class.getName());
    private final String masterKey;
    private final Instant masterTimestamp;
    private final Map<String, Serializable> items;

    public TrendableDummyRecord(String masterKey, Instant masterTimestamp, Map<String, Serializable> items) {
        this.masterKey = masterKey;
        this.masterTimestamp = masterTimestamp;
        this.items = new TreeMap<String, Serializable>(items);
    }

    @Override
    public String getMasterKey() {
        return this.masterKey;
    }

    @Override
    public Instant getMasterTimestamp() {
        return this.masterTimestamp;
    }

    @Override
    public List<Alert> getAlerts() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Serializable> getItems() {
        return Collections.unmodifiableMap(this.items);
    }

    @Override
    public void post(Subsystem subsys) {
        LOG.log(Level.INFO, "DUMMY {0} at {1}", new Object[]{this.masterKey, this.masterTimestamp});
        for (String key : this.items.keySet()) {
            LOG.log(Level.INFO, "DUMMY {0} = {1}", new Object[]{key, this.items.get(key).toString()});
        }
    }

    public String toString() {
        StringBuilder repr = new StringBuilder();
        repr.append(String.format("Master key: %s%n", this.masterKey));
        repr.append(String.format("Master time: %s%n", this.masterTimestamp.toString()));
        this.items.forEach((key, value) -> repr.append(String.format("    %s: %s%n", key, value.toString())));
        return repr.toString();
    }
}

