/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentConfig;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentType;
import org.lsst.ccs.subsystem.airwatch.main.LocalConfigService;

public class CCSConfiguration
implements LocalConfigService,
HasLifecycle {
    private static final Logger LOG = Logger.getLogger(CCSConfiguration.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile ConfigurationService ccsConfig;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile AlertService ccsAlert;
    private volatile List<InstrumentConfig> instConfigs;
    private static final int MAX_INSTRUMENTS = 10;
    @ConfigurationParameter(description="The time between readouts.")
    private volatile Duration readoutInterval = Duration.ofHours(1L);
    @ConfigurationParameter(description="Instrument make and/or model.", maxLength=10)
    private volatile String[] instrumentTypes = new String[0];
    @ConfigurationParameter(description="How to open a connection to the instrument.", maxLength=10)
    private volatile String[] instrumentConnections = new String[0];
    @ConfigurationParameter(description="Locations of instruments.", maxLength=10)
    private volatile String[] instrumentLocations = new String[0];
    @ConfigurationParameter(description="Short names of instruments.", maxLength=10)
    private volatile String[] instrumentShortNames = new String[0];
    @ConfigurationParameter(description="Short names of instruments to use for dew point calaculation.", maxLength=10)
    private volatile String[] dewShortNames = new String[0];
    @ConfigurationParameter(description="Which instruments are working? 0 = not working.", maxLength=10)
    private volatile int[] instrumentWorking = new int[0];
    @ConfigurationParameter(description="The name or IPv4 address of the SMTP server.")
    private volatile String SMTPServer = "";
    @ConfigurationParameter(description="Email address, possibly fake, used as email sender.")
    private volatile String emailSender = "";
    @ConfigurationParameter(description="Real email address which receives bounced messages.")
    private volatile String emailBounceTo = "";
    @ConfigurationParameter(description="List of recipients of alarm emails.", maxLength=10)
    private volatile String[] emailRecipients = new String[0];
    @ConfigurationParameter(description="Connection information for LMS Express OPC servers.", maxLength=10)
    private volatile Map<String, List<String>> opcServers = Collections.emptyMap();

    @Override
    public void makeConfigurationObjects() {
        LOG.info(this.ccsConfig.printConfigurationParameters(new String[0]));
        this.makeInstrumentConfigs();
    }

    private void makeInstrumentConfigs() {
        int numInstruments = this.instrumentLocations.length;
        if (this.instrumentConnections.length != numInstruments || this.instrumentShortNames.length != numInstruments || this.instrumentTypes.length != numInstruments || this.instrumentWorking.length != numInstruments) {
            throw new IllegalArgumentException("Bad configuration. Not all the instrumentXxx arrays are the same length.");
        }
        if (numInstruments == 0) {
            throw new IllegalArgumentException("Bad configuration. No instruments defined!");
        }
        ArrayList<InstrumentType> types = new ArrayList<InstrumentType>(numInstruments);
        for (String configType : this.instrumentTypes) {
            Optional<InstrumentType> enumType = InstrumentType.parse(configType);
            if (!enumType.isPresent()) {
                throw new IllegalArgumentException(String.format("\"%s\" is not a valid instrument type.", configType));
            }
            types.add(enumType.get());
        }
        this.instConfigs = Collections.unmodifiableList(IntStream.range(0, numInstruments).mapToObj(i -> new InstrumentConfig(i, (InstrumentType)((Object)((Object)types.get(i))), this.instrumentConnections[i], this.instrumentLocations[i], this.instrumentShortNames[i], this.instrumentWorking[i] != 0, this, this.ccsAlert)).collect(Collectors.toList()));
    }

    @Override
    public List<InstrumentConfig> getInstrumentConfigs() {
        return this.instConfigs;
    }

    @Override
    public List<String> getDewShortNames() {
        return Collections.unmodifiableList(Arrays.asList(this.dewShortNames));
    }

    @Override
    public Duration getReadoutInterval() {
        return this.readoutInterval;
    }

    @Override
    public String getEmailSender() {
        return this.emailSender;
    }

    @Override
    public String getEmailBounceAddress() {
        return this.emailBounceTo;
    }

    @Override
    public String getSMTPServer() {
        return this.SMTPServer;
    }

    @Override
    public List<String> getEmailRecipients() {
        return Collections.unmodifiableList(Arrays.asList(this.emailRecipients));
    }

    @Override
    public List<String> getOPCServerInfo(String serverKey) {
        return Collections.unmodifiableList(this.opcServers.get(serverKey));
    }

    public void init() {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.ccsConfig == null) {
            missing.add("CCS configuration service");
        }
        if (!missing.isEmpty()) {
            throw new RuntimeException("Can't find " + String.join((CharSequence)", ", missing));
        }
    }
}

