/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.airwatch.main.Alerts;
import org.lsst.ccs.subsystem.airwatch.main.AnalogPoint;
import org.lsst.ccs.subsystem.airwatch.main.EmailSender;
import org.lsst.ccs.subsystem.airwatch.main.Instrument;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentChannel;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentConfig;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentReport;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentStatus;
import org.lsst.ccs.subsystem.airwatch.main.LocalConfigService;
import org.lsst.ccs.subsystem.airwatch.main.TrendableRecord;
import org.lsst.ccs.subsystem.airwatch.main.Utility;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public final class AirwatchMain
extends Subsystem
implements ClearAlertHandler,
HardwareController,
HasLifecycle,
SignalHandler {
    private static final int BUSY_TIMEOUT = 120000;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private volatile LocalConfigService config;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile AlertService alertService;
    private final CopyOnWriteArrayList<Instrument> instruments;
    private final Lock readoutLock;
    private PeriodicTask readoutTask;
    private final Logger log;
    private EmailSender mailSender;
    public static final String N_DEW_TEMPS_KEY = "calculated/nDewTemps";
    public static final String N_DEW_HUMIDS_KEY = "calculated/nDewHumids";
    public static final String DEW_POINT_KEY = "calculated/dewPoint";

    @Command(type=Command.CommandType.QUERY, description="Displays a short report on instrument status.", level=0)
    public String instruments() {
        return new InstrumentReport(this.instruments).toString();
    }

    @Command(type=Command.CommandType.ACTION, description="Prevents further readout of an instrument", level=1, timeout=120100)
    public String disable(@Argument(description="Instrument index number.") int index) throws Exception {
        return this.callIfNotBusy(() -> {
            Instrument ins = this.instruments.get(index);
            this.instruments.set(ins.getIndex(), ins.disable());
            return "OK";
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Enables an instrument for readout.", level=1, timeout=121000)
    public String enable(@Argument(description="Instrument index number.") int index) throws Exception {
        return this.callIfNotBusy(() -> {
            Instrument ins = this.instruments.get(index);
            Instrument newIns = ins.enable();
            this.instruments.set(ins.getIndex(), newIns);
            if (newIns.getLastException().isPresent()) {
                throw newIns.getLastException().get();
            }
            return "OK";
        });
    }

    public TreeWalkerDiag signal(Signal sig) {
        if (sig.getLevel() == SignalLevel.STOP) {
            this.readoutTask.cancel(false);
        } else if (sig.getLevel() == SignalLevel.HALT) {
            this.readoutTask.cancel(true);
        }
        return TreeWalkerDiag.GO;
    }

    public AirwatchMain() {
        super("airwatch", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
        this.config = null;
        this.alertService = null;
        this.instruments = new CopyOnWriteArrayList();
        this.log = Logger.getLogger((String)AirwatchMain.class.getName());
        this.readoutTask = null;
        this.readoutLock = new ReentrantLock();
    }

    public void init() {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.config == null) {
            missing.add("LocalConfigService component");
        }
        if (this.alertService == null) {
            missing.add("CCS alert service");
        }
        if (!missing.isEmpty()) {
            throw new RuntimeException("Can't find " + String.join((CharSequence)", ", missing));
        }
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        this.config.makeConfigurationObjects();
        this.readConfiguration();
        this.scheduleFirstReadout(Duration.ZERO);
        return TreeWalkerDiag.GO;
    }

    public void start() {
        this.mailSender = new EmailSender(this.config, this.alertService);
    }

    private void readConfiguration() {
        List<InstrumentConfig> configs = this.config.getInstrumentConfigs();
        List insts = configs.stream().map(cfg -> cfg.type.make((InstrumentConfig)cfg)).collect(Collectors.toList());
        this.instruments.addAll(insts);
    }

    private void scheduleFirstReadout(Duration initialDelay) {
        this.readoutTask = this.getScheduler().scheduleAtFixedRate(this::readoutTaskBody, initialDelay.getSeconds(), this.config.getReadoutInterval().getSeconds(), TimeUnit.SECONDS);
    }

    private void readoutTaskBody() {
        try {
            this.readoutLock.lockInterruptibly();
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            this.instruments.stream().filter(ins -> ins.getStatus().enabled).forEach(ins -> {
                if (Thread.currentThread().isInterrupted()) {
                    throw new TerminationException();
                }
                this.readAndUpdate((Instrument)ins);
            });
            this.publishDewPoint();
        }
        catch (TerminationException exc) {
            this.log.warning((Object)"Instrument readout was interrupted!");
        }
        finally {
            this.readoutLock.unlock();
        }
    }

    private void readAndUpdate(Instrument ins) {
        Instrument newIns = ins.read();
        this.instruments.set(ins.getIndex(), newIns);
        this.checkForExceptionDuringReadout(newIns);
        newIns.getTrendables().forEach(msg -> msg.post(this));
    }

    private boolean checkForExceptionDuringReadout(Instrument newIns) {
        newIns.getLastException().ifPresent(exc -> {
            String badloc = newIns.getStatus().location;
            String cause = badloc + ": " + exc.getMessage();
            this.alertService.raiseAlert(Alerts.instrumentIOAlert(badloc), AlertState.WARNING, cause);
            this.mailSender.send(cause, (Throwable)exc);
        });
        return newIns.getLastException().isPresent();
    }

    public void postStart() {
    }

    public void checkStopped() throws HardwareException {
        this.readoutTask.cancel(false);
        if (!this.readoutTask.isCancelled()) {
            throw new HardwareException(false, "Could not cancel the readout task.");
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
        return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
    }

    private List<Instrument> findInstrumentsByShortName(Collection<String> shorts) {
        return this.instruments.stream().filter(ins -> {
            InstrumentStatus status = ins.getStatus();
            Boolean found = shorts.contains(status.shortName);
            return found;
        }).collect(Collectors.toList());
    }

    private String callIfNotBusy(Callable<String> cmd) throws Exception {
        if (!this.readoutLock.tryLock(120000L, TimeUnit.MILLISECONDS)) {
            return "BUSY";
        }
        try {
            String string = cmd.call();
            return string;
        }
        finally {
            this.readoutLock.unlock();
        }
    }

    private List<TrendableRecord> getDewPointData(Instrument ins) {
        if (!ins.getStatus().enabled) {
            return Collections.emptyList();
        }
        return ins.getTrendables().filter(tr -> {
            Map<String, Serializable> items = tr.getItems();
            return items.containsKey(InstrumentChannel.TEMPERATURE.getKey()) || items.containsKey(InstrumentChannel.HUMIDITY.getKey());
        }).collect(Collectors.toList());
    }

    private void publishDewPoint() {
        ArrayList<TrendableRecord> readings = new ArrayList<TrendableRecord>();
        for (Instrument ins : this.findInstrumentsByShortName(this.config.getDewShortNames())) {
            readings.addAll(this.getDewPointData(ins));
        }
        List temps = readings.stream().map(tr -> (AnalogPoint)tr.getItems().get(InstrumentChannel.TEMPERATURE.getKey())).filter(ap -> ap != null).map(ap -> ap.value).collect(Collectors.toList());
        List humids = readings.stream().map(tr -> (AnalogPoint)tr.getItems().get(InstrumentChannel.HUMIDITY.getKey())).filter(ap -> ap != null).map(ap -> ap.value).collect(Collectors.toList());
        if (temps.isEmpty() || humids.isEmpty()) {
            this.log.log(Level.WARNING, "Cannot calculate dew point: nDewTemps = {0}, nDewHumids = {1}.", new Object[]{temps.size(), humids.size()});
            return;
        }
        double tempMean = temps.stream().mapToDouble(Double::doubleValue).average().getAsDouble();
        double humidMean = humids.stream().mapToDouble(Double::doubleValue).average().getAsDouble();
        double tdp = Utility.dewPoint(tempMean, humidMean);
        KeyValueDataList calc = new KeyValueDataList();
        calc.addData(N_DEW_TEMPS_KEY, (Serializable)Integer.valueOf(temps.size()));
        calc.addData(N_DEW_HUMIDS_KEY, (Serializable)Integer.valueOf(humids.size()));
        calc.addData(DEW_POINT_KEY, (Serializable)Double.valueOf(tdp));
        this.publishSubsystemDataOnStatusBus((KeyValueData)calc);
    }

    private static class TerminationException
    extends RuntimeException {
        private TerminationException() {
        }
    }
}

