/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.cluster.monitor.data.DataType;

public class BusTrafficDevice
extends Device {
    private final List<String> channelDataList = new ArrayList<String>();
    private Map dataMap;
    private final Object dataLock = new Object();
    @ConfigurationParameter(isFinal=true)
    private DataType type;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Map<String, Channel> channels = new HashMap<String, Channel>();

    protected void initDevice() {
        super.initDevice();
        this.setOnline(true);
        for (String path : this.channels.keySet()) {
            Channel c = this.channels.get(path);
            this.channelDataList.add(this.type.name().toLowerCase() + "/" + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDataMap(Map dataMap) {
        Object object = this.dataLock;
        synchronized (object) {
            this.dataMap = dataMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double readChannel(Channel ch) {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.dataMap == null) {
                return Double.NaN;
            }
            Object value = this.dataMap.get(this.type.name().toLowerCase() + "/" + ch.getName());
            if (value == null) {
                return Double.NaN;
            }
            if (value instanceof Integer) {
                return ((Integer)value).doubleValue();
            }
            return (Double)value;
        }
    }

    DataType getType() {
        return this.type;
    }

    protected void close() {
    }

    protected void initialize() {
    }

    Collection<String> getDataList() {
        return this.channelDataList;
    }
}

