/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.lsst.ccs.integrationgantrygui.CameraPanel;
import org.lsst.ccs.integrationgantrygui.ScalableImageProvider;
import org.lsst.ccs.integrationgantrygui.icon.ArrowDown;
import org.lsst.ccs.integrationgantrygui.icon.ArrowLeft;
import org.lsst.ccs.integrationgantrygui.icon.ArrowRight;
import org.lsst.ccs.integrationgantrygui.icon.ArrowUp;

public class IntegrationGantryFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int ICON_SIZE = 24;
    private final CameraPanel[] cameraPanels;
    private final ScalableImageProvider[] imageProvider;
    private ScalableImageProvider.Scaling scaling = ScalableImageProvider.Scaling.LOG;
    private final JLabel[] axes;
    private GridSize gridSize = GridSize.ONE_CM;
    private JLabel bottomCoordinateLabel;
    private CameraPanel cameraPanel1;
    private CameraPanel cameraPanel2;
    private CameraPanel cameraPanel3;
    private CameraPanel cameraPanel4;
    private JPanel coordinatePanel;
    private JComboBox<ScalableImageProvider.Scaling> displayComboBox;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JTextField fpsTextBox;
    private JComboBox<GridSize> gridSizeComboBox;
    private JMenu gridSizeMenu;
    private JPanel imagePanel;
    private JMenu imageScalingMenu;
    private JLabel jLabel1;
    private JMenuBar jMenuBar1;
    private JLabel leftCoordinateLabel;
    private JCheckBoxMenuItem presevereAspectRatioMenuItem;
    private JLabel rightCoordinateLabel;
    private JCheckBox showEdgesCheckBox;
    private JCheckBoxMenuItem showEdgesMenuItem;
    private JCheckBox showGridCheckBox;
    private JCheckBoxMenuItem showGridMenuItem;
    private JCheckBoxMenuItem showROIMenuItem;
    private JLabel topCoordinateLabel;
    private JCheckBoxMenuItem viewCoordinatesMenuItem;
    private JMenu viewMenu;
    private JCheckBox zoomCheckBox;
    private JCheckBoxMenuItem zoomToROIMenuItem;

    public IntegrationGantryFrame() {
        this.initComponents();
        this.displayComboBox.setModel(new DefaultComboBoxModel<ScalableImageProvider.Scaling>(ScalableImageProvider.Scaling.values()));
        ButtonGroup scaleGroup = new ButtonGroup();
        for (ScalableImageProvider.Scaling scale : ScalableImageProvider.Scaling.values()) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(scale.toString(), scale == this.scaling);
            scaleGroup.add(menuItem);
            this.imageScalingMenu.add(menuItem);
            menuItem.addActionListener(evt -> this.setScaling(scale));
        }
        this.displayComboBox.setSelectedItem((Object)this.scaling);
        this.gridSizeComboBox.setModel(new DefaultComboBoxModel<GridSize>(GridSize.values()));
        ButtonGroup gridSizeGroup = new ButtonGroup();
        for (GridSize gs : GridSize.values()) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(gs.toString(), gs == this.gridSize);
            gridSizeGroup.add(menuItem);
            this.gridSizeMenu.add(menuItem);
            menuItem.addActionListener(evt -> this.setGridSize(gs));
        }
        this.gridSizeComboBox.setSelectedItem((Object)this.gridSize);
        this.cameraPanels = new CameraPanel[]{this.cameraPanel1, this.cameraPanel2, this.cameraPanel3, this.cameraPanel4};
        this.axes = new JLabel[]{this.topCoordinateLabel, this.bottomCoordinateLabel, this.rightCoordinateLabel, this.leftCoordinateLabel};
        this.imageProvider = new ScalableImageProvider[4];
    }

    void setImage(int i, ScalableImageProvider image) {
        this.imageProvider[i] = image;
        this.cameraPanels[i].setImage(image.createScaledImage(this.scaling));
    }

    void setLabel(int i, double h1, double h2, double v1, double v2) {
        this.cameraPanels[i].setLabels(h1, h2, v1, v2);
    }

    void setFPS(int fps) {
        SwingUtilities.invokeLater(() -> {
            this.fpsTextBox.setText(String.valueOf(fps));
            this.fpsTextBox.setForeground(fps < 1 ? Color.RED : this.fpsTextBox.getParent().getForeground());
        });
    }

    void setROI(boolean horizontal, int index, List<Number> roi) {
        this.cameraPanels[index].setROI(horizontal, roi);
    }

    private void initComponents() {
        JPanel jPanel6 = new JPanel();
        this.displayComboBox = new JComboBox();
        this.fpsTextBox = new JTextField();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        this.zoomCheckBox = new JCheckBox();
        this.showEdgesCheckBox = new JCheckBox();
        this.showGridCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.gridSizeComboBox = new JComboBox();
        this.coordinatePanel = new JPanel();
        this.imagePanel = new JPanel();
        this.cameraPanel1 = new CameraPanel();
        this.cameraPanel2 = new CameraPanel();
        this.cameraPanel3 = new CameraPanel();
        this.cameraPanel4 = new CameraPanel();
        this.topCoordinateLabel = new JLabel();
        this.bottomCoordinateLabel = new JLabel();
        this.rightCoordinateLabel = new JLabel();
        this.leftCoordinateLabel = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.viewCoordinatesMenuItem = new JCheckBoxMenuItem();
        this.showROIMenuItem = new JCheckBoxMenuItem();
        this.zoomToROIMenuItem = new JCheckBoxMenuItem();
        this.showEdgesMenuItem = new JCheckBoxMenuItem();
        this.showGridMenuItem = new JCheckBoxMenuItem();
        this.presevereAspectRatioMenuItem = new JCheckBoxMenuItem();
        this.imageScalingMenu = new JMenu();
        this.gridSizeMenu = new JMenu();
        this.setDefaultCloseOperation(3);
        this.setTitle("Integration Gantry Cameras");
        this.displayComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegrationGantryFrame.this.displayComboBoxActionPerformed(evt);
            }
        });
        this.fpsTextBox.setEditable(false);
        this.fpsTextBox.setColumns(3);
        this.fpsTextBox.setText("100");
        jLabel5.setText("Frames Per Second:");
        jLabel6.setText("Image scaling:");
        this.zoomCheckBox.setText("Zoom to ROI");
        this.zoomCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegrationGantryFrame.this.zoomCheckBoxActionPerformed(evt);
            }
        });
        this.showEdgesCheckBox.setSelected(true);
        this.showEdgesCheckBox.setText("Show Edges");
        this.showEdgesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegrationGantryFrame.this.showEdgesCheckBoxActionPerformed(evt);
            }
        });
        this.showGridCheckBox.setModel(this.showGridMenuItem.getModel());
        this.showGridCheckBox.setText("Show Grid");
        this.jLabel1.setText("Grid Size:");
        this.gridSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegrationGantryFrame.this.gridSizeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.zoomCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showEdgesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showGridCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gridSizeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 586, Short.MAX_VALUE).addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fpsTextBox, -2, -1, -2)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayComboBox, -2, -1, -2).addComponent(this.fpsTextBox, -2, -1, -2).addComponent(jLabel5).addComponent(jLabel6).addComponent(this.zoomCheckBox).addComponent(this.showEdgesCheckBox).addComponent(this.showGridCheckBox).addComponent(this.jLabel1).addComponent(this.gridSizeComboBox, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        this.getContentPane().add((Component)jPanel6, "South");
        this.coordinatePanel.setLayout(new BorderLayout());
        this.imagePanel.setLayout(new GridLayout(2, 2));
        this.cameraPanel1.setBorder(BorderFactory.createTitledBorder("Camera 1"));
        this.cameraPanel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IntegrationGantryFrame.this.cameraPanel1MouseClicked(evt);
            }
        });
        this.imagePanel.add(this.cameraPanel1);
        this.cameraPanel2.setBorder(BorderFactory.createTitledBorder("Camera 2"));
        this.cameraPanel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IntegrationGantryFrame.this.cameraPanel2MouseClicked(evt);
            }
        });
        this.imagePanel.add(this.cameraPanel2);
        this.cameraPanel3.setBorder(BorderFactory.createTitledBorder("Camera 3"));
        this.cameraPanel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IntegrationGantryFrame.this.cameraPanel3MouseClicked(evt);
            }
        });
        this.imagePanel.add(this.cameraPanel3);
        this.cameraPanel4.setBorder(BorderFactory.createTitledBorder("Camera 4"));
        this.cameraPanel4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IntegrationGantryFrame.this.cameraPanel4MouseClicked(evt);
            }
        });
        this.imagePanel.add(this.cameraPanel4);
        this.coordinatePanel.add((Component)this.imagePanel, "Center");
        this.topCoordinateLabel.setHorizontalAlignment(0);
        this.topCoordinateLabel.setIcon(new ArrowUp(24, 24));
        this.topCoordinateLabel.setText("+X West");
        this.coordinatePanel.add((Component)this.topCoordinateLabel, "North");
        this.bottomCoordinateLabel.setHorizontalAlignment(0);
        this.bottomCoordinateLabel.setIcon(new ArrowDown(24, 24));
        this.bottomCoordinateLabel.setText("-X East");
        this.coordinatePanel.add((Component)this.bottomCoordinateLabel, "Last");
        this.rightCoordinateLabel.setIcon(new ArrowRight(24, 24));
        this.rightCoordinateLabel.setText("<HTML><center><br>+Y<br> <br>S<br>o<br>u<br>t<br>h<br></center>");
        this.rightCoordinateLabel.setHorizontalTextPosition(0);
        this.rightCoordinateLabel.setVerticalTextPosition(3);
        this.coordinatePanel.add((Component)this.rightCoordinateLabel, "After");
        this.leftCoordinateLabel.setHorizontalAlignment(0);
        this.leftCoordinateLabel.setIcon(new ArrowLeft(24, 24));
        this.leftCoordinateLabel.setText("<HTML><center><br>-Y<br> <br>N<br>o<br>r<br>t<br>h<br></center>");
        this.leftCoordinateLabel.setHorizontalTextPosition(0);
        this.leftCoordinateLabel.setVerticalTextPosition(3);
        this.coordinatePanel.add((Component)this.leftCoordinateLabel, "Before");
        this.getContentPane().add((Component)this.coordinatePanel, "Center");
        this.fileMenu.setText("File");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegrationGantryFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.viewCoordinatesMenuItem.setSelected(true);
        this.viewCoordinatesMenuItem.setText("Show Coordinate Axes");
        this.viewCoordinatesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegrationGantryFrame.this.viewCoordinatesMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewCoordinatesMenuItem);
        this.showROIMenuItem.setSelected(true);
        this.showROIMenuItem.setText("Show ROIs");
        this.showROIMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegrationGantryFrame.this.showROIMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.showROIMenuItem);
        this.zoomToROIMenuItem.setSelected(true);
        this.zoomToROIMenuItem.setText("Zoom to ROI");
        this.zoomToROIMenuItem.setModel(this.zoomCheckBox.getModel());
        this.viewMenu.add(this.zoomToROIMenuItem);
        this.showEdgesMenuItem.setSelected(true);
        this.showEdgesMenuItem.setText("Show Edges");
        this.showEdgesMenuItem.setModel(this.showEdgesCheckBox.getModel());
        this.viewMenu.add(this.showEdgesMenuItem);
        this.showGridMenuItem.setSelected(true);
        this.showGridMenuItem.setText("Show Grid");
        this.showGridMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegrationGantryFrame.this.showGridMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.showGridMenuItem);
        this.presevereAspectRatioMenuItem.setSelected(true);
        this.presevereAspectRatioMenuItem.setText("Preserve Aspect Ratio");
        this.presevereAspectRatioMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntegrationGantryFrame.this.presevereAspectRatioMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.presevereAspectRatioMenuItem);
        this.imageScalingMenu.setText("Image Scaling");
        this.viewMenu.add(this.imageScalingMenu);
        this.gridSizeMenu.setText("Grid Size");
        this.viewMenu.add(this.gridSizeMenu);
        this.jMenuBar1.add(this.viewMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void displayComboBoxActionPerformed(ActionEvent evt) {
        ScalableImageProvider.Scaling newScaling = this.displayComboBox.getItemAt(this.displayComboBox.getSelectedIndex());
        this.setScaling(newScaling);
    }

    private void setScaling(ScalableImageProvider.Scaling newScaling) {
        if (newScaling != this.scaling) {
            this.scaling = newScaling;
            this.displayComboBox.setSelectedItem((Object)newScaling);
            for (Component c : this.imageScalingMenu.getMenuComponents()) {
                if (!(c instanceof JMenuItem) || !((JMenuItem)c).getText().equals(this.scaling.toString())) continue;
                ((JMenuItem)c).setSelected(true);
            }
            for (int i = 0; i < 4; ++i) {
                if (this.cameraPanels == null) continue;
                this.cameraPanels[i].setImage(this.imageProvider[i].createScaledImage(newScaling));
            }
        }
    }

    private void setGridSize(GridSize gs) {
        if (gs != this.gridSize) {
            this.gridSize = gs;
            this.gridSizeComboBox.setSelectedItem((Object)gs);
            for (Component component : this.gridSizeMenu.getMenuComponents()) {
                if (!(component instanceof JMenuItem) || !((JMenuItem)component).getText().equals(gs.toString())) continue;
                ((JMenuItem)component).setSelected(true);
            }
            for (Component component : this.cameraPanels) {
                ((CameraPanel)component).setGridSize(gs.getSize());
            }
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void viewCoordinatesMenuItemActionPerformed(ActionEvent evt) {
        for (JLabel label : this.axes) {
            label.setVisible(this.viewCoordinatesMenuItem.isSelected());
        }
        this.validate();
        this.repaint();
    }

    private void showROIMenuItemActionPerformed(ActionEvent evt) {
        for (CameraPanel panel : this.cameraPanels) {
            panel.setShowROI(this.showROIMenuItem.isSelected());
        }
    }

    private void cameraPanel1MouseClicked(MouseEvent evt) {
        this.cameraPanelMouseClicked(evt, 0);
    }

    private void cameraPanel2MouseClicked(MouseEvent evt) {
        this.cameraPanelMouseClicked(evt, 1);
    }

    private void cameraPanel3MouseClicked(MouseEvent evt) {
        this.cameraPanelMouseClicked(evt, 2);
    }

    private void cameraPanel4MouseClicked(MouseEvent evt) {
        this.cameraPanelMouseClicked(evt, 3);
    }

    private void zoomCheckBoxActionPerformed(ActionEvent evt) {
        for (CameraPanel panel : this.cameraPanels) {
            panel.setZoomToROI(this.zoomCheckBox.isSelected());
        }
    }

    private void showEdgesCheckBoxActionPerformed(ActionEvent evt) {
        for (CameraPanel panel : this.cameraPanels) {
            panel.setShowEdges(this.showEdgesCheckBox.isSelected());
        }
    }

    private void showGridMenuItemActionPerformed(ActionEvent evt) {
        for (CameraPanel panel : this.cameraPanels) {
            panel.setShowGrid(this.showGridMenuItem.isSelected());
        }
    }

    private void presevereAspectRatioMenuItemActionPerformed(ActionEvent evt) {
        for (CameraPanel panel : this.cameraPanels) {
            panel.setPreserveAspectRatio(this.presevereAspectRatioMenuItem.isSelected());
        }
    }

    private void gridSizeComboBoxActionPerformed(ActionEvent evt) {
        GridSize newSize = this.gridSizeComboBox.getItemAt(this.gridSizeComboBox.getSelectedIndex());
        this.setGridSize(newSize);
    }

    private void cameraPanelMouseClicked(MouseEvent evt, int position) {
        if (evt.getClickCount() == 2) {
            Component clickedPanel = evt.getComponent();
            if (clickedPanel.getParent() == this.coordinatePanel) {
                this.coordinatePanel.remove(clickedPanel);
                this.coordinatePanel.add((Component)this.imagePanel, "Center");
                this.imagePanel.add(clickedPanel, position);
            } else {
                this.imagePanel.remove(clickedPanel);
                this.coordinatePanel.remove(this.imagePanel);
                this.coordinatePanel.add(clickedPanel, "Center");
            }
            this.coordinatePanel.validate();
            this.repaint();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(IntegrationGantryFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> new IntegrationGantryFrame().setVisible(true));
    }

    private static enum GridSize {
        ONE_CM("1cm", 400),
        FIVE_MM("5mm", 200),
        TWO_MM("2mm", 80),
        ONE_MM("1mm", 40);

        private final int size;
        private final String text;

        private GridSize(String name, int size) {
            this.text = name;
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public String toString() {
            return this.text;
        }
    }
}

