/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;
import org.lsst.ccs.subsystem.shutter.plc.Tools;

public class ShutterStatusPLC
extends MsgToCCS {
    private final int motionProfile;
    private final boolean isCalibrated;
    private final int smState;
    private final Map<ShutterSide, AxisStatusPLC> axstatus;
    private final boolean isSafetyOn;
    private final List<Integer> temperature;

    public ShutterStatusPLC(int sequence, int motionProfile, boolean isCalibrated, int smState, Map<ShutterSide, AxisStatusPLC> axstatus, boolean isSafetyOn, List<Integer> temperature) {
        super(sequence);
        this.motionProfile = motionProfile;
        this.isCalibrated = isCalibrated;
        this.smState = smState;
        this.axstatus = axstatus;
        this.isSafetyOn = isSafetyOn;
        this.temperature = temperature;
    }

    public ShutterStatusPLC(ByteBuffer data) {
        super(data);
        this.motionProfile = data.getInt();
        this.isCalibrated = Tools.getBoolean(data);
        this.smState = data.getInt();
        EnumMap<ShutterSide, AxisStatusPLC> axes = new EnumMap<ShutterSide, AxisStatusPLC>(ShutterSide.class);
        axes.put(ShutterSide.fromAxis(Axis.AXIS0), ShutterStatusPLC.decodeAxisStatus(data));
        axes.put(ShutterSide.fromAxis(Axis.AXIS1), ShutterStatusPLC.decodeAxisStatus(data));
        this.axstatus = axes;
        this.isSafetyOn = Tools.getBoolean(data);
        ArrayList<Integer> temp = new ArrayList<Integer>(3);
        temp.add(data.getInt());
        temp.add(data.getInt());
        temp.add(data.getInt());
        this.temperature = temp;
    }

    private static AxisStatusPLC decodeAxisStatus(ByteBuffer data) {
        double actPos = data.getDouble();
        double actVel = data.getDouble();
        double setAcc = data.getDouble();
        boolean enabled = Tools.getBoolean(data);
        boolean brakeEngaged = Tools.getBoolean(data);
        boolean lowLimit = Tools.getBoolean(data);
        boolean highLimit = Tools.getBoolean(data);
        boolean isHomed = Tools.getBoolean(data);
        int errorID = data.getInt();
        double motorTemp = data.getDouble();
        return new AxisStatusPLC(actPos, actVel, setAcc, enabled, brakeEngaged, lowLimit, highLimit, isHomed, errorID, motorTemp);
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putInt(this.getMotionProfile());
        Tools.putBoolean(data, this.isCalibrated());
        data.putInt(this.getSmState());
        for (Axis ax : Axis.values()) {
            ShutterStatusPLC.encodeAxisStatus(data, this.getAxisStatus(ShutterSide.fromAxis(ax)));
        }
        Tools.putBoolean(data, this.isSafetyOn());
        this.getTemperature().forEach(data::putInt);
    }

    private static void encodeAxisStatus(ByteBuffer data, AxisStatusPLC status) {
        data.putDouble(status.getActPos());
        data.putDouble(status.getActVel());
        data.putDouble(status.getSetAcc());
        Tools.putBoolean(data, status.isEnabled());
        Tools.putBoolean(data, status.isBrakeEngaged());
        Tools.putBoolean(data, status.atLowLimit());
        Tools.putBoolean(data, status.atHighLimit());
        Tools.putBoolean(data, status.isHomed());
        data.putInt(status.getErrorID());
        data.putDouble(status.getMotorTemp());
    }

    public int getMotionProfile() {
        return this.motionProfile;
    }

    public boolean isCalibrated() {
        return this.isCalibrated;
    }

    public int getSmState() {
        return this.smState;
    }

    public AxisStatusPLC getAxisStatus(ShutterSide side) {
        return this.axstatus.get((Object)side);
    }

    public boolean isSafetyOn() {
        return this.isSafetyOn;
    }

    public List<Integer> getTemperature() {
        return new ArrayList<Integer>(this.temperature);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ShutterStatusPLC{");
        sb.append(super.toString());
        sb.append(", motionProfile=").append(this.motionProfile);
        sb.append(", isCalibrated=").append(this.isCalibrated);
        sb.append(", smState=").append(this.smState);
        sb.append(", axstatus=").append(this.axstatus);
        sb.append(", isSafetyOn=").append(this.isSafetyOn);
        sb.append(", temperature=").append(this.temperature);
        sb.append('}');
        return sb.toString();
    }

    public static final class AxisStatusPLC {
        private final double actPos;
        private final double actVel;
        private final double setAcc;
        private final boolean enabled;
        private final boolean brakeEngaged;
        private final boolean lowLimit;
        private final boolean highLimit;
        private final boolean isHomed;
        private final int errorID;
        private final double motorTemp;

        public AxisStatusPLC(double actPos, double actVel, double setAcc, boolean enabled, boolean brakeEngaged, boolean lowLimit, boolean highLimit, boolean isHomed, int errorID, double motorTemp) {
            this.actPos = actPos;
            this.actVel = actVel;
            this.setAcc = setAcc;
            this.enabled = enabled;
            this.brakeEngaged = brakeEngaged;
            this.lowLimit = lowLimit;
            this.highLimit = highLimit;
            this.isHomed = isHomed;
            this.errorID = errorID;
            this.motorTemp = motorTemp;
        }

        public String toString() {
            return "AxisStatusPLC{actPos=" + this.actPos + ", actVel=" + this.actVel + ", setAcc=" + this.setAcc + ", enabled=" + this.enabled + ", brakeEngaged=" + this.brakeEngaged + ", lowLimit=" + this.lowLimit + ", highLimit=" + this.highLimit + ", isHomed=" + this.isHomed + ", errorID=" + this.errorID + ", motorTemp=" + this.motorTemp + '}';
        }

        public double getActPos() {
            return this.actPos;
        }

        public double getActVel() {
            return this.actVel;
        }

        public double getSetAcc() {
            return this.setAcc;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isBrakeEngaged() {
            return this.brakeEngaged;
        }

        public boolean atLowLimit() {
            return this.lowLimit;
        }

        public boolean atHighLimit() {
            return this.highLimit;
        }

        public boolean isHomed() {
            return this.isHomed;
        }

        public int getErrorID() {
            return this.errorID;
        }

        public double getMotorTemp() {
            return this.motorTemp;
        }
    }
}

