/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.utility.PurgeTestMain;
import org.lsst.ccs.subsystem.utility.constants.HeaterState;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class Maq20DevicePT
extends Maq20Device {
    public static final int CHAN_UT_VALVE = 0;
    public static final int CHAN_VPC_VALVE = 1;
    public static final int CHAN_SIM_HEATER = 2;
    private static final double[][] convAmpsToVFract = new double[][]{{0.004, 0.0}, {0.005, 0.0}, {0.006, 0.145}, {0.007, 0.19}, {0.008, 0.248}, {0.009, 0.302}, {0.01, 0.371}, {0.011, 0.394}, {0.012, 0.459}, {0.013, 0.541}, {0.014, 0.624}, {0.015, 0.625}, {0.016, 0.655}, {0.017, 0.744}, {0.018, 0.787}, {0.019, 0.858}, {0.02, 1.0}};
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private PurgeTestMain main;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20AnalogControl maqCtrl;
    private static final Logger LOG = Logger.getLogger(Maq20DevicePT.class.getName());
    private int modIndex;

    public void initDevice() {
        super.initDevice();
        if (this.maqCtrl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"analog control", (String)"not defined");
        }
        this.modIndex = this.maqCtrl.getModIndex();
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if ((type & 0xFF) == this.modIndex) {
            if (hwChan == 1 || hwChan == 0) {
                value = 62.5 * value - 0.25;
            } else if (hwChan == 2) {
                HeaterState state = this.main.getFullState().getHeaterState(2);
                value = state == HeaterState.OFF ? 0.0 : (state == HeaterState.OFFLINE ? Double.NaN : this.convVFractAndAmps(false, value));
            }
        }
        return value;
    }

    public void setVpcValve(double posn) throws UtilityException {
        this.setValve(1, posn);
    }

    public void setUtValve(double posn) throws UtilityException {
        this.setValve(0, posn);
    }

    public void setValve(int chan, double posn) throws UtilityException {
        double value = 0.016 * Math.min(Math.max(posn, 0.0), 1.0) + 0.004;
        try {
            this.maqCtrl.writeValue(chan, value);
        }
        catch (DriverException e) {
            throw new UtilityException("Error operating valve (channel " + chan + "): " + (Object)((Object)e));
        }
    }

    public void setSimHeater(double duty) throws UtilityException {
        try {
            this.maqCtrl.writeValue(2, this.convVFractAndAmps(true, duty));
        }
        catch (DriverException e) {
            throw new UtilityException("Error operating simulator heater: " + (Object)((Object)e));
        }
    }

    private double convVFractAndAmps(boolean toAmps, double value) {
        double conv;
        int j;
        int in = toAmps ? 1 : 0;
        int out = 1 - in;
        double[][] convTable = convAmpsToVFract;
        for (j = 0; j < convTable.length && !(convTable[j][in] >= value); ++j) {
        }
        if (j == 0) {
            conv = convTable[j][out];
        } else if (j >= convTable.length) {
            conv = convTable[j - 1][out];
        } else {
            double[] cPrev = convTable[j - 1];
            double[] cCurr = convTable[j];
            conv = cPrev[out] + (cCurr[out] - cPrev[out]) / (cCurr[in] - cPrev[in]) * (value - cPrev[in]);
        }
        return conv;
    }
}

