/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.IOException;
import java.util.Properties;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.transport.JIComEndpoint;
import org.jinterop.dcom.transport.JIComTransportFactory;
import rpc.FaultException;
import rpc.Stub;
import rpc.core.UUID;

final class JIRemUnknownServer
extends Stub {
    private static Properties defaults = new Properties();
    private JISession session = null;
    private String syntax = null;
    private String remunknownIPID = null;
    private final Object mutex = new Object();
    private boolean timeoutModifiedfrom0 = false;

    JIRemUnknownServer(JISession session, String remUnknownIpid, String address) throws JIException {
        this.session = session;
        super.setTransportFactory(JIComTransportFactory.getSingleTon());
        super.setProperties(new Properties(defaults));
        super.getProperties().setProperty("rpc.socketTimeout", new Integer(session.getGlobalSocketTimeout()).toString());
        if (session.isNTLMv2Enabled()) {
            super.getProperties().setProperty("rpc.ntlm.ntlmv2", "true");
        }
        if (session.isSSOEnabled()) {
            super.getProperties().setProperty("rpc.ntlm.sso", "true");
        } else {
            super.getProperties().setProperty("rpc.security.username", session.getUserName());
            super.getProperties().setProperty("rpc.security.password", session.getPassword());
            super.getProperties().setProperty("rpc.ntlm.domain", session.getDomain());
        }
        if (session.isSessionSecurityEnabled()) {
            super.getProperties().setProperty("rpc.ntlm.seal", "true");
            super.getProperties().setProperty("rpc.ntlm.sign", "true");
            super.getProperties().setProperty("rpc.ntlm.keyExchange", "true");
            super.getProperties().setProperty("rpc.ntlm.keyLength", "128");
            super.getProperties().setProperty("rpc.ntlm.ntlm2", "true");
        }
        this.syntax = "00000143-0000-0000-c000-000000000046:0.0";
        this.setAddress(address);
        this.remunknownIPID = remUnknownIpid;
        this.session.setStub2(this);
    }

    @Override
    protected String getSyntax() {
        return this.syntax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] call(JICallBuilder obj, String targetIID, int socketTimeout) throws JIException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.session.isSessionInDestroy() && !obj.fromDestroySession) {
                throw new JIException(4177);
            }
            if (socketTimeout != 0) {
                this.setSocketTimeOut(socketTimeout);
            } else if (this.timeoutModifiedfrom0) {
                this.setSocketTimeOut(socketTimeout);
            }
            try {
                this.attach();
                if (!this.getEndpoint().getSyntax().getUuid().toString().equalsIgnoreCase(targetIID)) {
                    this.getEndpoint().getSyntax().setUuid(new UUID(targetIID));
                    this.getEndpoint().getSyntax().setVersion(0, 0);
                    ((JIComEndpoint)this.getEndpoint()).rebindEndPoint();
                }
                this.setObject(obj.getParentIpid());
                this.call(2, obj);
            }
            catch (FaultException e) {
                throw new JIException(e.status, (Throwable)e);
            }
            catch (IOException e) {
                throw new JIException(-2147352577, (Throwable)e);
            }
            catch (JIRuntimeException e1) {
                throw new JIException(e1);
            }
            return obj.getResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRef_ReleaseRef(JICallBuilder obj) throws JIException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.remunknownIPID == null) {
                return;
            }
            obj.setParentIpid(this.remunknownIPID);
            obj.attachSession(this.session);
            try {
                this.call(obj, "00000143-0000-0000-c000-000000000046", this.session.getGlobalSocketTimeout());
            }
            catch (JIRuntimeException e1) {
                throw new JIException(e1);
            }
        }
    }

    void closeStub() {
        try {
            this.detach();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void setSocketTimeOut(int timeout) {
        this.timeoutModifiedfrom0 = timeout != 0;
        this.getProperties().setProperty("rpc.socketTimeout", new Integer(timeout).toString());
    }

    static {
        defaults.put("rpc.ntlm.lanManagerKey", "false");
        defaults.put("rpc.ntlm.sign", "false");
        defaults.put("rpc.ntlm.seal", "false");
        defaults.put("rpc.ntlm.keyExchange", "false");
        defaults.put("rpc.connectionContext", "rpc.security.ntlm.NtlmConnectionContext");
        defaults.put("rpc.socketTimeout", new Integer(0).toString());
    }
}

