/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.freehep.application.studio.pluginmanager.PluginManager;

class PluginPreferences
extends JPanel {
    private PluginManager manager;
    private JCheckBox checkAtStart;
    private JLabel jLabel1;
    private JButton restoreDefaultButton;
    private JTextField url;

    public PluginPreferences(PluginManager manager) {
        this.manager = manager;
        this.initComponents();
    }

    boolean apply() {
        try {
            this.manager.setCheckURL(new URL(this.url.getText()));
            this.manager.setCheckAtStart(this.checkAtStart.isSelected());
            return true;
        }
        catch (MalformedURLException x) {
            JOptionPane.showMessageDialog(this, x.getMessage(), "Error...", 0);
            this.url.requestFocus();
            return false;
        }
    }

    private void initComponents() {
        this.checkAtStart = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.url = new JTextField();
        this.restoreDefaultButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.checkAtStart.setSelected(this.manager.isCheckAtStart());
        this.checkAtStart.setText("Check for updated plugins at startup");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.checkAtStart, gridBagConstraints);
        this.jLabel1.setText("URL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.url.setColumns(30);
        this.url.setText(this.manager.getCheckURL().toExternalForm());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.url, gridBagConstraints);
        this.restoreDefaultButton.setText("Restore Defaults");
        this.restoreDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginPreferences.this.restoreDefaultButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.restoreDefaultButton, gridBagConstraints);
    }

    private void restoreDefaultButtonActionPerformed(ActionEvent evt) {
        this.checkAtStart.setSelected(true);
        this.url.setText(this.manager.getApplication().getAppProperties().getProperty("PluginManager.URL"));
    }
}

