/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.subsystem.common.devices.pluto.PlutoDevice;

public class MpmPlutoDevice
extends PlutoDevice {
    public static final int SW_BLOCK_COLD_REFG = 0;
    public static final int SW_BLOCK_CRYO_REFG = 1;
    public static final int NUM_SWITCHES = 2;
    private static final int NUM_AREAS = 30;
    private static final int SWDI_ON_BIT = 0;
    private static final int SWDI_OFF_BIT = 1;
    private static final int SWDI_READ_AREA = 2;
    private static final int SWDI_READ_BIT = 3;
    private static final int[][] switches = new int[2][];

    public MpmPlutoDevice() {
        super(30);
    }

    public void setSwitch(int sw, boolean on) {
        if (this.isOnline()) {
            int bitNum = switches[sw][on ? 0 : 1];
            this.toggleBit(bitNum / 16, bitNum & 0xF);
        }
    }

    public Boolean isSwitchOn(int sw) {
        int[] swData = switches[sw];
        Integer value = this.readAddBit(swData[2], swData[3] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    static {
        MpmPlutoDevice.switches[0] = new int[]{20, 21, 17, 6};
        MpmPlutoDevice.switches[1] = new int[]{36, 37, 27, 6};
    }
}

