/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.PduCommon;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.power.SwitchControl;

public class PduCommonDevice
extends Device
implements SwitchControl {
    protected static final Logger LOG = Logger.getLogger(PduCommonDevice.class.getName());
    protected static final int MON_TYPE_VOLTAGE = 0;
    protected static final int MON_TYPE_CURRENT = 1;
    private static final String NODE = "node";
    private static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(name="node", category="Quadbox", isFinal=true)
    protected volatile Integer node;
    private final PduCommon pdu;
    private final String pduType;
    private final int switchDevice;
    private int validChans;
    private boolean initError = false;

    public PduCommonDevice(PduCommon pdu, String pduType, int swDevc) {
        this.pdu = pdu;
        this.pduType = pduType;
        this.switchDevice = swDevc;
    }

    protected void initDevice() {
        if (this.node == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)NODE, (String)"is missing");
        }
        this.fullName = this.pduType + " PDU (" + this.node + ")";
        this.validChans = this.pdu.getValidChannels();
    }

    protected void initialize() {
        block2: {
            try {
                this.pdu.open(this.node.intValue());
                this.setOnline(true);
                this.initSensors();
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
        try {
            this.pdu.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}:{1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        if (!(mType != 0 && mType != 1 || hwChan >= 0 && (1 << hwChan & this.validChans) != 0)) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hwChan", (Object)hwChan);
        }
        return new int[]{mType, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        String item = null;
        if (this.isOnline()) {
            try {
                switch (type) {
                    case 0: {
                        item = "voltage";
                        value = this.pdu.readVoltage(hwChan);
                        break;
                    }
                    case 1: {
                        item = "current";
                        value = this.pdu.readCurrent(hwChan);
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.fullName, item, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    @Override
    public int getSwitchDevice() {
        return this.switchDevice;
    }

    @Override
    public void switchOn(int chan) {
        if (chan < 0) {
            try {
                this.pdu.setMainOn();
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error setting main power on {0}: {1}", new Object[]{this.fullName, e});
            }
        } else {
            try {
                this.pdu.powerOn(chan);
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error setting channel {0} on {1}: {2}", new Object[]{chan, this.fullName, e});
            }
        }
    }

    @Override
    public void switchOff(int chan) {
        if (chan < 0) {
            try {
                this.pdu.setMainOff();
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error setting main power on {0}: {1}", new Object[]{this.fullName, e});
            }
        } else {
            try {
                this.pdu.powerOff(chan);
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error setting channel {0} on {1}: {2}", new Object[]{chan, this.fullName, e});
            }
        }
    }

    @Override
    public Boolean isSwitchOn(int chan) {
        if (!this.isOnline()) {
            return null;
        }
        if (chan < 0) {
            try {
                return this.pdu.isMainOn();
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error getting state for main power on {0}: {1}", new Object[]{this.fullName, e});
                return null;
            }
        }
        if ((this.validChans & 1 << chan) == 0) {
            return null;
        }
        try {
            return this.pdu.isPowered(chan);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting state for channel {0} on {1}: {2}", new Object[]{chan, this.fullName, e});
            return null;
        }
    }

    static {
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
    }
}

