/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.eaton.EpduG3;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class EpduG3Device
extends Device {
    private static final int CHAN_TYPE_VOLTAGE = 0;
    private static final int CHAN_TYPE_CURRENT = 1;
    private static final int CHAN_TYPE_POWER = 2;
    private static final int CHAN_TYPE_TEMP = 3;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(category="EatonPDU", isFinal=true)
    private volatile String host;
    @ConfigurationParameter(category="EatonPDU", isFinal=true)
    private volatile String userName = "";
    @ConfigurationParameter(category="EatonPDU", isFinal=true)
    private volatile String password = "";
    private static final Logger LOG;
    private final EpduG3 pdu = new EpduG3();
    private boolean initError = false;

    protected void initDevice() {
        this.fullName = "Eaton G3 PDU (" + this.host + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.pdu.open(Session.ConnType.TELNET, this.host, this.userName, this.password);
                this.initSensors();
                this.setOnline(true);
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
            }
            catch (Exception e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
        try {
            this.pdu.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}:{1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"Type", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        try {
            if (!(type != 1 && type != 2 || hwChan >= 0 && hwChan <= this.pdu.getOutletCount())) {
                ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hardware channel", (Object)hwChan);
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting PDU outlet count: {0}", e);
        }
        catch (Exception e) {
            this.dropChannel(id);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.isOnline()) {
            try {
                switch (type) {
                    case 1: {
                        value = hwChan == 0 ? this.pdu.readPhaseCurrent(1) : this.pdu.readOutletCurrent(hwChan);
                        break;
                    }
                    case 2: {
                        value = hwChan == 0 ? this.pdu.readPhasePower(1) : this.pdu.readOutletPower(hwChan);
                        break;
                    }
                    case 0: {
                        value = this.pdu.readPhaseVoltage(1);
                        break;
                    }
                    case 3: {
                        value = this.pdu.readTemperature();
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading PDU data: {0}", e);
                this.setOnline(false);
            }
        }
        return value;
    }

    static {
        typeMap.put("VOLTAGE", 0);
        typeMap.put("CURRENT", 1);
        typeMap.put("POWER", 2);
        typeMap.put("TEMP", 3);
        LOG = Logger.getLogger(EpduG3Device.class.getName());
    }
}

