/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.glassfish.jersey.inject.spi.BinderConfigurationFactory;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.CompositeBinder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.ComponentBag;

public class JerseyBinderConfigurationFactory
implements BinderConfigurationFactory {
    @Override
    public BinderConfigurationFactory.BinderConfiguration createBinderConfiguration(Function<Predicate<ContractProvider>, Set<Object>> getInstances) {
        return new JerseyBinderConfiguration(getInstances);
    }

    private static class JerseyBinderConfiguration
    implements BinderConfigurationFactory.BinderConfiguration {
        private Set<Binder> configuredBinders = Collections.emptySet();
        private final Function<Predicate<ContractProvider>, Set<Object>> getInstances;
        private static final Function<Object, Binder> CAST_TO_BINDER = Binder.class::cast;

        private JerseyBinderConfiguration(Function<Predicate<ContractProvider>, Set<Object>> getInstances) {
            this.getInstances = getInstances;
        }

        @Override
        public boolean configureBinders(InjectionManager injectionManager) {
            this.configuredBinders = this.configureBinders(injectionManager, this.configuredBinders);
            return !this.configuredBinders.isEmpty();
        }

        private Set<Binder> configureBinders(InjectionManager injectionManager, Set<Binder> configured) {
            Set<Binder> allConfigured = Collections.newSetFromMap(new IdentityHashMap());
            allConfigured.addAll(configured);
            Collection<Binder> binders = this.getBinder(configured);
            if (!binders.isEmpty()) {
                injectionManager.register(CompositeBinder.wrap(binders));
                allConfigured.addAll(binders);
            }
            return allConfigured;
        }

        private Collection<Binder> getBinder(Set<Binder> configured) {
            return this.getInstances.apply(ComponentBag.BINDERS_ONLY).stream().map(CAST_TO_BINDER).filter(binder -> !configured.contains(binder)).collect(Collectors.toList());
        }
    }
}

