/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.devices.turbopump.TwisTorr84Device;
import org.lsst.ccs.subsystem.teststand.TS7;
import org.lsst.ccs.subsystem.teststand.alerts.TS7Alerts;
import org.lsst.ccs.subsystem.teststand.data.TS7Outlets;
import org.lsst.ccs.utilities.logging.Logger;

public class TS7AlertHandler
implements HasLifecycle,
Monitor.AlarmHandler,
ClearAlertHandler {
    private static final Logger LOG = Logger.getLogger((String)"org.lsst.ccs.subsystem.ts7.alarms");
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private TS7 ts7;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private TwisTorr84Device turbo;

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        if (parm == TS7Alerts.PRESSURE_TOO_HIGH.ordinal()) {
            this.alertService.raiseAlert(TS7Alerts.PRESSURE_TOO_HIGH.getAlert(), TS7AlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause);
            switch (event) {
                case 0: {
                    try {
                        this.ts7.turnOutletOff(TS7Outlets.VACUUMVALVE);
                        LOG.info((Object)("Shutting (Turning off) vacuum valve " + TS7Outlets.VACUUMVALVE.getOutletName()));
                    }
                    catch (DriverException de) {
                        LOG.severe((Object)("Failed to turn off VACUUMVALVE outlet -- manual intervention needed" + (Object)((Object)de)));
                    }
                    Thread t = new Thread(new VacuumAlarmResponse());
                    t.start();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            return true;
        }
        if (parm == TS7Alerts.PRESSURE_TOO_LOW.ordinal()) {
            this.alertService.raiseAlert(TS7Alerts.PRESSURE_TOO_LOW.getAlert(), TS7AlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause);
            switch (event) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            return true;
        }
        if (parm == TS7Alerts.COLD_PLATE_TEMPERATURE_TOO_LOW.ordinal()) {
            this.alertService.raiseAlert(TS7Alerts.COLD_PLATE_TEMPERATURE_TOO_LOW.getAlert(), TS7AlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause);
            switch (event) {
                case 0: {
                    LOG.info((Object)"COLD_PLATE_TEMPERATURE_TOO_LOW: Turn off Polycold chillers...");
                    Thread t = new Thread(new ColdPlateAlarmLowResponse());
                    t.start();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            return true;
        }
        if (parm == TS7Alerts.CRYO_PLATE_TEMPERATURE_TOO_LOW.ordinal()) {
            this.alertService.raiseAlert(TS7Alerts.CRYO_PLATE_TEMPERATURE_TOO_LOW.getAlert(), TS7AlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause);
            switch (event) {
                case 0: {
                    LOG.info((Object)"CRYO_PLATE_TEMPERATURE_TOO_LOW: Turn off Polycold chiller...");
                    Thread t = new Thread(new CryoPlateAlarmLowResponse());
                    t.start();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            return true;
        }
        if (parm == TS7Alerts.COLD_PLATE_TEMPERATURE_TOO_HIGH.ordinal()) {
            this.alertService.raiseAlert(TS7Alerts.COLD_PLATE_TEMPERATURE_TOO_HIGH.getAlert(), TS7AlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause);
            switch (event) {
                case 0: {
                    LOG.info((Object)"COLD_PLATE_TEMPERATURE_TOO_HIGH: Turning off heat sources");
                    if (this.ts7.isAlertResponseEnabled()) {
                        try {
                            LOG.info((Object)("Turning off REB 48V power supply outlet: " + TS7Outlets.REB48VOLTPOWERSUPPLY.getOutletName()));
                            this.ts7.turnOutletOff(TS7Outlets.REB48VOLTPOWERSUPPLY);
                        }
                        catch (DriverException e) {
                            LOG.error((Object)("Error powering off REB power supply: " + (Object)((Object)e)));
                        }
                    } else {
                        LOG.info((Object)"Powering off REB power supply was disabled");
                    }
                    LOG.info((Object)"COLD_PLATE_TEMPERATURE_TOO_HIGH: Alert response initiated");
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            return true;
        }
        if (parm == TS7Alerts.CRYO_PLATE_TEMPERATURE_TOO_HIGH.ordinal()) {
            this.alertService.raiseAlert(TS7Alerts.CRYO_PLATE_TEMPERATURE_TOO_HIGH.getAlert(), TS7AlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause);
            switch (event) {
                case 0: {
                    LOG.info((Object)"CRYO_PLATE_TEMPERATURE_TOO_HIGH: Turning off heat sources");
                    if (this.ts7.isAlertResponseEnabled()) {
                        try {
                            LOG.info((Object)("Turning off REB 48V power supply outlet: " + TS7Outlets.REB48VOLTPOWERSUPPLY.getOutletName()));
                            this.ts7.turnOutletOff(TS7Outlets.REB48VOLTPOWERSUPPLY);
                        }
                        catch (DriverException e) {
                            LOG.error((Object)("Error powering off REB power supply: " + (Object)((Object)e)));
                        }
                    } else {
                        LOG.info((Object)"Powering off REB power supply was disabled");
                    }
                    LOG.info((Object)"CRYO_PLATE_TEMPERATURE_TOO_HIGH: Turn off REB PS if powerState is not OFF, verify Cryo OTP is enabled");
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            return true;
        }
        if (parm == TS7Alerts.TURBO_PUMP_FAIL.ordinal()) {
            String extraInfo = "";
            if (event == 0) {
                try {
                    extraInfo = "\n " + this.turbo.readTurboFailCode();
                }
                catch (DriverException e) {
                    extraInfo = "\n Exception reading Turbo error code: " + (Object)((Object)e);
                }
            }
            this.alertService.raiseAlert(TS7Alerts.TURBO_PUMP_FAIL.getAlert(), TS7AlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause + extraInfo);
            return true;
        }
        if (parm == TS7Alerts.TURBO_PUMP_SLOW.ordinal()) {
            String extraInfo = "";
            try {
                extraInfo = "\n New Turbo status = " + this.turbo.readTurboStatus();
            }
            catch (DriverException e) {
                extraInfo = "\n Exception reading Turbo status: " + (Object)((Object)e);
            }
            this.alertService.raiseAlert(TS7Alerts.TURBO_PUMP_SLOW.getAlert(), TS7AlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause + extraInfo);
            return true;
        }
        return false;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        for (TS7Alerts ts7Alert : TS7Alerts.values()) {
            Alarm a;
            if (!ts7Alert.getAlertId().equals(alert.getAlertId()) || (a = this.getAlarmById(ts7Alert.ordinal())) == null) continue;
            a.clearState();
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    private static AlertState getAlarmStateFromEvent(int event) {
        switch (event) {
            case 0: {
                return AlertState.ALARM;
            }
            case 1: {
                return AlertState.WARNING;
            }
            case 2: {
                return AlertState.WARNING;
            }
            case 3: {
                return AlertState.NOMINAL;
            }
        }
        throw new IllegalArgumentException("Unknown event: id " + event);
    }

    private static void sleep(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Could not sleep", ie);
        }
    }

    class CryoPlateAlarmLowResponse
    implements Runnable {
        CryoPlateAlarmLowResponse() {
        }

        @Override
        public void run() {
            try {
                LOG.info((Object)("Turning off cryo plate refrigerator " + TS7Outlets.CRYOPLATEREFRIGERATOR.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.CRYOPLATEREFRIGERATOR);
                } else {
                    LOG.info((Object)"The action of turning off the cryo plate refrigerator was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)("Failed to turn off CryoPlateRefrigerator outlet -- manual intervention needed" + (Object)((Object)e)));
            }
            TS7AlertHandler.sleep(2000L);
        }
    }

    class ColdPlateAlarmLowResponse
    implements Runnable {
        ColdPlateAlarmLowResponse() {
        }

        @Override
        public void run() {
            try {
                LOG.info((Object)("Turning off cold plate refrigerator 1 " + TS7Outlets.COLDPLATEREFRIGERATOR_1.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.COLDPLATEREFRIGERATOR_1);
                } else {
                    LOG.info((Object)"The action of turning off the cold plate refrigerator 1 was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)"Failed to turn off ColdPlateRefrigerator_1 outlet -- manual intervention needed");
            }
            TS7AlertHandler.sleep(2000L);
            try {
                LOG.info((Object)("Turning off cold plate refrigerator 2 " + TS7Outlets.COLDPLATEREFRIGERATOR_2.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.COLDPLATEREFRIGERATOR_2);
                } else {
                    LOG.info((Object)"The action of turning off the cold plate refrigerator 2 was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)"Failed to turn off ColdPlateRefrigerator_2 outlet -- manual intervention needed");
            }
            TS7AlertHandler.sleep(2000L);
            try {
                LOG.info((Object)("Turning off cryo plate refrigerator " + TS7Outlets.CRYOPLATEREFRIGERATOR.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.CRYOPLATEREFRIGERATOR);
                } else {
                    LOG.info((Object)"The action of turning off the cryo plate refrigerator was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)"Failed to turn off CryoPlateRefrigerator outlet -- manual intervention needed");
            }
            TS7AlertHandler.sleep(2000L);
            try {
                LOG.info((Object)("Turning off reb power supply " + TS7Outlets.REB48VOLTPOWERSUPPLY.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.REB48VOLTPOWERSUPPLY);
                } else {
                    LOG.info((Object)"The action of turning off the reb power supply was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)"Failed to turn off REB 48V supply outlet -- manual intervention needed");
            }
        }
    }

    class VacuumAlarmResponse
    implements Runnable {
        VacuumAlarmResponse() {
        }

        @Override
        public void run() {
            try {
                LOG.info((Object)("Turning off cold plate refrigerator 1 " + TS7Outlets.COLDPLATEREFRIGERATOR_1.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.COLDPLATEREFRIGERATOR_1);
                } else {
                    LOG.info((Object)"The action of turning off the cold plate refrigerator 1 was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)"Failed to turn off ColdPlateRefrigerator_1 outlet -- manual intervention needed");
            }
            TS7AlertHandler.sleep(2000L);
            try {
                LOG.info((Object)("Turning off cold plate refrigerator 2 " + TS7Outlets.COLDPLATEREFRIGERATOR_2.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.COLDPLATEREFRIGERATOR_2);
                } else {
                    LOG.info((Object)"The action of turning off the cold plate refrigerator 2 was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)"Failed to turn off ColdPlateRefrigerator_2 outlet -- manual intervention needed");
            }
            TS7AlertHandler.sleep(2000L);
            try {
                LOG.info((Object)("Turning off cryo plate refrigerator " + TS7Outlets.CRYOPLATEREFRIGERATOR.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.CRYOPLATEREFRIGERATOR);
                } else {
                    LOG.info((Object)"The action of turning off the cryo plate refrigerator was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)"Failed to turn off CryoPlateRefrigerator outlet -- manual intervention needed");
            }
            TS7AlertHandler.sleep(2000L);
            try {
                LOG.info((Object)("Turning off turbo pump " + TS7Outlets.TURBOPUMP.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.TURBOPUMP);
                } else {
                    LOG.info((Object)"The action of turning off the turbo pump was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)"Failed to turn off Turbo Pump outlet -- manual intervention needed");
            }
            TS7AlertHandler.sleep(2000L);
            try {
                LOG.info((Object)("Turning off roughing pump " + TS7Outlets.ROUGHINGPUMP.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.ROUGHINGPUMP);
                } else {
                    LOG.info((Object)"The action of turning off the roughing pump was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)"Failed to turn off Roughing Pump outlet -- manual intervention needed");
            }
            try {
                LOG.info((Object)("Turning off reb power supply " + TS7Outlets.REB48VOLTPOWERSUPPLY.getOutletName()));
                if (TS7AlertHandler.this.ts7.isAlertResponseEnabled()) {
                    TS7AlertHandler.this.ts7.turnOutletOff(TS7Outlets.REB48VOLTPOWERSUPPLY);
                } else {
                    LOG.info((Object)"The action of turning off the reb power supply was disabled");
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)"Failed to turn off REB 48V supply outlet -- manual intervention needed");
            }
        }
    }
}

