/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.netbotz.NetbotzDriver;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.EnviroDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class NetBotzDevice
extends Device
implements EnviroDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private NetbotzDriver apcnb = new NetbotzDriver();
    private String envirofile = null;

    public NetBotzDevice(String ef) {
        this.open(ef);
    }

    @Override
    @Command(name="open", description="Open connection for NetBotz readings retrieval")
    public void open(@Argument(name="envirofile", description="environment file") String ef) {
        this.envirofile = ef;
        System.out.println("Calling netbotz driver to open connection to file - " + this.envirofile);
        try {
            this.apcnb.open(this.envirofile);
        }
        catch (DriverException ex) {
            System.out.println("Failed to open environment datafile!" + (Object)((Object)ex));
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getHumidity", description="read humidity reading from the NetBotz environment log")
    public Double getHumidity() {
        return this.apcnb.getHumidity();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getTemperature", description="read temperature reading from the NetBotz environment log")
    public Double getTemperature() {
        Double temp = this.apcnb.getTemperature();
        this.log.debug((Object)("getTemp returns - " + temp));
        return temp;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getDew", description="read dew point reading from the NetBotz environment log")
    public Double getDew() {
        return this.apcnb.getDew();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getpc", description="read particle count reading from the NetBotz environment log")
    public Double getPartCnt() {
        return this.apcnb.getPartCnt();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getEnviro", description="read line of readings from the NetBotz environment log")
    public void getEnviro() {
        try {
            this.apcnb.GetEnviro();
        }
        catch (IOException e) {
            System.out.println("Failed to retrieve environment readings " + e);
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getEnviro", description="read line of readings from the NetBotz environment log and return set arg values")
    public void getEnviro(@Argument(name="humidity", description="environment file") Double Humidity, @Argument(name="temperature", description="") Double Temperature, @Argument(name="dewpoint", description="") Double Dew, @Argument(name="particlecount", description="") Double PartCnt) {
        try {
            this.apcnb.GetEnviro(Humidity, Temperature, Dew, PartCnt);
        }
        catch (IOException e) {
            System.out.println("Failed to retrieve environment readings " + e);
        }
    }

    protected void close() {
        this.apcnb.close();
    }

    protected void initialize() {
        this.setOnline(true);
        this.log.debug((Object)"NetBotz device initialized.");
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        try {
            this.apcnb.GetEnviro();
            switch (chan) {
                case 0: {
                    value = this.apcnb.getHumidity();
                    break;
                }
                case 1: {
                    value = this.apcnb.getTemperature();
                    break;
                }
                case 2: {
                    value = this.apcnb.getDew();
                    break;
                }
                case 3: {
                    value = this.apcnb.getPartCnt();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading channel chan " + chan + " type " + type + ": " + e));
        }
        return value;
    }

    static {
        typeMap.put("TEMP", 0);
        typeMap.put("HUMIDITY", 1);
        typeMap.put("DEW", 2);
        typeMap.put("PARTCNT", -1);
        typeMap.put("UNKNOWN", -1);
    }
}

