/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.util.stream.Stream;
import org.lsst.ccs.drivers.lighthouse.ChannelType;
import org.lsst.ccs.drivers.lighthouse.ChannelUnits;

public enum DataChannel {
    COUNTER_0_3(0, "0.3", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    COUNTER_0_5(1, "0.5", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    COUNTER_1_0(2, "1.0", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    COUNTER_2_5(3, "2.5", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    COUNTER_5_0(4, "5.0", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    COUNTER_10_0(5, "10.0", false, ChannelType.COUNTER, ChannelUnits.COUNTS),
    TEMP(16, "temp", true, ChannelType.TEMPERATURE, ChannelUnits.FAHRENHEIT),
    HUMID(17, "humid", true, ChannelType.RELATIVE_HUMIDITY, ChannelUnits.PERCENTAGE);

    private final int index;
    private final String name;
    private final boolean analog;
    private final ChannelType type;
    private final ChannelUnits units;
    public static final int NUM_PARTICLE_CHANNELS;
    public static final int NUM_ANALOG_CHANNELS;
    public static final DataChannel FIRST_ANALOG_CHANNEL;

    private DataChannel(int index, String name, boolean analog, ChannelType type, ChannelUnits units) {
        this.index = index;
        this.name = name;
        this.analog = analog;
        this.type = type;
        this.units = units;
    }

    public static DataChannel parse(String name) {
        return Stream.of(DataChannel.values()).filter(chan -> chan.getName().equalsIgnoreCase(name)).findFirst().orElseGet(() -> DataChannel.valueOf(name));
    }

    public int getIndex() {
        return this.index;
    }

    public ChannelType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnalog() {
        return this.analog;
    }

    ChannelUnits getUnits() {
        return this.units;
    }

    static {
        NUM_PARTICLE_CHANNELS = (int)Stream.of(DataChannel.values()).filter(chan -> !chan.isAnalog()).count();
        NUM_ANALOG_CHANNELS = (int)Stream.of(DataChannel.values()).filter(chan -> chan.isAnalog()).count();
        FIRST_ANALOG_CHANNEL = Stream.of(DataChannel.values()).filter(chan -> chan.isAnalog()).findFirst().get();
    }
}

