/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.xmlrpc.ClientXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;

class CallableClientServer {
    private final URL url_;
    private SampXmlRpcServer server_;
    private ClientXmlRpcHandler clientHandler_;
    private static final Map serverMap_ = new HashMap();
    static /* synthetic */ Class class$org$astrogrid$samp$xmlrpc$CallableClientServer;

    public CallableClientServer(SampXmlRpcServer server) throws IOException {
        this.server_ = server;
        this.clientHandler_ = new ClientXmlRpcHandler();
        this.server_.addHandler(this.clientHandler_);
        this.url_ = this.server_.getEndpoint();
    }

    public URL getUrl() {
        return this.url_;
    }

    public void addClient(HubConnection connection, CallableClient callable) {
        if (this.clientHandler_ == null) {
            throw new IllegalStateException("Closed");
        }
        this.clientHandler_.addClient(connection, callable);
    }

    public void removeClient(HubConnection connection) {
        if (this.clientHandler_ != null) {
            this.clientHandler_.removeClient(connection);
        }
    }

    public void close() {
        if (this.server_ != null) {
            this.server_.removeHandler(this.clientHandler_);
        }
        this.server_ = null;
        this.clientHandler_ = null;
    }

    boolean hasClients() {
        return this.clientHandler_ != null && this.clientHandler_.getClientCount() > 0;
    }

    public static synchronized CallableClientServer getInstance(SampXmlRpcServerFactory serverFact) throws IOException {
        final SampXmlRpcServer server = serverFact.getServer();
        if (!serverMap_.containsKey(server)) {
            CallableClientServer clientServer = new CallableClientServer(server){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void removeClient(HubConnection connection) {
                    super.removeClient(connection);
                    if (!this.hasClients()) {
                        this.close();
                        Class clazz = class$org$astrogrid$samp$xmlrpc$CallableClientServer == null ? (class$org$astrogrid$samp$xmlrpc$CallableClientServer = CallableClientServer.class$("org.astrogrid.samp.xmlrpc.CallableClientServer")) : class$org$astrogrid$samp$xmlrpc$CallableClientServer;
                        synchronized (clazz) {
                            serverMap_.remove(server);
                        }
                    }
                }
            };
            serverMap_.put(server, clientServer);
        }
        return (CallableClientServer)serverMap_.get(server);
    }
}

