/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.ocsbridge.states.FcsPowerState;
import org.lsst.ccs.subsystem.ocsbridge.states.FilterState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.utilities.structs.Pair;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.FilterChangerPowerStatusEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;

public class OCSStateChangeToEventConverter {
    private final Map<Pair<Class<? extends Enum>, Class<? extends Enum>>, Class<? extends CameraEvent>> oldStateNewStateMap = new HashMap<Pair<Class<? extends Enum>, Class<? extends Enum>>, Class<? extends CameraEvent>>();

    public OCSStateChangeToEventConverter() {
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)ShutterState.CLOSED, (Object)ShutterState.OPENING), StartShutterOpenEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)ShutterState.OPENING, (Object)ShutterState.OPEN), EndShutterOpenEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)ShutterState.CLOSED, (Object)ShutterState.OPEN), EndShutterOpenEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)ShutterState.OPEN, (Object)ShutterState.CLOSING), StartShutterCloseEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)ShutterState.OPEN, (Object)ShutterState.CLOSED), EndShutterCloseEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)ShutterState.CLOSING, (Object)ShutterState.CLOSED), EndShutterCloseEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)FilterState.UNLOADED, (Object)FilterState.ROTATING), StartRotateCarouselEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)FilterState.ROTATING, (Object)FilterState.UNLOADED), EndRotateCarouselEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)FilterState.UNLOADED, (Object)FilterState.LOADING), StartLoadFilterEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)FilterState.LOADING, (Object)FilterState.LOADED), EndLoadFilterEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)FilterState.LOADED, (Object)FilterState.UNLOADING), StartUnloadFilterEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)FilterState.UNLOADING, (Object)FilterState.UNLOADED), EndUnloadFilterEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)FilterState.LOADED, (Object)FilterState.LOADING), StartLoadFilterEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)FcsPowerState.LOW_POWER, (Object)FcsPowerState.REGULAR), FilterChangerPowerStatusEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)FcsPowerState.REGULAR, (Object)FcsPowerState.LOW_POWER), FilterChangerPowerStatusEvent.class);
    }

    public CameraEvent convert(CCSTimeStamp when, Enum oldState, Enum newState) {
        if (oldState == null || newState == null) {
            return null;
        }
        Pair statePair = new Pair((Object)oldState, (Object)newState);
        Class<? extends CameraEvent> newStateClass = this.oldStateNewStateMap.get(statePair);
        if (newStateClass == null) {
            return null;
        }
        if (newStateClass == FilterChangerPowerStatusEvent.class) {
            return new FilterChangerPowerStatusEvent(when.getTAIDouble(), newState == FcsPowerState.LOW_POWER ? FilterChangerPowerStatusEvent.PowerState.LOW_POWER : FilterChangerPowerStatusEvent.PowerState.REGULAR);
        }
        try {
            Constructor<? extends CameraEvent> bbc = this.oldStateNewStateMap.get(statePair).getConstructor(Double.TYPE);
            return bbc.newInstance(when.getTAIDouble());
        }
        catch (ReflectiveOperationException x) {
            throw new RuntimeException("Error converting state change : " + statePair, x);
        }
    }
}

