/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.ts8;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.parker.AcrComm;
import org.lsst.ccs.drivers.parker.AxisBit;
import org.lsst.ccs.drivers.parker.AxisName;
import org.lsst.ccs.drivers.parker.ControllerType;
import org.lsst.ccs.drivers.parker.ProgramBit;
import org.lsst.ccs.drivers.parker.ProgramName;
import org.lsst.ccs.drivers.parker.SystemBit;
import org.lsst.ccs.drivers.parker.UserParameter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.main.CheckException;
import org.lsst.ccs.subsystem.motorplatform.ts8.Axis;
import org.lsst.ccs.utilities.logging.Logger;

public class ACR9000
implements MotorCommandListener,
HasLifecycle {
    private static final Logger LOG = Logger.getLogger((String)ACR9000.class.getPackage().getName());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<Axis> axisComponents = Collections.synchronizedList(new ArrayList());
    private final int NUM_ACR_INSTANCES = 2;
    @ConfigurationParameter(description="The name assigned to the configuration used.")
    private volatile String configurationName = "<safe default>";
    @ConfigurationParameter(description="How often to check for the completion of a long-running operation such as a move.")
    private volatile Duration completionCheckInterval = Duration.ofMillis(500L);
    @ConfigurationParameter(description="The timeout to use for simple actions that don't cause motion.")
    private volatile Duration briefActionTimeout = Duration.ofMillis(50L);
    @ConfigurationParameter(description="How long a query should wait for an AcrComm instance before failing.")
    private volatile Duration queryTimeout = Duration.ofMillis(1000L);
    @ConfigurationParameter(description="The IPv4 address or the hostname of the ACR controller.")
    private volatile String IPv4Address = "192.168.10.40";
    @ConfigurationParameter(description="The interval in seconds between periodic status updates.")
    private volatile Duration statusUpdateInterval = Duration.ofMillis(1000L);
    private volatile Map<String, Axis> axisMap;
    private volatile ExecutorService actionExec;
    private volatile ScheduledExecutorService queryExec;
    private volatile BlockingQueue<AcrComm> acrInstances;
    private volatile BlockingQueue<KeyValueData> resultQueue;
    private volatile Instant currentActionDeadline;
    private volatile String commStatus;
    private volatile String actionStatus;

    private ACR9000() {
    }

    public KeyValueData getNextResult() throws InterruptedException {
        return this.resultQueue.take();
    }

    public void start() {
        try {
            this.acrInstances = new ArrayBlockingQueue<AcrComm>(2);
            this.createAcrs(2);
            this.setActionDeadline(this.briefActionTimeout);
            this.resultQueue = new ArrayBlockingQueue<KeyValueData>(1000);
            this.axisMap = new TreeMap<String, Axis>();
            for (Axis a : this.axisComponents) {
                this.axisMap.put(a.getName(), a);
            }
            this.commStatus = "UP";
            this.actionStatus = "OK";
            this.actionExec = Executors.newSingleThreadExecutor();
            this.queryExec = Executors.newSingleThreadScheduledExecutor();
            this.clearAllFaults(new ClearAllFaults());
            this.changeAxisEnable(new ChangeAxisEnable("Z", false));
            long updateMillis = this.statusUpdateInterval.toMillis();
            this.queryExec.scheduleAtFixedRate(this::publishControllerStatus, 0L, updateMillis, TimeUnit.MILLISECONDS);
            this.queryExec.scheduleAtFixedRate(this::publishAllAxisStatus, 0L, updateMillis, TimeUnit.MILLISECONDS);
            this.queryExec.scheduleAtFixedRate(this::restartProcessing, updateMillis, updateMillis, TimeUnit.MILLISECONDS);
        }
        catch (HardwareException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void shutdown() {
        try {
            this.actionExec.shutdownNow();
            this.actionExec.awaitTermination(50L, TimeUnit.MILLISECONDS);
            this.queryExec.shutdownNow();
            this.queryExec.awaitTermination(50L, TimeUnit.MILLISECONDS);
            AcrComm acr = this.acrInstances.poll(1000L, TimeUnit.MILLISECONDS);
            if (acr == null) {
                this.createAcrs(1);
                acr = this.getAcr();
            }
            if (acr != null) {
                this.stopEverything(acr);
            }
        }
        catch (InterruptedException exc) {
            LOG.log(Level.SEVERE, "Hardware shutdown was interrupted!", (Throwable)exc);
            Thread.currentThread().interrupt();
        }
        catch (HardwareException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.commStatus = "DOWN";
            this.actionStatus = "STOPPED";
        }
    }

    public void changeAxisEnable(ChangeAxisEnable cmd) {
        this.runControllerAction(acr -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            if (cmd.isEnabled()) {
                axis.enable((AcrComm)acr);
            } else {
                axis.disable((AcrComm)acr);
            }
            this.sendAxisStatus(new SendAxisStatus(cmd.getAxisName()));
        }, "changeAxisEnable", this.briefActionTimeout);
    }

    public void changeOutputLine(ChangeOutputLine cmd) {
    }

    public void clearAllFaults(ClearAllFaults cmd) {
        this.runControllerAction(acr -> {
            acr.set(UserParameter.USER20, -1.0);
            acr.sendStr(String.format("RUN %s", Axis.errorProgram.reference()));
            this.axisMap.values().stream().forEach(axis -> this.sendAxisStatus(new SendAxisStatus(axis.getName())));
        }, "clearAllFaults", this.briefActionTimeout);
    }

    public void clearAxisFaults(ClearAxisFaults cmd) {
        this.runControllerAction(acr -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            axis.clearFaults((AcrComm)acr);
            this.sendAxisStatus(new SendAxisStatus(cmd.getAxisName()));
        }, "clearAxisFaults", this.briefActionTimeout);
    }

    public void clearCapture(ClearCapture cmd) {
    }

    public void enableAllAxes(EnableAllAxes cmd) {
        this.runControllerAction(acr -> this.axisMap.keySet().stream().filter(axisName -> !axisName.equals("Z")).forEach(name -> {
            this.axisMap.get(name).enable((AcrComm)acr);
            this.sendAxisStatus(new SendAxisStatus(name));
        }), "enableAllAxes", this.briefActionTimeout);
    }

    public void moveAxisRelative(MoveAxisRelative cmd) {
        this.runControllerAction(acr -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            axis.moveRelative((AcrComm)acr, cmd);
            this.sendAxisStatus(new SendAxisStatus(cmd.getAxisName()));
        }, acr -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            ArrayList<String> codes = new ArrayList<String>(2);
            int ccode = axis.getMoveCompletionCode((AcrComm)acr);
            boolean hasFaults = axis.hasFaults((AcrComm)acr);
            if (ccode != 0) {
                codes.add(String.format("CODE %d", ccode));
            }
            if (hasFaults) {
                codes.add("FAULT");
            }
            if (!codes.isEmpty()) {
                throw new CheckException(String.join((CharSequence)",", codes), String.format("Move on %s axis failed.", axis.getName()));
            }
        }, "moveAxisRelative", () -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            return axis.getRelativeMoveTimeout(cmd);
        });
    }

    public void moveAxisAbsolute(MoveAxisAbsolute cmd) {
        this.runControllerAction(acr -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            axis.moveAbsolute((AcrComm)acr, cmd);
            this.sendAxisStatus(new SendAxisStatus(cmd.getAxisName()));
        }, acr -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            ArrayList<String> codes = new ArrayList<String>(2);
            int ccode = axis.getMoveCompletionCode((AcrComm)acr);
            boolean hasFaults = axis.hasFaults((AcrComm)acr);
            if (ccode != 0) {
                codes.add(String.format("CODE %d", ccode));
            }
            if (hasFaults) {
                codes.add("FAULT");
            }
            if (!codes.isEmpty()) {
                throw new CheckException(String.join((CharSequence)",", codes), String.format("Move on %s axis failed.", axis.getName()));
            }
        }, "moveAxisAbsolute", () -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            return axis.getAbsoluteMoveTimeout(cmd);
        });
    }

    public void homeAxis(HomeAxis cmd) {
        Axis ax = this.axisMap.get(cmd.getAxisName());
        Duration timeout = ax == null ? this.briefActionTimeout : ax.getHomingTimeout();
        this.runControllerAction(acr -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            axis.home((AcrComm)acr);
            this.sendAxisStatus(new SendAxisStatus(cmd.getAxisName()));
        }, acr -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            int ccode = axis.getHomingCompletionCode((AcrComm)acr);
            if (ccode != 0) {
                throw new CheckException(String.format("CODE %d", ccode), String.format("Homing on %s axis failed.", axis.getName()));
            }
            axis.setAtHome();
        }, "homeAxis", () -> {
            Axis axis = this.getAxis(cmd.getAxisName());
            return axis.getHomingTimeout();
        });
    }

    public void sendAxisStatus(SendAxisStatus cmd) {
        this.publishAxisStatus(cmd.getAxisName());
    }

    public void sendConfiguration(SendConfiguration cmd) {
        ArrayList<Axis> axisList = new ArrayList<Axis>(this.axisMap.values());
        axisList.sort((x, y) -> Integer.compare(x.getEnumName().index(), y.getEnumName().index()));
        PlatformConfig config = new PlatformConfig(axisList.stream().map(Axis::getName).collect(Collectors.toList()), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.configurationName, axisList.stream().map(Axis::getUnits).collect(Collectors.toList()));
        try {
            this.resultQueue.put(new KeyValueData("PlatformConfig", (Serializable)config));
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "Sending of platform configuration was interrupted.", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
    }

    public void sendControllerStatus(SendControllerStatus cmd) {
        this.publishControllerStatus();
    }

    public void setupCapture(SetupCapture cmd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllMotion(StopAllMotion cmd) {
        AcrComm acr = null;
        String actstat = "FAILED";
        try {
            acr = this.getAcr();
            acr.set(AxisName.AXIS0, AxisBit.KILL_ALL_MOTION, true);
            this.actionExec.shutdownNow();
            this.actionExec = Executors.newSingleThreadExecutor();
            actstat = "OK";
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "A stop-all-motion request was interrupted!", (Throwable)ex);
        }
        finally {
            this.returnAcr(acr);
            this.actionStatus = actstat;
        }
    }

    private void restartProcessing() {
        if (this.actionExec.isShutdown()) {
            this.acrInstances.forEach(acr -> this.shutdownAcr((AcrComm)acr));
            this.acrInstances.clear();
            try {
                this.createAcrs(2);
                this.actionExec = Executors.newSingleThreadExecutor();
                this.commStatus = "UP";
            }
            catch (HardwareException ex) {
                LOG.log(Level.SEVERE, "Unable to contact the motor controller.", (Throwable)ex);
            }
        }
    }

    private void publishControllerStatus() {
        this.runControllerQuery(acr -> {
            boolean motionEnabled = false;
            try {
                motionEnabled = !acr.get(SystemBit.LATCHED_MOTION_DISABLE);
            }
            catch (Exception exc) {
                this.commStatus = "DOWN";
            }
            ControllerStatus status = new ControllerStatus(this.commStatus, motionEnabled, this.actionStatus);
            this.resultQueue.put(new KeyValueData("ControllerStatus", (Serializable)status));
        }, this.queryTimeout);
    }

    private void publishAllAxisStatus() {
        this.axisMap.values().forEach(axis -> this.publishAxisStatus(axis.getName()));
    }

    private void publishAxisStatus(String axisName) {
        this.runControllerQuery(acr -> {
            Axis axis = this.getAxis(axisName);
            AxisStatus status = axis.getStatus((AcrComm)acr);
            this.resultQueue.put(new KeyValueData("AxisStatus/" + status.getAxisName(), (Serializable)status));
        }, this.queryTimeout);
    }

    private void runControllerAction(MyConsumer<AcrComm> action, MyConsumer<AcrComm> postCheck, String actionName, Supplier<Duration> actionTimeout) {
        if (!this.actionExec.isShutdown()) {
            String[] actstat = new String[]{"FAILED"};
            this.actionExec.submit(() -> {
                AcrComm acr = null;
                try {
                    acr = this.getAcr();
                    this.waitForIdleController(acr);
                    this.setActionDeadline((Duration)actionTimeout.get());
                    action.accept(acr);
                    this.waitForIdleController(acr);
                    if (postCheck != null) {
                        postCheck.accept(acr);
                    }
                    actstat[0] = "OK";
                }
                catch (InterruptedException exc) {
                    LOG.log(Level.SEVERE, "{0} was interrupted. {1}", new Object[]{actionName, exc});
                }
                catch (TimeoutException exc) {
                    LOG.log(Level.SEVERE, "{0} timed out. {1}", new Object[]{actionName, exc});
                    actstat[0] = "TIMEOUT";
                }
                catch (CheckException exc) {
                    actstat[0] = exc.getCode();
                    LOG.log(Level.SEVERE, "{0} failed its post-check. {1}", new Object[]{actionName, exc});
                    actstat[0] = "FAILED";
                }
                catch (Exception exc) {
                    LOG.log(Level.SEVERE, "{0} threw an exception. {1}", new Object[]{actionName, exc});
                    this.cleanupAfterActionFailure(acr, exc);
                    this.commStatus = "DOWN";
                }
                finally {
                    this.returnAcr(acr);
                    this.actionStatus = actstat[0];
                }
            });
        }
    }

    private void runControllerAction(MyConsumer<AcrComm> action, String actionName, Duration actionTimeout) {
        this.runControllerAction(action, null, actionName, () -> actionTimeout);
    }

    private void runControllerQuery(MyConsumer<AcrComm> action, Duration queryTimeout) {
        if (!this.queryExec.isShutdown()) {
            this.queryExec.submit(() -> {
                AcrComm acr = null;
                try {
                    acr = this.getAcr();
                    action.accept(acr);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exc) {
                    LOG.log(Level.WARNING, "Query failure.", (Throwable)exc);
                }
                finally {
                    this.returnAcr(acr);
                }
            });
        }
    }

    private void waitForIdleController(AcrComm acr) throws TimeoutException, InterruptedException {
        while (true) {
            Instant now = Instant.now();
            boolean running = false;
            for (ProgramName p : Arrays.asList(Axis.moveProgram, Axis.homeProgram, Axis.errorProgram)) {
                running = running || acr.get(p, ProgramBit.PROGRAM_RUNNING);
            }
            if (!running) break;
            if (Instant.now().isAfter(this.currentActionDeadline)) {
                throw new TimeoutException("Timeout waiting for controller programs to stop running.");
            }
            Thread.sleep(this.completionCheckInterval.toMillis());
        }
    }

    private void cleanupAfterActionFailure(AcrComm acr, Exception exc) {
        this.actionExec.shutdownNow();
        LOG.log(Level.WARNING, "Command failed. Commencing cleanup.", (Throwable)exc);
        this.shutdownAcr(acr);
        try {
            this.createAcrs(1);
            acr = this.getAcr();
            this.stopEverything(acr);
        }
        catch (Exception exc2) {
            LOG.log(Level.WARNING, "Unable to stop motion after a command failed.", (Throwable)exc2);
        }
    }

    private void stopEverything(AcrComm acr) {
        acr.set(AxisName.AXIS0, AxisBit.KILL_ALL_MOTION, true);
        this.shutdownAcr(acr);
    }

    private Axis getAxis(String name) throws IllegalArgumentException {
        Axis axis = this.axisMap.get(name);
        if (axis == null) {
            throw new IllegalArgumentException(String.format("%s is a bad axis name.", name));
        }
        return axis;
    }

    private void setActionDeadline(Duration timeout) {
        this.currentActionDeadline = Instant.now().plus(timeout);
    }

    private void createAcrs(int numInstances) throws HardwareException {
        try {
            for (int i = 0; i < numInstances; ++i) {
                AcrComm acr = AcrComm.newInstance(ControllerType.ACR9000, this.IPv4Address, Optional.empty());
                this.acrInstances.add(acr);
            }
        }
        catch (IOException ex) {
            throw new HardwareException((Throwable)ex, null);
        }
    }

    private void shutdownAcr(AcrComm acr) {
        if (acr != null) {
            try {
                acr.cleanup();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private AcrComm getAcr() throws InterruptedException {
        AcrComm acr = this.acrInstances.take();
        return acr;
    }

    private AcrComm getAcrWithTimeout(Duration timeout) throws InterruptedException, TimeoutException {
        AcrComm acr = this.acrInstances.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
        if (acr == null) {
            throw new TimeoutException("Waiting for an AcrComm instance from the pool.");
        }
        return acr;
    }

    private void returnAcr(AcrComm acr) {
        if (acr != null && !this.acrInstances.offer(acr)) {
            this.shutdownAcr(acr);
            throw new IllegalStateException("Failed to return an AcrComm instance to the pool.");
        }
    }

    private static interface MyConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

