/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import org.indilib.i4j.INDIBLOBValue;
import org.indilib.i4j.INDIException;
import org.indilib.i4j.client.INDIBLOBProperty;
import org.indilib.i4j.client.INDIElement;
import org.indilib.i4j.client.INDIElementListener;
import org.indilib.i4j.client.INDIValueException;
import org.indilib.i4j.client.INDIViewCreator;
import org.indilib.i4j.protocol.DefBlob;
import org.indilib.i4j.protocol.DefElement;
import org.indilib.i4j.protocol.OneBlob;
import org.indilib.i4j.protocol.OneElement;

public class INDIBLOBElement
extends INDIElement {
    private INDIBLOBValue value = new INDIBLOBValue(new byte[0], "");
    private INDIBLOBValue desiredValue = null;
    private INDIElementListener uiComponent;

    protected INDIBLOBElement(DefBlob xml, INDIBLOBProperty property) {
        super((DefElement<?>)xml, property);
    }

    public INDIBLOBValue getValue() {
        return this.value;
    }

    @Override
    public void setValue(OneElement<?> xml) {
        this.value = new INDIBLOBValue((OneBlob)xml);
        this.notifyListeners();
    }

    @Override
    public INDIElementListener getDefaultUIComponent() throws INDIException {
        if (this.uiComponent != null) {
            this.removeINDIElementListener(this.uiComponent);
        }
        this.uiComponent = INDIViewCreator.getDefault().createBlobElementView(this, this.getProperty().getPermission());
        this.addINDIElementListener(this.uiComponent);
        return this.uiComponent;
    }

    @Override
    public boolean checkCorrectValue(Object valueToCheck) throws INDIValueException {
        if (valueToCheck == null) {
            throw new IllegalArgumentException("null value");
        }
        return valueToCheck instanceof INDIBLOBValue;
    }

    @Override
    public String getNameAndValueAsString() {
        return this.getName() + " - BLOB format: " + this.getValue().getFormat() + " - BLOB Size: " + this.getValue().getSize();
    }

    public INDIBLOBValue getDesiredValue() {
        return this.desiredValue;
    }

    @Override
    public void setDesiredValue(Object desiredValue) throws INDIValueException {
        INDIBLOBValue b = null;
        try {
            b = (INDIBLOBValue)desiredValue;
        }
        catch (ClassCastException e) {
            throw new INDIValueException(this, "Value for a BLOB Element must be a INDIBLOBValue");
        }
        this.desiredValue = b;
    }

    @Override
    public boolean isChanged() {
        return this.desiredValue != null;
    }

    @Override
    protected OneElement<?> getXMLOneElementNewValue() {
        INDIBLOBValue ibv = this.desiredValue;
        OneBlob result = ((OneBlob)new OneBlob().setName(this.getName())).setByteContent(this.value.getBlobData()).setFormat(ibv.getFormat());
        this.desiredValue = null;
        return result;
    }

    public String toString() {
        if (this.getValue().getSize() > 0) {
            return this.getValue().getFormat() + " (" + this.getValue().getSize() + " bytes)";
        }
        return "";
    }

    @Override
    public String getValueAsString() {
        return "BLOB format: " + this.getValue().getFormat() + " - BLOB Size: " + this.getValue().getSize();
    }
}

