/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.SALClassDescription;
import org.lsst.ccs.camera.sal.classes.SALClassDescriptionMaker;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.Mapping;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.subsystem.ocsbridge.util.ClassUtils;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;

public class GenericConverter {
    private static final Logger LOG = Logger.getLogger(GenericConverter.class.getName());
    private final List<String> mia = new ArrayList<String>();
    private final Map<Class, List<String>> alreadyWarned = new HashMap<Class, List<String>>();
    private final List<String> alreadyWarnedTelemetrySubsystems = new ArrayList<String>();
    private final List<String> alreadyWarnedConfigSubsystems = new ArrayList<String>();
    private final List<String> subsystemsToConvert = new ArrayList<String>();
    private final List<String> componentNames = new ArrayList<String>();
    private final Mapping mapping = Mapping.defaultMapping();
    private final XMLMaker2.SALType salType;
    private final Camera camera;
    private final Map<String, SALClassDescriptionMaker> salClassDescriptionMakerMap = new ConcurrentHashMap<String, SALClassDescriptionMaker>();
    private static final boolean logAndContinueOnConversionError = true;
    boolean badBValue = false;
    double badDValue = Double.NaN;
    int badIValue = -111111111;
    float badFValue = Float.NaN;
    String badStringValue = "NOTFOUND";
    long badLValue = -111111111L;
    short badSValue = (short)-11111;

    public GenericConverter(Camera camera, XMLMaker2.SALType salType) {
        this.salType = salType;
        this.camera = camera;
    }

    public boolean addSubsystem(String subsystemName) {
        Optional<MakeXMLConfiguration.DictionaryConfiguration> opt = this.getDictionaryConfgurationForSubsystemName(subsystemName);
        if (opt.isPresent()) {
            return this.addSubsystem(subsystemName, opt.get(), opt.get().getLevel());
        }
        return false;
    }

    public boolean addSubsystem(String subsystemName, int level) {
        Optional<MakeXMLConfiguration.DictionaryConfiguration> opt = this.getDictionaryConfgurationForSubsystemName(subsystemName);
        if (opt.isPresent()) {
            return this.addSubsystem(subsystemName, opt.get(), level);
        }
        return false;
    }

    public boolean addSubsystem(AgentInfo ai, DataProviderDictionary dict) {
        Optional<MakeXMLConfiguration.DictionaryConfiguration> opt = this.getDictionaryConfgurationForSubsystemName(ai, dict);
        if (opt.isPresent()) {
            MakeXMLConfiguration.DictionaryConfiguration dictConfig = opt.get();
            return this.addSubsystem(ai.getName(), dictConfig, dictConfig.getLevel());
        }
        return false;
    }

    private boolean addSubsystem(String subsystemName, MakeXMLConfiguration.DictionaryConfiguration dictConfig, int level) {
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictConfig, this.mapping, level);
        this.salClassDescriptionMakerMap.put(subsystemName, maker);
        this.subsystemsToConvert.add(subsystemName);
        this.componentNames.add(dictConfig.getComponentName());
        return true;
    }

    public void removeSubsystem(String subsystemName) {
        SALClassDescriptionMaker maker = this.salClassDescriptionMakerMap.remove(subsystemName);
        this.subsystemsToConvert.remove(subsystemName);
        if (maker != null) {
            this.componentNames.remove(maker.getDictionaryConfiguration().getComponentName());
        }
    }

    private Optional<MakeXMLConfiguration.DictionaryConfiguration> getDictionaryConfgurationForSubsystemName(AgentInfo agentInfo, DataProviderDictionary dict) {
        MakeXMLConfiguration.DictionaryConfiguration dictConfig = MakeXMLConfiguration.getInstance((Camera)this.camera, (XMLMaker2.SALType)this.salType).getDictionaryConfigurationForAgentInfo(agentInfo);
        if (dictConfig != null) {
            return Optional.of(dictConfig);
        }
        return Optional.empty();
    }

    private Optional<MakeXMLConfiguration.DictionaryConfiguration> getDictionaryConfgurationForSubsystemName(String subsystemName) {
        MakeXMLConfiguration.DictionaryConfiguration dictConfig = MakeXMLConfiguration.getInstance((Camera)this.camera, (XMLMaker2.SALType)this.salType).getDictionaryConfigurationForAgent(subsystemName);
        if (dictConfig != null) {
            return Optional.of(dictConfig);
        }
        return Optional.empty();
    }

    public Map<String, Class> getClassMap() {
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        for (SALClassDescriptionMaker maker : this.salClassDescriptionMakerMap.values()) {
            classMap.putAll(maker.getSALClasses());
        }
        return classMap;
    }

    public Map<String, SALClassDescription> getSALClassDescriptionMapForAgent(String agentName) {
        return this.salClassDescriptionMakerMap.get(agentName).getSALClassDescriptions();
    }

    public synchronized List<CameraTelemetry> telemetryConverter(StatusSubsystemData data) throws ReflectiveOperationException {
        String subsystemName = data.getOriginAgentInfo().getName();
        KeyValueDataList subsystemData = data.getEncodedData();
        if (subsystemData == null) {
            return Collections.emptyList();
        }
        List values = (List)((Object)subsystemData.getValue());
        HashMap<String, Serializable> dataNamesAndValues = new HashMap<String, Serializable>();
        LOG.log(Level.FINEST, " GenericConverter:telemetryConverter: Start Logging");
        for (KeyValueData kvd : values) {
            String pathFromBus = kvd.getKey();
            if (pathFromBus.contains("/state")) continue;
            dataNamesAndValues.put(pathFromBus, kvd.getValue());
            LOG.log(Level.FINEST, () -> {
                StringBuilder sb = new StringBuilder();
                sb.append("GenericConverter:settingsAppliedConverter: Variable name from Bus = ").append(kvd.getKey()).append(", Variable type from bus  = ").append(kvd.getType()).append(", Variable value from bus = ").append(kvd.getValue()).append("\n");
                return sb.toString();
            });
        }
        HashMap<String, Map<String, Object>> trendingData = new HashMap<String, Map<String, Object>>();
        try {
            if (subsystemData.getAttribute("taskName") == null) {
                trendingData.put("Trending", dataNamesAndValues);
            } else {
                trendingData.put("", dataNamesAndValues);
            }
        }
        catch (NullPointerException npe) {
            trendingData.put("", dataNamesAndValues);
        }
        return this.telemetryConverter(subsystemName, trendingData);
    }

    List<CameraTelemetry> telemetryConverter(String subsystemName, Map<String, Map<String, Object>> trendingData) throws ReflectiveOperationException {
        if (!this.salType.equals((Object)XMLMaker2.SALType.TELEMETRY)) {
            throw new RuntimeException("GenericConverter:telemetryConverter: Cannot invoke telemetry conversion for type converter of type " + this.salType);
        }
        ArrayList<CameraTelemetry> salTelemetry = new ArrayList<CameraTelemetry>();
        for (Map.Entry<String, Map<String, Object>> e : trendingData.entrySet()) {
            Map<String, Object> dataNamesAndValues = e.getValue();
            if (!this.subsystemsToConvert.contains(subsystemName)) {
                if (!this.alreadyWarnedTelemetrySubsystems.contains(subsystemName)) {
                    this.alreadyWarnedTelemetrySubsystems.add(subsystemName);
                    LOG.log(Level.WARNING, () -> {
                        StringBuilder sb = new StringBuilder();
                        sb.append(" GenericConverter: telemetryConverter: returning Empty List of CameraTelemetry , Current susbsystem : ").append(subsystemName).append(", Contents of subsystemsToConvert ").append(this.subsystemsToConvert.toString());
                        return sb.toString();
                    });
                }
                return Collections.emptyList();
            }
            Map givenSalClassMapInfo = this.salClassDescriptionMakerMap.get(subsystemName).getSALClassDescriptions();
            LOG.log(Level.FINEST, "GenericConverter:telemetryConverter: SalClassMap printout Follows : ");
            givenSalClassMapInfo.entrySet().forEach(scd -> LOG.log(Level.FINEST, () -> {
                StringBuilder sb = new StringBuilder();
                sb.append("GenericConverter:settingsAppliedConverter: Variable name from SALClassDescription = ").append((String)scd.getKey()).append(", Complete SALClassDescription = ").append(scd.getValue()).append("\n");
                return sb.toString();
            }));
            LOG.log(Level.FINEST, "GenericConverter:telemetryConverter: SalClassMap printout Ends : ");
            for (Map.Entry scd2 : givenSalClassMapInfo.entrySet()) {
                String scdSALClassName = (String)scd2.getKey();
                if (!((SALClassDescription)scd2.getValue()).getCategory().equals(e.getKey())) continue;
                LOG.log(Level.FINEST, " GenericConverter:telemetryConverter: Class Name from SALClassDescription {0}", scdSALClassName);
                Class realSALClass = ((SALClassDescription)scd2.getValue()).getSimpleSalClass();
                if (realSALClass == null) {
                    LOG.log(Level.WARNING, " GenericConverter:telemetryConverter: No entry found for {0}", scdSALClassName);
                }
                if (realSALClass == null) continue;
                Parameter[] parameters = realSALClass.getConstructors()[0].getParameters();
                CameraTelemetry ct = (CameraTelemetry)this.reflectedClass(realSALClass, dataNamesAndValues, parameters, (SALClassDescription)scd2.getValue(), null);
                LOG.log(Level.FINEST, " GenericConverter:telemetryConverter: Class Received {0}", ct.toString());
                int[] check = this.checkClassCompleteness(ct);
                int numMissingValues = check[0];
                int numGetMethods = check[1];
                int numberOfBooleanGets = check[2];
                LOG.log(Level.FINEST, " GenericConverter:telemetryConverter: Class quality check Follows ");
                LOG.log(Level.FINEST, " GenericConverter:telemetryConverter: class name {0}, Number of missing values {1}", new Object[]{ct.getClass().getName(), check[0]});
                LOG.log(Level.FINEST, " GenericConverter:telemetryConverter: Number of get functions {0}, Number of boolean ''is'' Functions {1}", new Object[]{check[1], check[2]});
                boolean gets = false;
                boolean bools = false;
                gets = numMissingValues < numGetMethods;
                boolean bl = bools = numberOfBooleanGets > 0;
                if (!gets && (!bools || numGetMethods != 0)) continue;
                salTelemetry.add(ct);
            }
        }
        LOG.log(Level.FINEST, " GenericConverter:telemetryConverter : Number of classes in SAL Telemetry {0}", salTelemetry.size());
        LOG.log(Level.FINEST, "GenericConverter:telemetryConverter: End Logging ");
        return salTelemetry;
    }

    public List<CameraEvent> settingsAppliedEventConverter(StatusConfigurationInfo sdata) throws ReflectiveOperationException {
        ConfigurationInfo data = sdata.getConfigurationInfo();
        List cpinfo = data.getAllParameterInfo();
        LOG.log(Level.FINEST, " GenericConverter:settingsAppliedConverter Start Logging ");
        LOG.log(Level.FINEST, "GenericConverter:settingsAppliedConverter: Data from Bus Message ****");
        LOG.log(Level.FINEST, () -> {
            StringBuilder sb = new StringBuilder();
            for (ConfigurationParameterInfo dinfo : data.getAllParameterInfo()) {
                sb.append("GenericConverter:settingsAppliedConverter: Category from Bus : ").append(dinfo.getCategoryName()).append(" ,Data from bus: ").append(dinfo.getPathName()).append(" = ").append(dinfo.getCurrentValueObject()).append("\n");
            }
            return sb.toString();
        });
        String subsystemName = sdata.getOriginAgentInfo().getName();
        if (!this.subsystemsToConvert.contains(subsystemName)) {
            if (!this.alreadyWarnedConfigSubsystems.contains(subsystemName)) {
                this.alreadyWarnedConfigSubsystems.add(subsystemName);
                LOG.log(Level.WARNING, () -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append("GenericConverter:settingsAppliedConverter: Returning Empty List of CameraEvents, Current susbsystem = ").append(subsystemName).append(" Contents of subsystemsToConvert :").append(this.subsystemsToConvert.toString());
                    return sb.toString();
                });
            }
            return Collections.emptyList();
        }
        HashMap<String, Map<String, Object>> categoryDataMap = new HashMap<String, Map<String, Object>>();
        for (ConfigurationParameterInfo cpi : cpinfo) {
            String category = cpi.getCategoryName();
            Map dataMapForCategory = categoryDataMap.computeIfAbsent(category, c -> new HashMap());
            dataMapForCategory.put(cpi.getPathName(), cpi.getCurrentValueObject());
        }
        HashMap<String, String> catVersionMap = new HashMap<String, String>();
        for (String category : data.getCategorySet()) {
            catVersionMap.put(category, data.getConfigurationDescriptionObject().getCategoryTag(category).toString());
        }
        LOG.log(Level.FINEST, " GenericConverter:settingsAppliedConverter: End Logging ");
        return this.settingsAppliedEventConverter(subsystemName, categoryDataMap, catVersionMap);
    }

    /*
     * Could not resolve type clashes
     */
    List<CameraEvent> settingsAppliedEventConverter(String subsystemName, Map<String, Map<String, Object>> categoryDataMap, Map<String, String> categoryVersionMap) throws ReflectiveOperationException {
        LOG.log(Level.FINEST, " GenericConverter:settingsAppliedConverter: Start Logging ");
        if (!this.salType.equals((Object)XMLMaker2.SALType.SETTINGS_APPLIED)) {
            throw new RuntimeException("GenericConverter:settingsAppliedEventConverter: Cannot invoke events conversion for type converter of type " + this.salType);
        }
        ArrayList<CameraEvent> salSettings = new ArrayList<CameraEvent>();
        Map salClassMapInfo = this.salClassDescriptionMakerMap.get(subsystemName).getSALClassDescriptions();
        LOG.log(Level.FINEST, "GenericConverter:settingsAppliedConverter: SALClassDescription information Follows ");
        for (Map.Entry scd : salClassMapInfo.entrySet()) {
            String scdSALClassName = (String)scd.getKey();
            LOG.log(Level.FINEST, () -> {
                StringBuilder sb = new StringBuilder();
                sb.append(" GenericConverter: settingsAppliedConverter: Class Name from SALClassDescription: ").append(scdSALClassName).append(", Printout of SALClassDescription ").append(((SALClassDescription)scd.getValue()).toString());
                return sb.toString();
            });
        }
        for (Map.Entry sc : salClassMapInfo.entrySet()) {
            Class realSALClass;
            String scCategory = ((SALClassDescription)sc.getValue()).getCategory();
            Map<String, Object> thisCategoriesDataNew = categoryDataMap.get(scCategory);
            if (thisCategoriesDataNew == null) continue;
            String componentName = this.componentNames.get(this.subsystemsToConvert.indexOf(subsystemName));
            if (!((String)sc.getKey()).contains("_" + componentName + "_") || scCategory == null || scCategory == "null" || scCategory.isEmpty() || (realSALClass = ((SALClassDescription)sc.getValue()).getSimpleSalClass()) == null || thisCategoriesDataNew.isEmpty()) continue;
            Parameter[] parameters = realSALClass.getConstructors()[0].getParameters();
            Method[] premethods = realSALClass.getMethods();
            LOG.log(Level.FINEST, " GenericConverter:settingsAppliedConverter: Preliminary printout of methods and parameter names ");
            for (Method premethod : premethods) {
                LOG.log(Level.FINEST, () -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append(" GenericConverter:settingsAppliedConverter: Method name of reflected class before constructor invocation- compare to whats on the bus: ").append(premethod.getName());
                    return sb.toString();
                });
            }
            for (AnnotatedElement parameter : parameters) {
                LOG.log(Level.FINEST, () -> GenericConverter.lambda$settingsAppliedEventConverter$9((Parameter)parameter));
            }
            String categoryVersion = categoryVersionMap.get(scCategory);
            try {
                CameraEvent ce = (CameraEvent)this.reflectedClass(realSALClass, thisCategoriesDataNew, parameters, (SALClassDescription)sc.getValue(), categoryVersion);
                LOG.log(Level.FINEST, () -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append(" GenericConverter:settingsAppliedConverter: Class Received : ").append(ce.toString());
                    return sb.toString();
                });
                int[] check = this.checkClassCompleteness(ce);
                int numMissingValues = check[0];
                int numGetMethods = check[1];
                LOG.log(Level.FINEST, " GenericConverter:settingsAppliedConverter: Class quality check: Number of missing values {0}, Number of get functions {1}", new Object[]{check[0], check[1]});
                if (numMissingValues != numGetMethods) {
                    salSettings.add(ce);
                }
                if (numMissingValues != numGetMethods) continue;
                LOG.log(Level.WARNING, " GenericConverter:settingsAppliedConverter: No values have been found on the bus, values extracted from ConfigInfo and inserted into the Map dataNamesAndValues: {0}", ce.toString());
                for (String tospath : thisCategoriesDataNew.keySet()) {
                    if (tospath.contains("/state")) continue;
                    LOG.log(Level.WARNING, () -> {
                        StringBuilder sb = new StringBuilder();
                        sb.append("GenericConverter:settingsAppliedConverter: Path: ").append(tospath).append(", category data: ").append(thisCategoriesDataNew.get(tospath));
                        return sb.toString();
                    });
                }
            }
            catch (ReflectiveOperationException | RuntimeException x) {
                LOG.log(Level.WARNING, "Error converting configuration, continuing", x);
            }
        }
        LOG.log(Level.FINEST, " GenericConverter:settingsAppliedConverter: End Logging ");
        return salSettings;
    }

    private Object reflectedClass(Class cls, Map<String, Object> dataNamesAndValues, Parameter[] parameters, SALClassDescription salClassDescriptionList, String categoryVersion) throws ReflectiveOperationException {
        ArrayList<Object> constructorArgs = new ArrayList<Object>();
        HashMap<String, List> locationBusVariableCorrespondence = new HashMap<String, List>();
        HashMap<String, List> locationAvailableValuesMap = new HashMap<String, List>();
        for (SALClassDescription.SALVariable sv : salClassDescriptionList.getVariables()) {
            if (!(sv instanceof SALClassDescription.PatternMatchedSALVariable)) continue;
            SALClassDescription.PatternMatchedSALVariable patternVar = (SALClassDescription.PatternMatchedSALVariable)sv;
            SALClassDescription.LocationVariable locationVar = patternVar.getLocationVariable();
            String locationName = locationVar.getVariableName();
            locationBusVariableCorrespondence.put(locationName, locationVar.getBusVariables());
            locationAvailableValuesMap.put(locationName, locationVar.getAvailableLocationValues());
        }
        LOG.log(Level.FINEST, " GenericConverter:reflectedClass: Start Logging ");
        LOG.log(Level.FINEST, () -> {
            StringBuilder sb = new StringBuilder();
            sb.append(" GenericConverter:reflectedClass: Data names and values : ").append(dataNamesAndValues.toString());
            return sb.toString();
        });
        LOG.log(Level.FINEST, " GenericConverter:reflectedClass: SAL variables from SAL class description ");
        for (Parameter[] psv : salClassDescriptionList.getVariables()) {
            LOG.log(Level.FINEST, () -> GenericConverter.lambda$reflectedClass$13((SALClassDescription.SALVariable)psv));
        }
        boolean found = false;
        for (Parameter parameter : parameters) {
            found = false;
            LOG.log(Level.FINEST, () -> {
                StringBuilder sb = new StringBuilder();
                sb.append(" GenericConverter:reflectedClass: SAL class parameters: Parameter Name : ").append(parameter.getName()).append(", Parameter Type :").append(parameter.getType());
                return sb.toString();
            });
            if (parameter.getName().trim().equals("priority")) {
                constructorArgs.add(1);
                LOG.log(Level.FINEST, " GenericConverter:reflectedClass:  Priority found and set ");
                found = true;
            }
            if (parameter.getName().trim().equals("version") && categoryVersion != null) {
                constructorArgs.add(categoryVersion);
                LOG.log(Level.FINEST, " GenericConverter:reflectedClass: version found {0}", parameter);
                found = true;
            }
            if (!found) {
                for (SALClassDescription.SALVariable sv : salClassDescriptionList.getVariables()) {
                    String pathName;
                    Object returnedBusData;
                    int i;
                    String parameterType = parameter.getType().toString();
                    boolean parameterIsArray = parameter.getType().isArray();
                    boolean isAnArrayList = parameterType.contains("List") || parameterType.contains("List");
                    boolean isAnArray = !isAnArrayList && parameterType.contains("[");
                    boolean isAString = parameterType.contains("String") || parameterType.contains("String");
                    boolean isAMap = parameterType.contains("Map");
                    LOG.log(Level.FINEST, () -> {
                        StringBuilder sb = new StringBuilder();
                        sb.append(" GenericConverter:reflectedClass  Parameter Name: ").append(parameter.getName()).append(", SAL Class Variable Name :").append(sv.getVariableName()).append(", Parameter Type: ").append(parameter.getType()).append(", SAL Class Variable Type: ").append(sv.getType());
                        return sb.toString();
                    });
                    boolean involvesPatternMatching = sv instanceof SALClassDescription.PatternMatchedSALVariable;
                    if (involvesPatternMatching) {
                        LOG.log(Level.FINEST, () -> {
                            StringBuilder sb = new StringBuilder();
                            sb.append(" GenericConverter:reflectedClass: pattern matching, Compare SAL Class parameter name ").append(parameter.getName()).append(", SAL class Variable name ").append(sv.getVariableName()).append(", SAL Class Parameter type ").append(parameter.getType()).append(",SAL Class description parameter type ").append(sv.getType());
                            return sb.toString();
                        });
                    }
                    boolean matchParName = sv.getVariableName().toLowerCase().trim().equals(parameter.getName().toLowerCase().trim());
                    String svVariableName = "";
                    boolean isLocation = false;
                    if (sv instanceof SALClassDescription.LocationVariable) {
                        svVariableName = ((SALClassDescription.LocationVariable)sv).getVariableName();
                        isLocation = true;
                    } else if (sv instanceof SALClassDescription.PatternMatchedSALVariable) {
                        svVariableName = ((SALClassDescription.PatternMatchedSALVariable)sv).getLocationVariable().getVariableName();
                    }
                    if (!matchParName) continue;
                    LOG.log(Level.FINEST, " GenericConverter:reflectedClass: Match found, SAL Class parameter {0} SAL variable description {1}", new Object[]{parameter.getName(), sv.getVariableName()});
                    LOG.log(Level.FINEST, " GenericConverter: reflectedClass: Match found, SAL Class parameter type {0} SAL variable description type {1}", new Object[]{parameter.getType(), sv.getType()});
                    if (parameterIsArray && involvesPatternMatching && !isLocation) {
                        List locationVals = (List)locationAvailableValuesMap.get(svVariableName);
                        Object arrayArg = Array.newInstance(parameter.getType().getComponentType(), locationVals.size());
                        for (SALClassDescription.BusVariable busVar : ((SALClassDescription.PatternMatchedSALVariable)sv).getBusVariables()) {
                            String pathName2 = busVar.getPathAndNameOnBuses();
                            String busVarLocation = busVar.getLocationValue();
                            i = locationVals.indexOf(busVarLocation);
                            Object returnedBusData2 = this.returnBusData(cls, parameter, pathName2, dataNamesAndValues.get(pathName2));
                            if (null != returnedBusData2) {
                                LOG.log(Level.FINEST, () -> {
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("GenericConverter:reflectedClass: Filling array, Parameter name : ").append(parameter.getName()).append(", SAL Class Description Name ").append(sv.getDescription()).append(", Bus type: ").append(returnedBusData2.getClass().getTypeName()).append(", Bus variable name {3}: ").append(busVar.getPathAndNameOnBuses()).append(", Array element index: ").append(i).append(", Array element value from bus ").append(returnedBusData2);
                                    return sb.toString();
                                });
                                Object returnedData = returnedBusData2;
                                if (returnedData.getClass().isArray()) {
                                    arrayArg = returnedData;
                                    continue;
                                }
                                Array.set(arrayArg, i, returnedData);
                                continue;
                            }
                            Array.set(arrayArg, i, this.AssignValuesForMissingBusData(parameter));
                        }
                        LOG.log(Level.FINEST, " GenericConverter:reflectedClass: adding argument to constructor list : SAL class parameter  name {0}, parameter type {1}, SAL class description parameter name {2}, SAL class description parameter type {3}, Constructor array argument value {4} constructor array argument type {5}", new Object[]{parameter.getName(), parameter.getClass().getTypeName(), sv.getVariableName(), sv.getType(), arrayArg.toString(), arrayArg.getClass().getTypeName()});
                        constructorArgs.add(arrayArg);
                        found = true;
                    }
                    if (!parameterIsArray && sv instanceof SALClassDescription.LocationVariable) {
                        LOG.log(Level.FINEST, "GenericConverter:reflectedClass: Location variables, SAL Class parameter name  {0}, SAL Description Name {1}, SAL Class Description printout {2}", new Object[]{parameter.getName(), sv.getVariableName(), sv.toString()});
                        if (locationBusVariableCorrespondence.get(sv.getVariableName()) == null) {
                            LOG.log(Level.WARNING, " GenericConverter:reflectedClass: Null from locationBusVariableCorrespondence {0}", sv.toString());
                        }
                        constructorArgs.add(GenericConverter.convertStringList(((SALClassDescription.LocationVariable)sv).getAvailableLocationValues()));
                        found = true;
                    }
                    if (parameterIsArray && !involvesPatternMatching) {
                        String busVariableName;
                        boolean notmatched = sv instanceof SALClassDescription.SimpleSALVariable;
                        LOG.log(Level.FINEST, () -> {
                            StringBuilder sb = new StringBuilder();
                            sb.append(" GenericConverter:reflectedClass : No pattern matching has occurred but we have found an array investigating :  SAL parameter name : ").append(sv.getVariableName()).append(", SALClassDescription parameter ").append(parameter.getName());
                            sb.append("\n GenericConverter:reflectedClass : Found non pattern matched array more info  SAL parameter type: ").append(parameter.getType()).append(",SALClassDescription parameter type: ").append(sv.getType());
                            sb.append("\n you should find the name directly below if it is the corresponding bus variable in SAL class description ");
                            return sb.toString();
                        });
                        if (notmatched) {
                            LOG.log(Level.FINEST, () -> {
                                StringBuilder sb = new StringBuilder();
                                sb.append(" GenericConverter:reflectedClass: Found non pattern matched array from SALClassDescription associated bus variable : ").append(((SALClassDescription.SimpleSALVariable)sv).getBusVariable().getPathAndNameOnBuses());
                                return sb.toString();
                            });
                        }
                        if (null != (returnedBusData = this.returnBusData(cls, parameter, busVariableName = ((SALClassDescription.SimpleSALVariable)sv).getBusVariable().getPathAndNameOnBuses(), dataNamesAndValues.get(busVariableName)))) {
                            int xmlArraySize = ((SALClassDescription.SimpleSALVariable)sv).getCount();
                            Object arrayArg = Array.newInstance(parameter.getType().getComponentType(), xmlArraySize);
                            int dataArraySize = Array.getLength(returnedBusData);
                            if (dataArraySize > xmlArraySize) {
                                LOG.log(Level.WARNING, "Array for variable {0} exceeds the specified xml size (MaxLength = {1}, actual size = {2}). Excess data is lost.", new Object[]{busVariableName, xmlArraySize, dataArraySize});
                            }
                            for (i = 0; i < dataArraySize; ++i) {
                                Array.set(arrayArg, i, Array.get(returnedBusData, i));
                            }
                            for (i = dataArraySize; i < xmlArraySize; ++i) {
                                Array.set(arrayArg, i, this.AssignValuesForMissingBusData(parameter));
                            }
                            constructorArgs.add(arrayArg);
                        } else {
                            Object arrayArg = Array.newInstance(parameter.getType().getComponentType(), new int[0]);
                            Array.set(arrayArg, 0, this.AssignValuesForMissingBusData(parameter));
                            constructorArgs.add(arrayArg);
                        }
                        found = true;
                    }
                    if (involvesPatternMatching && !parameterIsArray && !isLocation) {
                        boolean matched = sv instanceof SALClassDescription.PatternMatchedSALVariable;
                        LOG.log(Level.FINEST, () -> {
                            StringBuilder sb = new StringBuilder();
                            sb.append(" GenericConverter:reflectedClass: Pattern matched but not array, nor location :  SAL parameter name ").append(parameter.getName()).append(", SALClassDescription parameter ").append(sv.getVariableName()).append(", Parameter type ").append(parameter.getType()).append(" SALClassDescription Parameter Type ").append(sv.getType()).append(" See below for Bus pathname in SalClassDescription ");
                            return sb.toString();
                        });
                        if (matched) {
                            LOG.log(Level.FINEST, () -> {
                                StringBuilder sb = new StringBuilder();
                                sb.append(" GenericConverter:reflectedClass: Pattern matched but not array or location, SalClassDescription's bus path name : ").append(((SALClassDescription.BusVariable)((SALClassDescription.PatternMatchedSALVariable)sv).getBusVariables().get(0)).getPathAndNameOnBuses());
                                return sb.toString();
                            });
                        }
                        SALClassDescription.PatternMatchedSALVariable pmv = (SALClassDescription.PatternMatchedSALVariable)sv;
                        if (parameter.getType() != String.class) {
                            throw new RuntimeException("What should we do with type: " + parameter.getType() + " for parameter " + parameter.getName());
                        }
                        Object result = "";
                        for (SALClassDescription.BusVariable bv : pmv.getBusVariables()) {
                            String pathName3 = bv.getPathAndNameOnBuses();
                            String returnedBusData3 = (String)this.returnBusData(cls, parameter, pathName3, dataNamesAndValues.get(pathName3));
                            if (!((String)result).isEmpty()) {
                                result = (String)result + ":";
                            }
                            result = (String)result + returnedBusData3;
                        }
                        constructorArgs.add(result);
                        found = true;
                    }
                    if (involvesPatternMatching || parameterIsArray || isLocation) continue;
                    boolean notmatched = sv instanceof SALClassDescription.SimpleSALVariable;
                    LOG.log(Level.FINEST, () -> {
                        StringBuilder sb = new StringBuilder();
                        sb.append(" GenericConverter:reflectedClass : Not array nor pattern matched nor location: parameter name: ").append(parameter.getName()).append(", SALClassDescription parameter: ").append(sv.getVariableName()).append(" parameter type {0} ").append(parameter.getType()).append("  SALClassDescription parameter type {1}").append(sv.getType());
                        return sb.toString();
                    });
                    LOG.log(Level.FINEST, () -> {
                        StringBuilder sb = new StringBuilder();
                        sb.append(" GenericConverter:reflectedClass: you should see the BusVariable from SALClassDescription on the next line ");
                        return sb.toString();
                    });
                    if (notmatched) {
                        LOG.log(Level.FINEST, () -> {
                            StringBuilder sb = new StringBuilder();
                            sb.append(" GenericConverter:reflectedClass: Bus Variable Name from SALClassDescription for unmatched variable ").append(((SALClassDescription.SimpleSALVariable)sv).getBusVariable().getPathAndNameOnBuses());
                            return sb.toString();
                        });
                    }
                    if (null != (returnedBusData = this.returnBusData(cls, parameter, pathName = ((SALClassDescription.SimpleSALVariable)sv).getBusVariable().getPathAndNameOnBuses(), dataNamesAndValues.get(pathName)))) {
                        constructorArgs.add(returnedBusData);
                    } else {
                        constructorArgs.add(this.AssignValuesForMissingBusData(parameter));
                    }
                    found = true;
                }
            }
            if (found) continue;
            LOG.log(Level.WARNING, " GenericConverter:reflectedClass: Problem : parameter was not found, for Class Name {0} Parameter Name {1}", new Object[]{cls.getCanonicalName(), parameter.getName()});
            LOG.log(Level.WARNING, " GenericConverter:reflectedClass : Problem : Parameter was not found is it in the list following ? ");
            for (String tospath : dataNamesAndValues.keySet()) {
                LOG.log(Level.WARNING, "GenericConverter:reflectedClass: Problem, parameter not found - here are all the parameters we have stored, path name {0} value {1} type {2}", new Object[]{tospath, dataNamesAndValues.get(tospath), dataNamesAndValues.get(tospath).getClass().getTypeName()});
            }
            this.mia.add(parameter.getName());
            this.alreadyWarned.put(cls, this.mia);
            int jj = Collections.frequency((Collection)this.alreadyWarned.get(cls), parameter.getName());
            if (parameter.getType().isArray()) {
                Object arrayArg = Array.newInstance(parameter.getType().getComponentType(), 0);
                constructorArgs.add(arrayArg);
                continue;
            }
            constructorArgs.add(this.AssignValuesForMissingBusData(parameter));
        }
        LOG.log(Level.FINEST, "GenericConverter:reflectedClass: cross check just before reflection, class name {0}, constructor (compare with arguments below) {1}", new Object[]{cls.getName(), cls.getConstructors()[0].toString()});
        for (int i = 0; i < constructorArgs.size(); ++i) {
            LOG.log(Level.FINEST, "GenericConverter: reflectedClass - matched arguments being provided to above constructor{0} {1} Value and Type 2 {2}", new Object[]{constructorArgs.get(i), constructorArgs.get(i).getClass().getTypeName(), Arrays.toString(constructorArgs.get(i).getClass().getTypeParameters())});
        }
        try {
            LOG.log(Level.FINEST, " GenericConverter:reflectedClass: End Logging ");
            return cls.getConstructors()[0].newInstance(constructorArgs.toArray());
        }
        catch (ReflectiveOperationException | RuntimeException x) {
            throw new RuntimeException(String.format("Error creating SAL event for class %s with args %s", cls.getCanonicalName(), GenericConverter.betterToString(parameters, constructorArgs)), x);
        }
    }

    private Object returnBusData(Class cls, Parameter parameter, String pathName, Object returnValue) {
        boolean classTypeIsConfig = false;
        if (cls.getCanonicalName().contains("Event") && cls.getCanonicalName().contains("org.lsst.sal.cccamera.event")) {
            classTypeIsConfig = true;
        }
        LOG.log(Level.FINEST, " GenericConverter:returnBusData: Start Logging");
        LOG.log(Level.FINEST, " GenericConverter:returnBusData: Parameter name {0}, Parameter type {1}", new Object[]{parameter.getName(), parameter.getParameterizedType().getTypeName()});
        LOG.log(Level.FINEST, " GenericConverter:returnBusData: Given path name {0}", pathName);
        LOG.log(Level.FINEST, " GenericConverter:returnBusData: Return Value {0}", returnValue);
        if (returnValue == null) {
            return null;
        }
        if (returnValue instanceof Double) {
            LOG.log(Level.FINEST, " GenericConverter:returnBusData: instance of double {0}", returnValue);
        }
        if (returnValue instanceof Duration && !parameter.getType().toString().toLowerCase().contains("string")) {
            returnValue = ((Duration)returnValue).getSeconds();
            LOG.log(Level.FINEST, " GenericConverter:returnBusData: java.time.duration in seconds {0}", returnValue);
        }
        if (returnValue instanceof HashMap) {
            returnValue = ((HashMap)returnValue).toString();
            LOG.log(Level.FINEST, " GenericConverter:returnBusData: returnValue is hashmap - printing as string {0}", returnValue.toString());
            if (returnValue.getClass().getTypeName().contains("[")) {
                LOG.log(Level.FINEST, " GenericConverter:returnBusData: a hashmap containing [ in getTypeName {0}", returnValue.toString());
            }
        }
        if (returnValue.getClass().getTypeName().toLowerCase().contains("string") && returnValue instanceof String[]) {
            LOG.log(Level.FINEST, " GenericConverter:returnBusData: return value is a string {0}", returnValue);
            returnValue = GenericConverter.convertStringArray((String[])returnValue);
        }
        if (returnValue instanceof List || returnValue instanceof Map || returnValue instanceof Enum) {
            returnValue = returnValue.toString();
        }
        if (returnValue instanceof Duration && parameter.getType().toString().toLowerCase().contains("string")) {
            returnValue = returnValue.toString();
        }
        if (returnValue.getClass().getTypeName().toLowerCase().contains("string") && returnValue instanceof List) {
            returnValue = GenericConverter.convertStringList((List)returnValue);
        }
        if (null == returnValue) {
            LOG.log(Level.WARNING, " GenericConverter:returnBusData: From returnBusData : return value is null ! {0}", returnValue);
            if (classTypeIsConfig) {
                LOG.log(Level.WARNING, " GenericConverter:returnBusData: Bus data contains null for pathname : {0}, for Config class name  {1}, parameter name {2}", new Object[]{pathName, cls.getTypeName(), parameter.getName()});
            }
            returnValue = this.AssignValuesForMissingBusData(parameter);
        }
        LOG.log(Level.FINEST, " GenericConverter:returnBusData: End Logging");
        return returnValue;
    }

    private boolean badValueOrValues(Object invokedValue, Object badValue, String className, String methodName) {
        boolean bad = true;
        boolean isanArray = invokedValue.getClass().isArray();
        String type = invokedValue.getClass().getTypeName();
        boolean isDouble = false;
        boolean isString = false;
        boolean isInt = false;
        boolean isFloat = false;
        boolean isLong = false;
        boolean isBool = false;
        boolean isShort = false;
        if (type.toLowerCase().contains("double")) {
            isDouble = true;
            badValue = this.badDValue;
            if (isanArray && isDouble) {
                double[] doubleArray = (double[])invokedValue;
                for (int i = 0; i < doubleArray.length; ++i) {
                    if (Double.isNaN(doubleArray[i])) continue;
                    bad = false;
                }
            }
        } else if (type.toLowerCase().contains("string")) {
            isString = true;
            badValue = this.badStringValue;
            if (isanArray) {
                String[] stringArray = (String[])invokedValue;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == this.badStringValue) continue;
                    bad = false;
                }
            }
        } else if (type.toLowerCase().contains("int")) {
            isInt = true;
            badValue = this.badIValue;
            if (isanArray) {
                int[] intArray = (int[])invokedValue;
                for (int i = 0; i < intArray.length; ++i) {
                    if (intArray[i] == (Integer)badValue) continue;
                    bad = false;
                }
            }
        } else if (type.toLowerCase().contains("float")) {
            isFloat = true;
            badValue = Float.valueOf(this.badFValue);
            if (isanArray) {
                float[] floatArray = (float[])invokedValue;
                for (int i = 0; i < floatArray.length; ++i) {
                    if (Float.isNaN(floatArray[i])) continue;
                    bad = false;
                }
            }
        } else if (type.toLowerCase().contains("long")) {
            isLong = true;
            badValue = this.badLValue;
            if (isanArray) {
                long[] longArray = (long[])invokedValue;
                for (int i = 0; i < longArray.length; ++i) {
                    if (longArray[i] == this.badLValue) continue;
                    bad = false;
                }
            }
        } else if (type.toLowerCase().contains("short")) {
            isShort = true;
            badValue = this.badSValue;
            if (isanArray) {
                short[] shortArray = (short[])invokedValue;
                for (int i = 0; i < shortArray.length; ++i) {
                    if ((long)shortArray[i] == (long)this.badSValue) continue;
                    bad = false;
                }
            }
        } else {
            throw new RuntimeException("Value provided is not in the list of expected values : " + type);
        }
        if (!isanArray && !invokedValue.equals(badValue)) {
            bad = false;
        }
        LOG.log(Level.FINEST, " GenericConverter:badValueOrValues Start Logging ");
        LOG.log(Level.FINEST, " GenericConverter:badValueOrValues : Class name {0}, method name {1}", new Object[]{className, methodName});
        LOG.log(Level.FINEST, " GenericConverter:badValueOrValues: Array ? {0}, type {1}", new Object[]{isanArray, invokedValue.getClass().getTypeName()});
        LOG.log(Level.FINEST, " GenereicConverter:badValueOrValues: invokedValue {0}, badValue {1}", new Object[]{invokedValue, badValue});
        LOG.log(Level.FINEST, " GenericConverter:badValueOrValues End Logging ");
        return bad;
    }

    private static String betterToString(Parameter[] parameters, ArrayList<Object> data) {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        for (int i = 0; i < data.size(); ++i) {
            boolean classesMatch = ClassUtils.isAssignable(data.get(i).getClass(), parameters[i].getType(), true);
            String argString = parameters[i].getName() + "=" + (data.get(i).getClass().isArray() ? GenericConverter.arrayToString(data.get(i)) : data.get(i).toString());
            if (!classesMatch) {
                argString = argString + String.format(" WARNING: classMismatch %s != %s", parameters[i].getType(), data.get(i).getClass());
            }
            result.add((CallSite)((Object)argString));
        }
        return "[" + String.join((CharSequence)", ", result) + "]";
    }

    private static String convertStringSet(Set<String> stringSet) {
        String[] localArray = new String[stringSet.size()];
        stringSet.toArray(localArray);
        return GenericConverter.manipulateStringArray(localArray);
    }

    private static String convertStringList(List<String> stringList) {
        String[] localArray = new String[stringList.size()];
        stringList.toArray(localArray);
        return GenericConverter.manipulateStringArray(localArray);
    }

    private static String convertStringArray(String[] stringArray) {
        Object localArray = null;
        return GenericConverter.manipulateStringArray(stringArray);
    }

    private static String manipulateStringArray(String[] inputArray) {
        Object returnStringI = "";
        Object returnStringF = "";
        int lengthOfStringArray = inputArray.length;
        if (lengthOfStringArray <= 0) {
            System.out.println("Warning from GenericConverter3:manipulateStringArray : Length of string Array is 0 !");
            returnStringF = "NOTFOUND";
        } else {
            for (int i = 0; i < lengthOfStringArray; ++i) {
                returnStringI = (String)returnStringI + inputArray[i] + ":";
                if (i != lengthOfStringArray - 1) continue;
                int target = ((String)returnStringI).lastIndexOf(":");
                returnStringF = target == -1 ? returnStringI : ((String)returnStringI).substring(0, target);
            }
        }
        return returnStringF;
    }

    private static String arrayToString(Object array) {
        ArrayList<String> result = new ArrayList<String>();
        int l = Array.getLength(array);
        for (int i = 0; i < l; ++i) {
            result.add(Array.get(array, i).toString());
        }
        return "[" + String.join((CharSequence)", ", result) + "]";
    }

    private int[] checkClassCompleteness(Object cls) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        Parameter[] thisClassParameters = cls.getClass().getConstructors()[0].getParameters();
        Method[] methods = cls.getClass().getDeclaredMethods();
        ArrayList<Method> getMethods = new ArrayList<Method>();
        int numMissingValues = 0;
        int numGetMethods = 0;
        int[] returnValues = new int[3];
        int countBooleanFunctions = 0;
        for (int i = 0; i < methods.length; ++i) {
            String[] parts;
            String methodName = methods[i].getName();
            Method method = null;
            method = cls.getClass().getDeclaredMethod(methodName, new Class[0]);
            String methodS = method.toString();
            if (methodS.toLowerCase().contains("boolean")) {
                ++countBooleanFunctions;
            }
            if ((parts = methodName.split("\\s"))[parts.length - 1].contains("toString") || !parts[parts.length - 1].contains("get")) continue;
            getMethods.add(methods[i]);
            ++numGetMethods;
        }
        boolean checkbadvalue = false;
        for (Method method : getMethods) {
            if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("double")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badDValue, cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("string")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badStringValue, cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("float")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), Float.valueOf(this.badFValue), cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("int")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badIValue, cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("long")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badLValue, cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("short")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badSValue, cls.getClass().getName(), method.getName());
            }
            if (checkbadvalue) {
                ++numMissingValues;
            }
            if (checkbadvalue || !method.getName().toLowerCase().equals("getlocation")) continue;
            ++numMissingValues;
        }
        returnValues[0] = numMissingValues;
        returnValues[1] = numGetMethods;
        returnValues[2] = countBooleanFunctions;
        return returnValues;
    }

    private Map<String, ConfigurationParameterInfo> alternateCategoryData(ConfigurationInfo data, String category) {
        HashMap<String, ConfigurationParameterInfo> returnMap = new HashMap();
        System.out.println(" AlternateCategoryData requested for category " + category);
        try {
            returnMap = data.getCurrentParameterInfoForCategory(category);
        }
        catch (NullPointerException e) {
            System.out.println(" Null pointer exception caught " + e.toString() + " for category " + category);
        }
        return returnMap;
    }

    private Object AssignValuesForMissingBusData(Parameter parameter) {
        Object badValue = null;
        String type = parameter.getParameterizedType().getTypeName().toLowerCase();
        if (type.contains("float")) {
            badValue = Float.valueOf(this.badFValue);
        }
        if (type.contains("int")) {
            badValue = this.badIValue;
        }
        if (type.contains("long")) {
            badValue = this.badLValue;
        }
        if (type.contains("boolean")) {
            badValue = this.badBValue;
        }
        if (type.contains("double")) {
            badValue = this.badDValue;
        }
        if (type.contains("short")) {
            badValue = this.badSValue;
        }
        if (type.contains("string")) {
            badValue = this.badStringValue;
        }
        return badValue;
    }

    private static /* synthetic */ String lambda$reflectedClass$13(SALClassDescription.SALVariable psv) {
        StringBuilder sb = new StringBuilder();
        sb.append(" GenericConverter:reflectedClass: SAL Variable ").append(psv.toString());
        return sb.toString();
    }

    private static /* synthetic */ String lambda$settingsAppliedEventConverter$9(Parameter parameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(" GenericConverter:settingsAppliedConverter: Parameter name of reflected class before constructor invocation- compare to whats on the bus: ").append(parameter.getName());
        return sb.toString();
    }
}

