/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Level;
import org.lsst.ccs.subsystem.shutter.statemachine.State;

class Logging {
    Logging() {
    }

    public static final void logEntry(State<?> state) {
        state.getLogger().fine(() -> String.format("{ENTRY %s OF %s}", state.getName(), state.getContext().getName()));
    }

    public static final void logTransitionAction(State<?> state, String name) {
        state.getLogger().fine(() -> String.format("{TRANSITION ACTION %s}", name));
    }

    public static final void logExit(State<?> state) {
        state.getLogger().fine(() -> String.format("{EXIT %s OF %s}", state.getName(), state.getContext().getName()));
    }

    public static final void logEvent(State<?> state) {
        if (state.getLogger().isLoggable(Level.FINE)) {
            String eventName = new Exception().getStackTrace()[1].getMethodName();
            state.getLogger().fine(String.format("{EVENT %s() IN %s}", eventName, state.getName()));
        }
    }
}

