/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import java.io.File;
import java.util.regex.Pattern;

public abstract class TestUtils {
    public static String getFullPath(String fileName) {
        String targetDir = System.getProperty("hep.aida.test.output.dir");
        if (targetDir != null) {
            File f = new File(targetDir, fileName);
            f.getParentFile().mkdirs();
            fileName = f.getPath();
        }
        return fileName;
    }

    public static String replace(CharSequence target, CharSequence replacement, String string) {
        return Pattern.compile(TestUtils.quote(((Object)target).toString())).matcher(string).replaceAll(TestUtils.quoteReplacement(((Object)replacement).toString()));
    }

    private static String quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuffer sb = new StringBuffer(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    private static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

