/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.indilib.i4j.protocol.OneBlob;

public class INDIBLOBValue
implements Serializable {
    private static final long serialVersionUID = 2475720079344574791L;
    private final byte[] blobData;
    private final String format;

    public INDIBLOBValue(byte[] blobData, String format) {
        this.format = format;
        this.blobData = blobData;
    }

    public INDIBLOBValue(OneBlob xml) {
        int size = 0;
        try {
            String s = xml.getSize().trim();
            size = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Size number not correct");
        }
        if (xml.getFormat() == null) {
            throw new IllegalArgumentException("No format attribute");
        }
        String f = xml.getFormat().trim();
        byte[] val = xml.getByteContent();
        if (f.endsWith(".z")) {
            Inflater decompresser = new Inflater();
            decompresser.setInput(val);
            byte[] newvalue = new byte[size];
            try {
                decompresser.inflate(newvalue);
                val = newvalue;
            }
            catch (DataFormatException e) {
                throw new IllegalArgumentException("Not correctly GZIPped");
            }
            decompresser.end();
            f = f.substring(0, f.length() - 2);
        }
        if (val.length != size) {
            throw new IllegalArgumentException("Size of BLOB not correct");
        }
        this.format = f;
        this.blobData = val;
    }

    public final byte[] getBlobData() {
        return this.blobData;
    }

    public final String getFormat() {
        return this.format;
    }

    public final int getSize() {
        return this.blobData.length;
    }

    public final void saveBLOBData(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(this.blobData);
        }
    }
}

