/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;

public enum Alerts {
    SENSOR_IO(new Alert("SENSOR_IO", "I/O error when attempting to read sensor data.")),
    LIMIT_VIOLATION(new Alert("LIMIT_VIOLATION", "Sensor measurement is out of bounds.")),
    DATA_QUALITY(new Alert("DATA_QUALITY", "Quality flag != Good or an instrument malfunction was reported."));

    private final Alert ccsAlert;

    private Alerts(Alert ccsAlert) {
        this.ccsAlert = ccsAlert;
    }

    public void raise(AlertService alertSvc, AlertState severity, String cause, AlertService.RaiseAlertStrategy strategy) {
        alertSvc.raiseAlert(this.ccsAlert, severity, cause, strategy);
    }

    public static void registerAll(AlertService alertSvc) {
        for (Alerts a : Alerts.values()) {
            alertSvc.registerAlert(a.ccsAlert, AlertService.ALWAYS);
        }
    }

    public static String dataQualityMsg(String locName, String chanName, String quality) {
        return String.format("%1$s %2$s %3$s|Data quality is %3$s for %2$s at %1$s.", locName, chanName, quality);
    }

    public static String analogViolationMsg(String locName, String chanName, double value, double lowerLimit, double upperLimit) {
        return String.format("%1$s %2$s %3$.1f %4$.1f %5$.1f|Limit violation for %2$s at %1$s. Value is %3$.1f, allowed range is [%4$.1f, %5$.1f].", locName, chanName, value, lowerLimit, upperLimit);
    }

    public static String counterViolationMsg(String locName, String chanName, double value) {
        return String.format("%1$s %2$s %3$.4g|Density of %3$.4g/ft^3 for particle size %2$s microns at %1$s is too high.", locName, chanName, value);
    }
}

