/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.drivers.CanCBXAI814;

public class CanOpenSensor14bits
extends Sensor14bits
implements HasLifecycle {
    protected CanCBXAI814 adc;
    @ConfigurationParameter(range="1..8", description="The input number of ADC where the sensor is plugged on.", units="unitless")
    protected int numOfAnalogInput;

    public CanOpenSensor14bits(CanCBXAI814 adc, int numOfAnalogInput) {
        this.adc = adc;
        this.numOfAnalogInput = numOfAnalogInput;
    }

    public int getNumOfAnalogInput() {
        return this.numOfAnalogInput;
    }

    @Override
    public int readNewValue() {
        this.value = this.adc.getInputs()[this.numOfAnalogInput];
        return this.value;
    }

    @Override
    public String getDeviceName() {
        return this.adc.getName();
    }

    @Override
    public void updateValue(int newValue) {
        this.value = newValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/adcName=");
        sb.append(this.adc.name);
        sb.append("/inputNumero=");
        sb.append(this.numOfAnalogInput);
        return sb.toString();
    }
}

