/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.utilities.FitsServiceInterface;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.WFCCDType;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.MetaDataSet;

class PerRebFitsService
implements FitsServiceInterface {
    private static final Logger LOGGER = Logger.getLogger(PerRebFitsService.class.getName());
    private final Map<String, MetaDataSet> geometryReplacementMetaDataSetMap = new HashMap<String, MetaDataSet>();
    private final Map<String, Map<String, HeaderKeywordValue>> headerKeywordValuesMap = new HashMap<String, Map<String, HeaderKeywordValue>>();
    private final Reb reb;
    private final AgentStatusAggregatorService aggregatorService;
    private final String agentName;
    private final Map<String, HeaderSpecification> headerSpecificationsMap;

    PerRebFitsService(String agentName, AgentStatusAggregatorService aggregatorService, Map<String, HeaderSpecification> headerSpecificationsMap, Reb reb) {
        LOGGER.log(Level.FINE, "Configuring Fits Header for geometry {0}", reb.getUniqueId());
        this.reb = reb;
        this.aggregatorService = aggregatorService;
        this.agentName = agentName;
        this.headerSpecificationsMap = headerSpecificationsMap;
        for (String headerName : headerSpecificationsMap.keySet()) {
            if (this.headerKeywordValuesMap.containsKey(headerName)) continue;
            this.headerKeywordValuesMap.put(headerName, new HashMap());
        }
        this.fillHeaderKeywordMapsForReb(reb);
        String raftName = "";
        if (reb.getRaft() != null) {
            raftName = reb.getRaft().getName();
        }
        String rebName = reb.getName();
        this.geometryReplacementMetaDataSetMap.clear();
        MetaDataSet mds = new MetaDataSet();
        mds.addMetaData("", "RAFT", (Object)raftName);
        mds.addMetaData("", "REB", (Object)rebName);
        LOGGER.log(Level.FINE, "Adding default replacements for REB and RAFT: {0} {1}", new Object[]{mds.getValue("REB"), mds.getValue("RAFT")});
        for (CCD ccd : reb.getCCDs()) {
            String ccdName;
            MetaDataSet ccd_mds = new MetaDataSet();
            ccd_mds.addMetaDataSet(mds);
            String ccdTrending = ccdName = ccd.getName();
            if (ccd.getType() instanceof WFCCDType) {
                ccdTrending = "SW";
            }
            ccd_mds.addMetaData("", "CCD", (Object)ccdName);
            ccd_mds.addMetaData("", "CCD_TRENDING", (Object)ccdTrending);
            ccd_mds.addMetaData("", "SENSOR", (Object)String.valueOf(ccd.getSerialPosition()));
            this.geometryReplacementMetaDataSetMap.put(ccd.getUniqueId(), ccd_mds);
            LOGGER.log(Level.FINE, "Adding default replacements for CCD: {0}: {1}", new Object[]{ccd.getUniqueId(), ccd_mds.getValue("CCD")});
        }
    }

    public Reb getReb() {
        return this.reb;
    }

    private void fillHeaderKeywordMapsForReb(Reb reb) {
        for (CCD ccd : reb.getCCDs()) {
            if (this.headerKeywordValuesMap.containsKey(ccd.getUniqueId())) continue;
            this.headerKeywordValuesMap.put(ccd.getUniqueId(), new HashMap());
        }
    }

    private Map<String, HeaderKeywordValue> getHeaderKeywordMapForHeader(String headerName) {
        if (!this.headerKeywordValuesMap.containsKey(headerName)) {
            LOGGER.log(Level.WARNING, "The FitsService is not configured to store data for header {0}", headerName);
            this.headerKeywordValuesMap.put(headerName, new HashMap());
        }
        return this.headerKeywordValuesMap.get(headerName);
    }

    @Override
    public FitsServiceFitsHeaderMetadataProvider getFitsHeaderMetadataProvider(String source) {
        return new FitsServiceFitsHeaderMetadataProvider(source);
    }

    @Override
    public Map<String, HeaderSpecification> getHeaderSpecificationMap() {
        return this.headerSpecificationsMap;
    }

    private MetaDataSet buildMetaDataSetForExtension(String extension) {
        Map<String, HeaderKeywordValue> headerKeywordMap = this.getHeaderKeywordMapForHeader(extension);
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        for (String headerKeyword : headerKeywordMap.keySet()) {
            valuesMap.put(headerKeyword, headerKeywordMap.get(headerKeyword).getValue());
        }
        MetaDataSet result = new MetaDataSet();
        result.addMetaDataMap(extension, valuesMap);
        return result;
    }

    private MetaDataSet getStatusAggregatorMetaDataSet() {
        MetaDataSet m = new MetaDataSet();
        Map aggrMap = this.aggregatorService.getAllLast();
        m.addMetaDataMap("StatusAggregator", aggrMap);
        return m;
    }

    private class FitsServiceFitsHeaderMetadataProvider
    implements FitsHeaderMetadataProvider {
        private final String ccdUniqueId;
        private final Map<String, MetaDataSet> storedMetaDataSets = new HashMap<String, MetaDataSet>();

        public FitsServiceFitsHeaderMetadataProvider(String ccdUniqueId) {
            this.ccdUniqueId = ccdUniqueId;
        }

        private MetaDataSet getMetaDataSet(String key) {
            MetaDataSet result = this.storedMetaDataSets.get(key);
            if (result == null) {
                if (key.equals("statusAggregator")) {
                    result = PerRebFitsService.this.getStatusAggregatorMetaDataSet();
                    result.addMetaData("", "AGENT_NAME", (Object)PerRebFitsService.this.agentName);
                } else {
                    result = key.equals("geometry") ? (MetaDataSet)PerRebFitsService.this.geometryReplacementMetaDataSetMap.get(this.ccdUniqueId) : PerRebFitsService.this.buildMetaDataSetForExtension(key);
                }
                this.storedMetaDataSets.put(key, result);
            }
            return result;
        }

        public MetaDataSet getAdditionalExtendedHeaderMetadata(String extendedKeyword) {
            MetaDataSet r = PerRebFitsService.this.buildMetaDataSetForExtension(extendedKeyword);
            r.addMetaDataSet(this.getMetaDataSet(this.ccdUniqueId));
            r.addMetaDataSet(this.getMetaDataSet("statusAggregator"));
            r.addMetaDataSet(this.getMetaDataSet("geometry"));
            return r;
        }

        public MetaDataSet getDataExtendedHeaderMetadata(String imageExtensionName) {
            MetaDataSet r = new MetaDataSet();
            r.addMetaDataSet(this.getMetaDataSet(this.ccdUniqueId));
            r.addMetaDataSet(this.getMetaDataSet("statusAggregator"));
            r.addMetaDataSet(this.getMetaDataSet("geometry"));
            return r;
        }

        public MetaDataSet getPrimaryHeaderMetadata() {
            MetaDataSet r = new MetaDataSet();
            r.addMetaDataSet(this.getMetaDataSet("primary"));
            r.addMetaDataSet(this.getMetaDataSet(this.ccdUniqueId));
            r.addMetaDataSet(this.getMetaDataSet("statusAggregator"));
            r.addMetaDataSet(this.getMetaDataSet("geometry"));
            return r;
        }
    }

    private class HeaderKeywordValue {
        private final Object value;
        private final boolean sticky;

        HeaderKeywordValue(Object value, boolean sticky) {
            this.value = value;
            this.sticky = sticky;
        }

        Object getValue() {
            return this.value;
        }

        boolean isSticky() {
            return this.sticky;
        }
    }
}

