/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.visualization.rest;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.web.visualization.rest.Image;
import org.lsst.ccs.web.visualization.rest.ImageQueue;

public class FakeImageProvider
implements Closeable {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Logger logger = Logger.getLogger(FakeImageProvider.class.getName());
    private final ImageQueue queue;

    FakeImageProvider(ImageQueue queue) {
        this.queue = queue;
    }

    public void start(Duration duration) {
        Runnable deliverImage = new Runnable(){

            @Override
            public void run() {
                try {
                    Instant instance = Instant.now();
                    File file = File.createTempFile("empty", ".fits");
                    Image latestImage = new Image(file.toPath().toUri(), instance.toString(), instance.toEpochMilli());
                    FakeImageProvider.this.queue.put(latestImage);
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Eror while fetching image", ex);
                }
            }
        };
        scheduler.scheduleAtFixedRate(deliverImage, duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        scheduler.shutdownNow();
    }
}

