/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SynchronousChannel;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class BrakePowerMonitor
implements HasLifecycle,
StatusMessageListener,
AlertListener,
AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger(BrakePowerMonitor.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private volatile Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile StateMachine machine;
    private volatile AgentMessagingLayer aml;
    @ConfigurationParameter(description="The key of the brake voltage value in the KeyValueDataList.", isFinal=true, units="unitless")
    private volatile String brakeVoltageKey = "PDU_24VD/Shtr_Brakes_V";
    @ConfigurationParameter(description="Brake power voltage must be at least this to be considered 'on'.", isFinal=true, units="V")
    private volatile double powerOnThreshold = 23.0;
    private final BlockingQueue<Boolean> eventQueue = new LinkedBlockingQueue<Boolean>();
    private final Scheduler eventScheduler = new Scheduler("brakePower", 1, new ThreadGroup("Brake power monitoring"));
    private volatile boolean lastBrakePowerFailed = true;

    BrakePowerMonitor() {
    }

    public void init() {
        ((AlertService)this.subsys.getAgentService(AlertService.class)).addListener((AlertListener)this);
        ((AlertService)this.subsys.getAgentService(AlertService.class)).startStatusAlertListening(a -> true);
        LOG.info(() -> "Started listening for the alert " + this.brakeVoltageKey + " from the quadbox agent.");
    }

    public void postStart() {
        this.aml = this.subsys.getMessagingAccess();
        this.aml.addStatusMessageListener((StatusMessageListener)this, msg -> this.isQuadboxAgent(msg.getOriginAgentInfo()) && msg instanceof StatusSubsystemData && ((StatusSubsystemData)msg).getObject() instanceof KeyValueDataList);
        LOG.info(() -> "Started listening for quadbox power-status messages.");
        this.aml.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        LOG.info(() -> "Started listening for agent-presence events, looking for quadbox disconnections.");
        List onlineAgents = this.aml.getAgentPresenceManager().listConnectedAgents();
        onlineAgents.stream().filter(agent -> this.isQuadboxAgent((AgentInfo)agent)).forEach(agent -> LOG.log(Level.INFO, "Agent {0} has property {1} = {2}.", new Object[]{agent.toString(), "quadBoxAgent", agent.getAgentProperty("quadBoxAgent")}));
        this.eventScheduler.schedule(this::schedulerLoop, 0L, TimeUnit.SECONDS);
    }

    public void postShutdown() {
        this.eventScheduler.shutdownNow();
        LOG.info(() -> "Shutting down the loop that posts brake-power events.");
        this.aml.removeStatusMessageListener((StatusMessageListener)this);
        LOG.info(() -> "Stopped listening for status bus messages from quadbox.");
        this.aml.getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
        LOG.info(() -> "Stopped listening for agent-presence events for quadbox.");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).removeListener((AlertListener)this);
        LOG.info(() -> "Stopped listening for alerts from quadbox.");
    }

    public void onStatusMessage(StatusMessage rawMsg) {
        List kvdList = ((KeyValueDataList)((StatusSubsystemData)rawMsg).getObject()).getListOfKeyValueData();
        Optional<KeyValueData> kvd = kvdList.stream().filter(k -> k.getKey().equals(this.brakeVoltageKey)).findFirst();
        if (kvd.isPresent()) {
            boolean powerHasFailed;
            double voltage = (Double)kvd.get().getValue();
            boolean bl = powerHasFailed = voltage < this.powerOnThreshold;
            if (powerHasFailed != this.lastBrakePowerFailed) {
                LOG.warning(() -> "Received this quadbox power message: " + rawMsg.toString());
                LOG.warning(() -> this.brakeVoltageKey + " value of " + voltage + "V is " + (powerHasFailed ? "less than " : "greater than or equal to ") + this.powerOnThreshold + "V.");
            }
            this.lastBrakePowerFailed = powerHasFailed;
            this.sendPowerEvent(!powerHasFailed);
        }
    }

    public void onAlert(AlertEvent event) {
        String agentName = event.getSource();
        if (!this.isQuadboxAgentName(agentName)) {
            return;
        }
        switch (event.getType()) {
            case AGENT_CONNECTION: {
                break;
            }
            case AGENT_DISCONNECTION: {
                break;
            }
            case ALERT_CLEARED: {
                List clearedIds = event.getClearedIds();
                boolean brakeAlertCleared = clearedIds.contains(this.brakeVoltageKey);
                if (!brakeAlertCleared) break;
                LOG.warning(() -> "The brake voltage alert was cleared by agent " + agentName + ".");
                LOG.warning(() -> "However, we'll wait until the reported voltage is correct before assuming that the brakes are off.");
                break;
            }
            case ALERT_RAISED: {
                Alert alrt = event.getAlert();
                if (!alrt.getAlertId().equals(this.brakeVoltageKey)) break;
                LOG.warning(() -> "The brake voltage alert was raised by agent " + agentName + ".");
                this.lastBrakePowerFailed = event.getLevel() != AlertState.NOMINAL;
                this.sendPowerEvent(!this.lastBrakePowerFailed);
            }
        }
    }

    public void disconnected(AgentInfo ... agents) {
        Optional<AgentInfo> quadBoxDisc = Stream.of(agents).filter(a -> this.isQuadboxAgent((AgentInfo)a)).findFirst();
        if (quadBoxDisc.isPresent()) {
            LOG.warning(() -> "The quadbox agent " + ((AgentInfo)quadBoxDisc.get()).toString() + " has gone off-line.");
            this.lastBrakePowerFailed = true;
            this.sendPowerEvent(false);
        }
    }

    public void connected(AgentInfo ... agents) {
        Optional<AgentInfo> quadBoxDisc = Stream.of(agents).filter(a -> this.isQuadboxAgent((AgentInfo)a)).findFirst();
        if (quadBoxDisc.isPresent()) {
            LOG.warning(() -> "The quadbox agent " + ((AgentInfo)quadBoxDisc.get()).toString() + " is back on-line.");
            LOG.warning(() -> "However, we'll wait until the reported voltage is correct before assuming that the brakes are off.");
        }
    }

    public boolean isQuadboxAgent(AgentInfo agent) {
        return agent.hasAgentProperty("quadBoxAgent");
    }

    public boolean isQuadboxAgentName(String agentName) {
        List onlineAgents = this.aml.getAgentPresenceManager().listConnectedAgents();
        Optional<AgentInfo> alertingAgent = onlineAgents.stream().filter(agent -> this.isQuadboxAgent((AgentInfo)agent)).filter(agent -> agent.getName().equals(agentName)).findFirst();
        return alertingAgent.isPresent();
    }

    private void sendPowerEvent(boolean powerIsOn) {
        LOG.finer(() -> "Queueing a power event with powerIsOn=" + powerIsOn);
        this.eventQueue.add(powerIsOn);
    }

    private void schedulerLoop() {
        LOG.info("Starting the brake power monitoring task.");
        SynchronousChannel<EventReply> replyChan = new SynchronousChannel<EventReply>();
        block5: while (true) {
            try {
                while (true) {
                    boolean powerIsOn = this.eventQueue.take();
                    try {
                        this.machine.brakePowerChange(replyChan, powerIsOn);
                        EventReply eventReply = (EventReply)replyChan.read();
                        continue block5;
                    }
                    catch (InterruptedException exc) {
                        throw exc;
                    }
                    catch (Exception exc) {
                        LOG.log(Level.SEVERE, "Exception in brake power monitoring task.", exc);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException exc) {
                LOG.info("Normal termination of the brake power monitoring task.");
                return;
            }
        }
    }
}

