/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import org.indilib.i4j.Constants;
import org.indilib.i4j.INDIException;
import org.indilib.i4j.client.INDIElement;
import org.indilib.i4j.client.INDIElementListener;
import org.indilib.i4j.client.INDISwitchProperty;
import org.indilib.i4j.client.INDIValueException;
import org.indilib.i4j.client.INDIViewCreator;
import org.indilib.i4j.protocol.DefElement;
import org.indilib.i4j.protocol.DefSwitch;
import org.indilib.i4j.protocol.OneElement;
import org.indilib.i4j.protocol.OneSwitch;

public class INDISwitchElement
extends INDIElement {
    private INDIElementListener uiComponent;
    private Constants.SwitchStatus status;
    private Constants.SwitchStatus desiredStatus = null;

    protected INDISwitchElement(DefSwitch xml, INDISwitchProperty property) {
        super((DefElement<?>)xml, property);
        this.setValue(xml.getTextContent());
    }

    public Constants.SwitchStatus getValue() {
        return this.status;
    }

    @Override
    protected void setValue(OneElement<?> xml) {
        this.setValue(xml.getTextContent());
        this.notifyListeners();
    }

    private void setValue(String newStatus) {
        if (newStatus.compareTo("Off") == 0) {
            this.status = Constants.SwitchStatus.OFF;
        } else if (newStatus.compareTo("On") == 0) {
            this.status = Constants.SwitchStatus.ON;
        } else {
            throw new IllegalArgumentException("Illegal Switch Status");
        }
    }

    @Override
    public INDIElementListener getDefaultUIComponent() throws INDIException {
        if (this.uiComponent != null) {
            this.removeINDIElementListener(this.uiComponent);
        }
        this.uiComponent = INDIViewCreator.getDefault().createSwitchElementView(this, this.getProperty().getPermission());
        this.addINDIElementListener(this.uiComponent);
        return this.uiComponent;
    }

    @Override
    public boolean checkCorrectValue(Object desiredValue) throws INDIValueException {
        if (desiredValue == null) {
            throw new INDIValueException(this, "null value");
        }
        return desiredValue instanceof Constants.SwitchStatus;
    }

    @Override
    public String getNameAndValueAsString() {
        return this.getName() + " - " + this.getValue();
    }

    public Constants.SwitchStatus getDesiredValue() {
        if (this.desiredStatus == null) {
            return this.status;
        }
        return this.desiredStatus;
    }

    @Override
    public void setDesiredValue(Object desiredValue) throws INDIValueException {
        Constants.SwitchStatus ss = null;
        try {
            ss = (Constants.SwitchStatus)desiredValue;
        }
        catch (ClassCastException e) {
            throw new INDIValueException(this, "Value for a Switch Element must be a SwitchStatus");
        }
        this.desiredStatus = ss;
    }

    @Override
    public boolean isChanged() {
        return true;
    }

    @Override
    protected OneElement<?> getXMLOneElementNewValue() {
        OneSwitch xml = (OneSwitch)((OneSwitch)new OneSwitch().setName(this.getName())).setTextContent(Constants.getSwitchStatusAsString((Constants.SwitchStatus)this.desiredStatus));
        this.desiredStatus = null;
        return xml;
    }

    @Override
    public String getValueAsString() {
        return this.getValue() + "";
    }
}

