/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.sorensen;

import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.drivers.scpi.Scpi;

public class Dcs
extends Scpi
implements PowerSupplyDriver {
    public static final int STAT_CHANNEL = 0;
    public static final int STAT_ONLINE = 1;
    public static final int STAT_STATUS_FLAGS = 2;
    public static final int STAT_STATUS = 3;
    public static final int STAT_ACCUM_STATUS = 4;
    public static final int STAT_FAULT_MASK = 5;
    public static final int STAT_FAULT = 6;
    public static final int STAT_ERROR = 7;
    public static final int STAT_SERIAL = 8;
    public static final int STAT_VOLTAGE = 9;
    public static final int STAT_CURRENT = 10;
    public static final int STAT_OVER_VOLTAGE = 11;
    public static final int STAT_VOLTAGE_DAC_GAIN = 12;
    public static final int STAT_VOLTAGE_DAC_OFFSET = 13;
    public static final int STAT_CURRENT_DAC_GAIN = 14;
    public static final int STAT_CURRENT_DAC_OFFSET = 15;
    public static final int STAT_OVP_DAC_GAIN = 16;
    public static final int STAT_OVP_DAC_OFFSET = 17;
    public static final int STAT_VOLTAGE_ADC_GAIN = 18;
    public static final int STAT_VOLTAGE_ADC_OFFSET = 19;
    public static final int STAT_CURRENT_ADC_GAIN = 20;
    public static final int STAT_CURRENT_ADC_OFFSET = 21;
    public static final int STAT_MODEL = 22;
    public static final int STAT_OVP_CALIBRATED = 23;
    public static final int N_STAT_FIELDS = 24;
    private static final int DEFAULT_PORT = 9221;
    private static final int BAUD_RATE = 19200;

    public void open(DriverConstants.ConnType type, String ident, int parm1, int parm2) throws DriverException {
        super.open(type, ident, parm1 != 0 ? parm1 : (type == DriverConstants.ConnType.NET ? 9221 : 19200), 0);
        try {
            this.checkIdentification("SORENSEN", 0, "DCS", 1);
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void setVoltage(double value, int chan) throws DriverException {
        this.setVoltage(value);
    }

    public void setVoltage(double value) throws DriverException {
        this.write("source:voltage " + value);
    }

    public double getVoltage(int chan) throws DriverException {
        return this.getVoltage();
    }

    public double getVoltage() throws DriverException {
        return this.readDouble("source:voltage?");
    }

    public double readVoltage(int chan) throws DriverException {
        return this.readVoltage();
    }

    public double readVoltage() throws DriverException {
        return this.readDouble("measure:voltage?");
    }

    public void setVoltageLimit(double value) throws DriverException {
        this.write("source:voltage:limit " + value);
    }

    public double getVoltageLimit() throws DriverException {
        return this.readDouble("source:voltage:limit?");
    }

    public void setCurrent(double value, int chan) throws DriverException {
        this.setCurrent(value);
    }

    public void setCurrent(double value) throws DriverException {
        this.write("source:current " + value);
    }

    public double getCurrent(int chan) throws DriverException {
        return this.readCurrent();
    }

    public double getCurrent() throws DriverException {
        return this.readDouble("source:current?");
    }

    public double readCurrent(int chan) throws DriverException {
        return this.readCurrent();
    }

    public double readCurrent() throws DriverException {
        return this.readDouble("measure:current?");
    }

    public void setCurrentLimit(double value) throws DriverException {
        this.write("source:current:limit " + value);
    }

    public double getCurrentLimit() throws DriverException {
        return this.readDouble("source:current:limit?");
    }

    public void setOutput(boolean on, int chan) throws DriverException {
        this.setOutput(on);
    }

    public void setOutput(boolean on) throws DriverException {
        this.write("output:state " + (on ? "on" : "off"));
    }

    public boolean getOutput(int chan) throws DriverException {
        return this.getOutput();
    }

    public boolean getOutput() throws DriverException {
        return this.read("output:state?").equals("1");
    }

    public void setOnDelay(double delay, int chan) throws DriverException {
        if (delay != 0.0) {
            throw new DriverException("Cannot set non-zero power-on delay");
        }
    }

    public void setOffDelay(double delay, int chan) throws DriverException {
        if (delay != 0.0) {
            throw new DriverException("Cannot set non-zero power-off delay");
        }
    }

    public void setLocal(boolean on) throws DriverException {
        this.write("system:local " + (on ? "on" : "off"));
    }

    public boolean getLocal() throws DriverException {
        return this.read("system:local?").equals("1");
    }

    public StatusBlock getStatusBlock() throws DriverException {
        StatusBlock block = new StatusBlock();
        String[] status = this.read("source:status:block?").split(",", 24);
        if (status.length < 23) {
            throw new DriverException("Too few status block fields: " + status.length);
        }
        try {
            block.channel = Integer.decode(status[0]);
            block.online = status[1].equals("1");
            block.statusFlags = this.fromHex(status[2]);
            block.status = this.fromHex(status[3]);
            block.accumStatus = this.fromHex(status[4]);
            block.faultMask = this.fromHex(status[5]);
            block.fault = this.fromHex(status[6]);
            block.error = this.fromHex(status[7]);
            block.serial = status[8];
            block.voltage = Double.valueOf(status[9]);
            block.current = Double.valueOf(status[10]);
            block.overVoltage = Double.valueOf(status[11]);
            block.voltageDacGain = Double.valueOf(status[12]);
            block.voltageDacOffset = Double.valueOf(status[13]);
            block.currentDacGain = Double.valueOf(status[14]);
            block.currentDacOffset = Double.valueOf(status[15]);
            block.ovpDacGain = Double.valueOf(status[16]);
            block.ovpDacOffset = Double.valueOf(status[17]);
            block.voltageAdcGain = Double.valueOf(status[18]);
            block.voltageAdcOffset = Double.valueOf(status[19]);
            block.currentAdcGain = Double.valueOf(status[20]);
            block.currentAdcOffset = Double.valueOf(status[21]);
            block.model = status[22];
            block.ovpCalibrated = status.length > 23 ? status[23].equals("1") : false;
            return block;
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private int fromHex(String value) throws DriverException {
        try {
            return Integer.decode("0x" + value);
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public static class StatusBlock {
        int channel;
        boolean online;
        int statusFlags;
        int status;
        int accumStatus;
        int faultMask;
        int fault;
        int error;
        String serial;
        double voltage;
        double current;
        double overVoltage;
        double voltageDacGain;
        double voltageDacOffset;
        double currentDacGain;
        double currentDacOffset;
        double ovpDacGain;
        double ovpDacOffset;
        double voltageAdcGain;
        double voltageAdcOffset;
        double currentAdcGain;
        double currentAdcOffset;
        String model;
        boolean ovpCalibrated;

        public String toString() {
            return "Channel number:         " + this.channel + "\nOnline:                 " + this.online + "\nStatus flags register:  " + this.toHex4(this.statusFlags) + "\nStatus register:        " + this.toHex4(this.status) + "\nAccumulated status:     " + this.toHex4(this.accumStatus) + "\nFault mask register:    " + this.toHex4(this.faultMask) + "\nFault register:         " + this.toHex4(this.fault) + "\nError register:         " + this.toHex4(this.error) + "\nSerial number:          " + this.serial + "\nModel voltage:          " + this.voltage + "\nModel current:          " + this.current + "\nModel over-voltage:     " + this.overVoltage + "\nVoltage DAC gain:       " + this.voltageDacGain + "\nVoltage DAC offset:     " + this.voltageDacOffset + "\nCurrent DAC gain:       " + this.currentDacGain + "\nCurrent DAC offset:     " + this.currentDacOffset + "\nOVP DAC gain:           " + this.ovpDacGain + "\nOVP DAC offset:         " + this.ovpDacOffset + "\nVoltage ADC gain        " + this.voltageAdcGain + "\nVoltage ADC offset:     " + this.voltageAdcOffset + "\nCurrent ADC gain:       " + this.currentAdcGain + "\nCurrent ADC offset:     " + this.currentAdcOffset + "\nModel string:           " + this.model + "\nOVP calibrated:         " + this.ovpCalibrated;
        }

        private String toHex4(int value) {
            return String.format("0x%04x", value);
        }
    }
}

