/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RestfulClient {
    private final URL serverUrl;
    private final Duration connectionTimeout;
    private final Duration readTimeout;

    public RestfulClient(URL serverUrl, Duration connectionTimeout, Duration readTimeout) {
        this.serverUrl = serverUrl;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String dumpData() throws IOException {
        URLConnection connection = this.serverUrl.openConnection();
        connection.setConnectTimeout((int)this.connectionTimeout.toMillis());
        connection.setReadTimeout((int)this.readTimeout.toMillis());
        connection.connect();
        LinkedList<String> sensorLines = new LinkedList<String>();
        try (BufferedReader sensorStream = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = sensorStream.readLine()) != null) {
                sensorLines.add(line);
            }
        }
        sensorLines.add("");
        return String.join((CharSequence)"\n", sensorLines);
    }

    public final List<Map<String, Object>> fetchData() throws IOException {
        String data = this.dumpData();
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.readValue(data, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
        return new LinkedList<Map<String, Object>>(result.values());
    }

    public static void main(String[] args) throws MalformedURLException, IOException {
        RestfulClient client = new RestfulClient(new URL("http://10.0.1.18:8080/sensors"), Duration.ofSeconds(10L), Duration.ofSeconds(10L));
        List<Map<String, Object>> data = client.fetchData();
        for (Map<String, Object> cluster : data) {
            System.out.println("----------");
            for (String key : cluster.keySet()) {
                System.out.println(key);
                if (key.equals("location")) {
                    System.out.println("    " + cluster.get(key));
                    continue;
                }
                Map channel = (Map)cluster.get(key);
                for (String key2 : channel.keySet()) {
                    System.out.printf("    %s(%s): %s%n", key2, channel.get(key2).getClass().getSimpleName(), channel.get(key2));
                }
            }
        }
        System.out.println(client.dumpData());
    }
}

