/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;
import org.lsst.ccs.subsystem.refrig.PressureTemperatureUtils;

public class SubCoolingChannel
extends DerivedChannel {
    private Channel dischargePressureChannel;
    private Channel liquidTempChannel;

    public void build() {
        if (this.dischargePressureChannel == null || this.liquidTempChannel == null) {
            throw new RuntimeException("Both evapExitTemp and returnPressure channels must be defined and not null. " + this.dischargePressureChannel + " " + this.liquidTempChannel);
        }
        super.build();
    }

    public double evaluateDerivedValue() {
        double tRead = this.liquidTempChannel.getValue();
        double pRead = this.dischargePressureChannel.getValue();
        if (Double.isNaN(pRead) || Double.isNaN(tRead)) {
            return Double.NaN;
        }
        double result = PressureTemperatureUtils.evaluateSaturationTemperature(pRead) - tRead;
        return result;
    }
}

