/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.StrainGauge;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;

public class CanOpenStrainGauge
extends CanOpenDevice
implements StrainGauge {
    final short sampleNR = (short)10;
    final short mode = 0;
    final short cellSensibility = 0;
    final short digital_out_logic = 0;
    final short digital_out_mode = 0;
    final short digital_in_or_selection = 0;
    final short senseRatio = (short)10;
    final short cellFullScale = 0;
    final short knownWeightValue = 0;
    final short thresholdValue = 0;
    final short deltaWeight = 0;
    final short deltaTime = 0;
    final short adcSpeed = 0;
    final short hysteresis = 0;
    protected short strain;
    int adcValue;

    public void configureRegister1() {
        boolean size = true;
        this.writeSDO(8455, 1, 1, 10L);
        this.writeSDO(8455, 2, 1, 0L);
        this.writeSDO(8455, 3, 1, 0L);
        this.writeSDO(8455, 4, 1, 0L);
        this.writeSDO(8455, 5, 1, 0L);
        this.writeSDO(8455, 6, 1, 0L);
    }

    public void configureRegister2() {
        boolean size = true;
        this.writeSDO(8456, 1, 1, 10L);
        this.writeSDO(8456, 2, 1, 0L);
        this.writeSDO(8456, 3, 1, 0L);
        this.writeSDO(8456, 6, 1, 0L);
        this.writeSDO(8456, 7, 1, 0L);
        this.writeSDO(8456, 8, 1, 0L);
        this.writeSDO(8456, 9, 1, 0L);
        this.writeSDO(8456, 10, 1, 0L);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read internal temperature in degrees Celsius.")
    public double readTemperature() {
        return (double)((short)this.readSDO(8240, 1)) * 0.1;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read the strain value (or weight) : Integer net value (signed).")
    public short readStrain() {
        return (short)this.readSDO(25601, 1);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the ADC value.")
    public int readAdcValue() {
        this.adcValue = (int)this.readSDO(25601, 2);
        return this.adcValue;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read 32 bit float input value.")
    public int readStrain32bitFloat() {
        return (int)this.readSDO(25603, 1);
    }
}

