/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOSCarousel;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class SimuCarouselController
extends CanOpenEPOSCarousel {
    private static final Logger FCSLOG = Logger.getLogger(SimuCarouselController.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private SimuTTC580 hyttc580;
    protected int targetPosition;
    protected int ssiPosition;
    protected int targetCurrent;
    protected int actualCurrent;

    public SimuCarouselController() {
        this.position = 0;
        this.mode = EPOSEnumerations.EposMode.PROFILE_POSITION;
        this.simuEnabled = false;
        this.statusWord = 64;
        this.eposState = EPOSEnumerations.EposState.SWITCH_ON_DISABLED;
    }

    @Override
    public void init() {
        super.init();
        this.updateFakePDOData(this.cobid1, 0L);
        this.updateFakePDOData(this.cobid2, 0L);
    }

    @Override
    public void build() {
        super.build();
        this.statusWord = 64;
        this.simulateStatusWord(this.statusWord);
        this.setProfileAcceleration(2000L);
        this.setProfileDeceleration(1000L);
        this.setProfileVelocity(3400L);
    }

    @Override
    public void goToSwitchOnDisabled() {
        this.simulateSWITCH_ON_DISABLED();
    }

    public void setSsiPosition(int ssiPosition) {
        this.ssiPosition = ssiPosition;
        this.position = ssiPosition;
        this.simulatePosition(ssiPosition);
    }

    @Override
    public void setPositionSensorTypeSinusIncrementalEncoder() {
        this.setPositionSensorType(8);
    }

    @Override
    public void setPositionSensorTypeEncoderSSI() {
        this.setPositionSensorType(4);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.")
    public void writeTargetPosition(int absolutePosition) throws FcsHardwareException {
        FCSLOG.info(this.name + " => carousel is rotating.");
        FCSLOG.info(this.name + " => initial position=" + this.position);
        FCSLOG.info(this.name + " => target position=" + absolutePosition);
        int iterNB = 10;
        int initialPosition = this.carousel.getPosition();
        int step = (absolutePosition - initialPosition) / iterNB;
        FCSLOG.info("step=" + step);
        try {
            for (int i = 1; i < iterNB; ++i) {
                int newPos = initialPosition + i * step;
                this.setSsiPosition(newPos);
                FCSLOG.info(this.name + " i=" + i + ", position=" + this.position);
                try {
                    Thread.sleep(50L);
                    if (!this.carousel.getHaltRequired().get()) continue;
                    FCSLOG.fine(() -> this.name + " STOP simulated carousel motion.");
                    return;
                }
                catch (InterruptedException ex) {
                    throw new FcsHardwareException(this.name + " sleep was interrupted.", ex);
                }
            }
            int finalPos = absolutePosition % this.carousel.getFullTurn();
            this.setSsiPosition(finalPos);
            this.hyttc580.simulateSocketSensors(finalPos);
            this.carousel.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            FCSLOG.log(Level.SEVERE, this.name + " should not raise an Exception:", ex);
        }
    }

    public void updateFakePDOData(int cobid, long newPdo) {
        if (cobid == this.cobid1) {
            this.setPdo1(newPdo);
        } else if (cobid == this.cobid2) {
            this.setPdo2(newPdo);
        }
        ((SimuCanOpenInterface)this.tcpProxy.getCanInterface()).simulatePDOData(cobid, newPdo);
    }

    public void simulatePosition(int pos) {
        FCSLOG.finer("simulate carousel position : " + pos);
        long pdo = (long)pos << 32;
        long mask = 0xFFFFFFFFL;
        long newpdo = pdo | this.getPdo1() & mask;
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateStatusWord(int sw) {
        FCSLOG.finer("simulate carouselController statusWord : " + sw);
        long pdo = sw;
        long mask = -65536L;
        long newpdo = pdo | this.getPdo1() & mask;
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateSWITCH_ON_DISABLED() {
        this.simulateStatusWord(64);
        this.carousel.updateStateWithSensors();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="For simulator only : Update position with a position given as argument.")
    public void setPosition(int actualPosition) {
        this.position = actualPosition;
    }

    @Override
    public boolean isTargetReached() {
        return this.position == this.targetPosition || this.actualCurrent == this.targetCurrent;
    }

    @Override
    public boolean isParametersOK() {
        return true;
    }

    @Override
    public void defineAbsolutePosition(int position) {
        this.position = position;
    }

    @Override
    public void writeParameters(EPOSEnumerations.EposMode mode) {
    }

    @Override
    public void writeParameter(EPOSEnumerations.Parameter param, int value) {
        if (param == EPOSEnumerations.Parameter.PositionSensorType) {
            this.setPositionSensorType(value);
        }
    }

    @Override
    public long readParameter(EPOSEnumerations.Parameter parameter) {
        if (parameter == EPOSEnumerations.Parameter.PositionSensorType) {
            return this.positionSensorType;
        }
        return 0L;
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) {
    }

    @Override
    public void writeCurrent(int aValue) {
        this.actualCurrent = aValue;
    }

    @Override
    public void stopAction() {
    }

    @Override
    public int readPosition() {
        return this.position;
    }

    @Override
    public int readSSIPosition() {
        return this.ssiPosition;
    }

    @Override
    public int readCurrent() {
        return this.actualCurrent;
    }

    @Override
    public EPOSEnumerations.EposMode readMode() {
        return this.mode;
    }

    @Override
    public int readStatusWord() {
        return this.statusWord;
    }

    @Override
    public void quickStop() {
        FCSLOG.finest(() -> this.name + " quickStop done.");
    }

    @Override
    public int getErrorHistoryNB() {
        return 0;
    }

    @Override
    public int readErrorRegister() {
        return 0;
    }

    @Override
    public void updateErrorHistory() {
        this.errorHistory = new int[0];
    }

    @Override
    public String updateAndDisplayErrorHistory() {
        this.updateErrorHistory();
        return "No ERROR";
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() {
    }

    @Override
    public void checkFault(boolean withPublication) {
    }

    @Override
    public String readParametersForMode(EPOSEnumerations.EposMode mode) {
        return this.getName() + ":no parameter to read.";
    }

    @Override
    public void checkParameters(EPOSEnumerations.EposMode aMode) {
    }

    @Override
    public void writeControlWord(int w) {
        FCSLOG.finer(this.name + " writeControlWord : 0x" + Integer.toHexString(w) + " (in decimal:" + w + ")");
        switch (w) {
            case 7: {
                this.statusWord = 35;
                break;
            }
            case 0: {
                this.statusWord = 64;
                break;
            }
            case 6: {
                this.statusWord = 33;
                break;
            }
            case 15: {
                this.statusWord = 39;
                break;
            }
            default: {
                this.statusWord = w;
            }
        }
        this.simulateStatusWord(this.statusWord);
        FCSLOG.info(this.name + " statusWord = 0x" + Integer.toHexString(this.statusWord));
    }
}

