/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;

public class BasicTelnetClient
implements Runnable {
    static TelnetClient tc = null;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: BasicClient <remote-ip> [<remote-port>]");
            System.exit(1);
        }
        String remoteip = args[0];
        int remoteport = args.length > 1 ? Integer.decode(args[1]) : 23;
        tc = new TelnetClient();
        tc.addOptionHandler((TelnetOptionHandler)new EchoOptionHandler());
        tc.addOptionHandler((TelnetOptionHandler)new SuppressGAOptionHandler(true, true, true, true));
        boolean end_loop = false;
        try {
            tc.connect(remoteip, remoteport);
            Thread reader = new Thread(new BasicTelnetClient());
            reader.start();
            OutputStream outstr = tc.getOutputStream();
            byte[] buff = new byte[1024];
            int ret_read = 0;
            do {
                try {
                    ret_read = System.in.read(buff);
                    if (ret_read <= 0) continue;
                    String line = new String(buff, 0, ret_read);
                    try {
                        outstr.write(buff, 0, ret_read);
                        outstr.flush();
                    }
                    catch (IOException e) {
                        end_loop = true;
                    }
                }
                catch (IOException e) {
                    System.err.println("Exception while reading keyboard:" + e.getMessage());
                    end_loop = true;
                }
            } while (ret_read > 0 && !end_loop);
            try {
                tc.disconnect();
            }
            catch (IOException e) {
                System.err.println("Exception while connecting:" + e.getMessage());
            }
        }
        catch (IOException e) {
            System.err.println("Exception while connecting:" + e.getMessage());
            System.exit(1);
        }
    }

    @Override
    public void run() {
        InputStream instr = tc.getInputStream();
        try {
            byte[] buff = new byte[1024];
            int ret_read = 0;
            do {
                if ((ret_read = instr.read(buff)) <= 0) continue;
                System.out.print(new String(buff, 0, ret_read));
            } while (ret_read >= 0);
        }
        catch (IOException e) {
            System.err.println("Exception while reading socket:" + e.getMessage());
        }
        try {
            tc.disconnect();
        }
        catch (IOException e) {
            System.err.println("Exception while closing telnet:" + e.getMessage());
        }
    }
}

