/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;
import org.jgroups.util.Tuple;

public class LOCAL_PING
extends Discovery {
    protected static final Map<String, List<PingData>> discovery = new ConcurrentHashMap<String, List<PingData>>();
    protected static final Function<String, List<PingData>> FUNC = k -> new ArrayList();

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void stop() {
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, List<PingData>> map = discovery;
        synchronized (map) {
            discovery.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Dumps the contents of the discovery cache")
    public static String print() {
        StringBuilder sb = new StringBuilder();
        Map<String, List<PingData>> map = discovery;
        synchronized (map) {
            for (Map.Entry<String, List<PingData>> e : discovery.entrySet()) {
                sb.append(e.getKey()).append(": ").append(e.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="Number of keys in the discovery cache")
    public static int getDiscoveryCacheSize() {
        Map<String, List<PingData>> map = discovery;
        synchronized (map) {
            return discovery.size();
        }
    }

    @Override
    public Responses findMembers(List<Address> members, boolean initial_discovery, boolean async, long timeout) {
        return super.findMembers(members, initial_discovery, false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        ++this.num_discovery_requests;
        Map<String, List<PingData>> map = discovery;
        synchronized (map) {
            List<PingData> list = discovery.get(this.cluster_name);
            if (list != null) {
                list.forEach(d -> {
                    this.addAddressToLocalCache(d.sender, d.physical_addr);
                    responses.addResponse((PingData)d, false);
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        if (evt.type() == 6 && this.cluster_name != null) {
            Address old_coord = this.view != null ? this.view.getCoord() : null;
            boolean was_coord = Objects.equals(this.local_addr, old_coord);
            Object retval = super.down(evt);
            Map<String, List<PingData>> map = discovery;
            synchronized (map) {
                List<PingData> list = discovery.get(this.cluster_name);
                if (list != null && !list.isEmpty()) {
                    for (PingData d : list) {
                        Address mbr = d.getAddress();
                        if (this.down_prot.down(new Event(87, mbr)) == null) {
                            this.down_prot.down(new Event(89, new Tuple<Address, PhysicalAddress>(mbr, d.getPhysicalAddr())));
                        }
                        if (!Objects.equals(this.local_addr, mbr)) continue;
                        if (!was_coord && this.is_coord) {
                            d.coord(true);
                            this.log.trace("%s: became coordinator (view: %s)", this.local_addr, this.view);
                        }
                        if (!was_coord || this.is_coord) continue;
                        d.coord(false);
                        this.log.trace("%s: ceased to be coordinator (view: %s)", this.local_addr, this.view);
                    }
                }
            }
            return retval;
        }
        return super.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnect() {
        if (this.cluster_name == null || this.local_addr == null) {
            throw new IllegalStateException("cluster name and local address cannot be null");
        }
        String logical_name = NameCache.get(this.local_addr);
        PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
        if (physical_addr != null) {
            PingData data = new PingData(this.local_addr, this.is_server, logical_name, physical_addr);
            Map<String, List<PingData>> map = discovery;
            synchronized (map) {
                List<PingData> list = discovery.computeIfAbsent(this.cluster_name, FUNC);
                if (list.isEmpty()) {
                    data.coord(true);
                }
                list.add(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDisconnect() {
        if (this.local_addr == null || this.cluster_name == null) {
            return;
        }
        Map<String, List<PingData>> map = discovery;
        synchronized (map) {
            List<PingData> list = discovery.get(this.cluster_name);
            if (list != null) {
                list.removeIf(p -> Objects.equals(this.local_addr, p.getAddress()));
                if (list.isEmpty()) {
                    discovery.remove(this.cluster_name);
                }
            }
        }
    }

    protected void addAddressToLocalCache(Address addr, PhysicalAddress phys_addr) {
        Tuple<Address, PhysicalAddress> tuple = new Tuple<Address, PhysicalAddress>(addr, phys_addr);
        this.down_prot.down(new Event(89, tuple));
    }
}

