/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.status;

import java.util.Objects;

public enum PtpDeviceState {
    NO_OPERATION,
    INITIALIZING,
    FAULTY,
    DISABLED,
    LISTENING,
    PRE_MASTER,
    MASTER,
    PASSIVE,
    UNCALIBRATED,
    SLAVE;

    private static final long serialVersionUID = 1L;

    public static PtpDeviceState fromStateNumber(int n) throws IllegalArgumentException {
        try {
            return PtpDeviceState.values()[n];
        }
        catch (IndexOutOfBoundsException exc) {
            throw new IllegalArgumentException(String.format("%d is not in the range [0, %d]", n, PtpDeviceState.values().length - 1));
        }
    }

    public static int toStateNumber(PtpDeviceState state) {
        return Objects.requireNonNull(state, "Argument must be non-null.").ordinal();
    }
}

