/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.io;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StatefulWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import org.indilib.i4j.protocol.DefBlob;
import org.indilib.i4j.protocol.DefBlobVector;
import org.indilib.i4j.protocol.DefElement;
import org.indilib.i4j.protocol.DefLight;
import org.indilib.i4j.protocol.DefLightVector;
import org.indilib.i4j.protocol.DefNumber;
import org.indilib.i4j.protocol.DefNumberVector;
import org.indilib.i4j.protocol.DefSwitch;
import org.indilib.i4j.protocol.DefSwitchVector;
import org.indilib.i4j.protocol.DefText;
import org.indilib.i4j.protocol.DefTextVector;
import org.indilib.i4j.protocol.DefVector;
import org.indilib.i4j.protocol.DelProperty;
import org.indilib.i4j.protocol.EnableBLOB;
import org.indilib.i4j.protocol.GetProperties;
import org.indilib.i4j.protocol.INDIProtocol;
import org.indilib.i4j.protocol.Message;
import org.indilib.i4j.protocol.NewBlobVector;
import org.indilib.i4j.protocol.NewLightVector;
import org.indilib.i4j.protocol.NewNumberVector;
import org.indilib.i4j.protocol.NewSwitchVector;
import org.indilib.i4j.protocol.NewTextVector;
import org.indilib.i4j.protocol.NewVector;
import org.indilib.i4j.protocol.OneBlob;
import org.indilib.i4j.protocol.OneElement;
import org.indilib.i4j.protocol.OneLight;
import org.indilib.i4j.protocol.OneNumber;
import org.indilib.i4j.protocol.OneSwitch;
import org.indilib.i4j.protocol.OneText;
import org.indilib.i4j.protocol.SetBlobVector;
import org.indilib.i4j.protocol.SetLightVector;
import org.indilib.i4j.protocol.SetNumberVector;
import org.indilib.i4j.protocol.SetSwitchVector;
import org.indilib.i4j.protocol.SetTextVector;
import org.indilib.i4j.protocol.SetVector;
import org.indilib.i4j.protocol.api.INDIInputStream;
import org.indilib.i4j.protocol.api.INDIOutputStream;
import org.indilib.i4j.protocol.io.INDIInputStreamImpl;
import org.indilib.i4j.protocol.io.INDIOutputStreamImpl;
import org.indilib.i4j.protocol.io.MinimalBlockinInputStream;
import org.indilib.i4j.protocol.io.Printwriter;

public final class INDIProtocolFactory {
    private static final int BUFFER_SIZE = 16384;
    private static final byte[] CLOSE_BYTES = "</X>".getBytes();
    private static final byte[] OPEN_BYTES = "<X>".getBytes();
    private static final HierarchicalStreamDriver STREAM_DRIVER = new XppDriver(){

        public HierarchicalStreamWriter createWriter(Writer out) {
            return new Printwriter(out);
        }
    };
    private static final XStream XSTREAM = new XStream(STREAM_DRIVER);

    private INDIProtocolFactory() {
    }

    public static INDIInputStream createINDIInputStream(InputStream in) throws IOException {
        return new INDIInputStreamImpl(XSTREAM.createObjectInputStream(INDIProtocolFactory.inputStreamWithRootTag(new BufferedInputStream(new MinimalBlockinInputStream(in), 16384))));
    }

    public static INDIOutputStream createINDIOutputStream(OutputStream out) throws IOException {
        final StatefulWriter statefulWriter = new StatefulWriter(STREAM_DRIVER.createWriter((OutputStream)new BufferedOutputStream(out, 16384)));
        return new INDIOutputStreamImpl(new CustomObjectOutputStream(new CustomObjectOutputStream.StreamCallback(){

            public void close() {
                if (statefulWriter.state() != StatefulWriter.STATE_CLOSED) {
                    statefulWriter.close();
                }
            }

            public void defaultWriteObject() throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void flush() {
                statefulWriter.flush();
            }

            public void writeFieldsToStream(Map fields) throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void writeToStream(Object object) {
                XSTREAM.marshal(object, (HierarchicalStreamWriter)statefulWriter);
            }
        }));
    }

    private static InputStream inputStreamWithRootTag(final InputStream in) {
        Enumeration<InputStream> streamEnum = new Enumeration<InputStream>(){
            private int index = 0;
            private final InputStream[] streams = new InputStream[]{new ByteArrayInputStream(INDIProtocolFactory.access$100()), in, new ByteArrayInputStream(INDIProtocolFactory.access$200())};

            @Override
            public boolean hasMoreElements() {
                return this.index < this.streams.length;
            }

            @Override
            public InputStream nextElement() {
                return this.streams[this.index++];
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)streamEnum);
    }

    public static String toString(INDIProtocol<?> protocol) {
        return protocol.getClass().getSimpleName() + " " + XSTREAM.toXML(protocol);
    }

    public static String toXml(INDIProtocol<?> protocol) {
        return XSTREAM.toXML(protocol);
    }

    static /* synthetic */ byte[] access$100() {
        return OPEN_BYTES;
    }

    static /* synthetic */ byte[] access$200() {
        return CLOSE_BYTES;
    }

    static {
        XSTREAM.processAnnotations(new Class[]{DefBlob.class, DefBlobVector.class, DefElement.class, DefLight.class, DefLightVector.class, DefNumber.class, DefNumberVector.class, DefSwitch.class, DefSwitchVector.class, DefText.class, DefTextVector.class, DefVector.class, DelProperty.class, EnableBLOB.class, GetProperties.class, INDIProtocol.class, Message.class, NewBlobVector.class, NewLightVector.class, NewNumberVector.class, NewSwitchVector.class, NewTextVector.class, NewVector.class, OneBlob.class, OneElement.class, OneLight.class, OneNumber.class, OneText.class, OneSwitch.class, SetBlobVector.class, SetLightVector.class, SetNumberVector.class, SetSwitchVector.class, SetTextVector.class, SetVector.class});
    }
}

